/*
 * Decompiled with CFR 0.152.
 */
package ccl.jcf;

import java.util.Date;
import java.util.Enumeration;
import lti.java.jcf.CptClass;
import lti.java.jcf.CptDouble;
import lti.java.jcf.CptFloat;
import lti.java.jcf.CptGeneric;
import lti.java.jcf.CptInteger;
import lti.java.jcf.CptLong;
import lti.java.jcf.CptMemberOrInterface;
import lti.java.jcf.CptNameType;
import lti.java.jcf.CptString;
import lti.java.jcf.CptUTF;
import lti.java.jcf.CptUnicode;
import lti.java.jcf.JcfAttribute;
import lti.java.jcf.JcfAttributeCollection;
import lti.java.jcf.JcfClassFile;
import lti.java.jcf.JcfCodeAttribute;
import lti.java.jcf.JcfConstantPool;
import lti.java.jcf.JcfInterfaceCollection;
import lti.java.jcf.JcfMember;
import lti.java.jcf.JcfMemberCollection;
import lti.java.jcf.RuntimeConstants;

public class DumpClassToTxt
implements RuntimeConstants {
    public static final int OMIT_CONSTPOOL = 1;
    public static final int OMIT_CLASSDESC = 2;
    public static final int OMIT_INTERFACES = 4;
    public static final int OMIT_FIELDS = 8;
    public static final int OMIT_METHODS = 16;
    public static final int OMIT_EXTRAATTRIBUTES = 32;
    public static final int OMIT_ALLATTRIBUTES = 64;
    protected JcfClassFile jcf;
    protected JcfConstantPool cp;
    protected StringBuffer output;
    protected int flags;

    public DumpClassToTxt(JcfClassFile jcf, StringBuffer output, int flags) throws Exception {
        this.jcf = jcf;
        this.cp = jcf.getConstantPool();
        this.output = output;
        this.flags = flags;
    }

    public void dump() {
        JcfMemberCollection members;
        Date now = new Date();
        this.println("Class Dump: " + this.jcf.getFullName());
        this.println("JavaDump 1.0 - Copyright 1997 Matt Yourst");
        this.println("Dump of class:");
        this.println("" + this.jcf.getFullName().replace('/', '.'));
        this.println("(Generated " + now.toString() + ")");
        this.println();
        this.println("Table of Contents");
        if ((this.flags & 1) == 0) {
            this.println(" - Constant Pool");
        }
        if ((this.flags & 2) == 0) {
            this.println(" - Class Descriptor");
        }
        if ((this.flags & 4) == 0) {
            this.println(" - Interfaces");
        }
        if ((this.flags & 8) == 0) {
            this.println(" - Fields");
        }
        if ((this.flags & 0x10) == 0) {
            this.println(" - Methods");
        }
        if ((this.flags & 0x20) == 0) {
            this.println(" - Attributes");
        }
        this.println();
        if ((this.flags & 1) == 0) {
            this.cp = this.jcf.getConstantPool();
            this.printConstantPool();
        }
        if ((this.flags & 2) == 0) {
            this.println("Class Descriptor");
            this.println("Access flags: 0x" + Integer.toHexString(this.jcf.hdrAccessFlags));
            this.println("This class: " + DumpClassToTxt.cpRef(this.jcf.hdrThisClassName) + " (" + this.cp.classNameAt(this.jcf.hdrThisClassName) + ")");
            this.println("Superclass: " + DumpClassToTxt.cpRef(this.jcf.hdrSuperClassName) + " (" + this.cp.classNameAt(this.jcf.hdrSuperClassName) + ")");
            this.println();
        }
        if ((this.flags & 4) == 0) {
            JcfInterfaceCollection interfaces = this.jcf.getInterfaces();
            int m = interfaces.data.length;
            this.println("Interfaces (" + m + ")");
            int i = 0;
            while (i < m) {
                short j = interfaces.data[i];
                this.println(" - " + DumpClassToTxt.cpRef(j) + " (" + this.cp.classNameAt(j) + ")");
                ++i;
            }
            this.println();
        }
        if ((this.flags & 8) == 0) {
            members = this.jcf.getFields();
            this.printMembers(members, "Fields");
        }
        if ((this.flags & 0x10) == 0) {
            members = this.jcf.getMethods();
            this.printMembers(members, "Methods");
        }
        if ((this.flags & 0x20) == 0) {
            this.println("Attributes (" + this.jcf.getAttributes().size() + ")");
            this.printAttributes(this.jcf.getAttributes());
        }
        this.println("\nEnd of report");
        this.println("Report produced by JavaDump 1.0. Copyright 1997 Matt Yourst.");
    }

    protected static String cpRef(int cpr) {
        return "" + cpr;
    }

    protected void printConstantPool() {
        this.println("Constant Pool (" + this.cp.size() + " slots)");
        this.println();
        this.println("Index Type        Data");
        Enumeration e = this.cp.elements();
        int i = 0;
        while (e.hasMoreElements()) {
            CptGeneric cpEntry = (CptGeneric)e.nextElement();
            if (cpEntry == null) {
                ++i;
                continue;
            }
            this.print("" + i++ + "     ");
            switch (cpEntry.getTag()) {
                case 1: {
                    this.print("UTF-8       \"" + ((CptUTF)cpEntry).value + "\" (" + ((CptUTF)cpEntry).value.length() + " chars)");
                    break;
                }
                case 12: {
                    this.print("NameType    name " + DumpClassToTxt.cpRef(((CptNameType)cpEntry).nameIndex) + " type " + DumpClassToTxt.cpRef(((CptNameType)cpEntry).signatureIndex));
                    break;
                }
                case 7: {
                    this.print("Class       name " + DumpClassToTxt.cpRef(((CptClass)cpEntry).nameIndex));
                    break;
                }
                case 10: {
                    this.print("Method      class " + DumpClassToTxt.cpRef(((CptMemberOrInterface)cpEntry).classIndex) + " type " + DumpClassToTxt.cpRef(((CptMemberOrInterface)cpEntry).nameTypeIndex));
                    break;
                }
                case 9: {
                    this.print("Field       class " + DumpClassToTxt.cpRef(((CptMemberOrInterface)cpEntry).classIndex) + " type " + DumpClassToTxt.cpRef(((CptMemberOrInterface)cpEntry).nameTypeIndex));
                    break;
                }
                case 8: {
                    this.print("String      data " + DumpClassToTxt.cpRef(((CptString)cpEntry).StringIndex));
                    break;
                }
                case 3: {
                    this.print("Integer     " + ((CptInteger)cpEntry).value);
                    break;
                }
                case 4: {
                    this.print("Float       " + ((CptFloat)cpEntry).value);
                    break;
                }
                case 5: {
                    this.print("Long        " + ((CptLong)cpEntry).value);
                    break;
                }
                case 6: {
                    this.print("Double      " + ((CptDouble)cpEntry).value);
                    break;
                }
                case 11: {
                    this.print("IntMethod   class " + DumpClassToTxt.cpRef(((CptMemberOrInterface)cpEntry).classIndex) + " type " + DumpClassToTxt.cpRef(((CptMemberOrInterface)cpEntry).nameTypeIndex));
                    break;
                }
                case 2: {
                    this.print("Unicode     " + ((CptUnicode)cpEntry).value.length + " bytes");
                    break;
                }
                default: {
                    this.print("???         ???");
                }
            }
            this.println();
        }
        this.println();
    }

    protected void printMembers(JcfMemberCollection members, String fieldOrMethod) {
        Enumeration e = members.elements();
        this.println("" + fieldOrMethod + " (" + members.size() + ")");
        while (e.hasMoreElements()) {
            JcfMember member = (JcfMember)e.nextElement();
            this.println(" - " + this.cp.utfAt(member.mbrNameIndex) + " (" + DumpClassToTxt.cpRef(member.mbrNameIndex) + ") signature \"" + this.cp.utfAt(member.mbrSignatureIndex) + "\" (" + DumpClassToTxt.cpRef(member.mbrSignatureIndex) + ") access 0x" + Integer.toHexString(member.mbrAccessFlags));
            this.printAttributes(member.getAttributes());
        }
        this.println();
    }

    protected void printAttributes(JcfAttributeCollection attrs) {
        if ((this.flags & 0x40) != 0) {
            return;
        }
        Enumeration e = attrs.elements();
        while (e.hasMoreElements()) {
            byte[] data;
            JcfAttribute attr = (JcfAttribute)e.nextElement();
            String attrname = this.cp.utfAt(attr.getNameIndex());
            this.println("   . \"" + attrname + "\" (" + DumpClassToTxt.cpRef(attr.getNameIndex()) + "): " + attr.getLength() + " bytes");
            if (attrname.equals("Code")) {
                JcfCodeAttribute codeattr = (JcfCodeAttribute)attr;
                this.println("     [stack words: " + codeattr.catMaxStack + ", local words: " + codeattr.catMaxLocals + ", bytecode: " + codeattr.catCode.length + " bytes]");
                this.printAttributes(codeattr.catExtraAttributes);
                continue;
            }
            if (attrname.equals("ConstantValue")) {
                data = attr.getData();
                this.println("     [constant: " + DumpClassToTxt.cpRef(data[0] << 8 | data[1]) + "]");
                continue;
            }
            if (!attrname.equals("SourceFile")) continue;
            data = attr.getData();
            int idx = (data[0] & 0xFF) << 8 | data[1] & 0xFF;
            this.println("     [filename: " + DumpClassToTxt.cpRef(idx) + " = " + this.cp.utfAt(idx) + "]");
        }
    }

    protected final void println(String s) {
        this.output.append(s).append('\n');
    }

    protected final void print(String s) {
        this.output.append(s);
    }

    protected final void println() {
        this.output.append('\n');
    }
}

