/*******************************************************************************
 * Copyright (c) 2000, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.help.ui.internal.ide;
import org.eclipse.core.runtime.*;
import org.eclipse.help.internal.base.*;
import org.eclipse.help.ui.internal.util.*;
import org.eclipse.help.ui.internal.workingset.*;
import org.eclipse.ui.*;
import org.eclipse.ui.plugin.*;
import org.osgi.framework.*;

/**
 * This class is a Help IDE plugin.
 */
public class HelpIdePlugin extends AbstractUIPlugin {
	public final static String PLUGIN_ID = "org.eclipse.help.ide"; //$NON-NLS-1$
	// debug options
	public static boolean DEBUG = false;

	private static HelpIdePlugin plugin;
	private static BundleContext bundleContext;
	private HelpWorkingSetSynchronizer workingSetListener;

	/**
	 * Logs an Error message with an exception. Note that the message should
	 * already be localized to proper locale. ie: Resources.getString() should
	 * already have been called
	 */
	public static synchronized void logError(String message, Throwable ex) {
		if (message == null)
			message = ""; //$NON-NLS-1$
		Status errorStatus = new Status(IStatus.ERROR, PLUGIN_ID, IStatus.OK,
				message, ex);
		HelpBasePlugin.getDefault().getLog().log(errorStatus);
	}
	/**
	 * Logs a Warning message with an exception. Note that the message should
	 * already be localized to proper local. ie: Resources.getString() should
	 * already have been called
	 */
	public static synchronized void logWarning(String message) {
		if (HelpBasePlugin.DEBUG) {
			if (message == null)
				message = ""; //$NON-NLS-1$
			Status warningStatus = new Status(IStatus.WARNING, PLUGIN_ID,
					IStatus.OK, message, null);
			HelpBasePlugin.getDefault().getLog().log(warningStatus);
		}
	}

	/**
	 * Provides access to singleton
	 * 
	 * @return HelpIDEPlugin
	 */
	public static HelpIdePlugin getDefault() {
		return plugin;
	}
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.osgi.framework.BundleActivator#stop(org.osgi.framework.BundleContext)
	 */
	public void stop(BundleContext context) throws Exception {
		if (BaseHelpSystem.getMode() == BaseHelpSystem.MODE_WORKBENCH) {
			if (PlatformUI.isWorkbenchRunning()) {
				PlatformUI.getWorkbench().getWorkingSetManager()
						.removePropertyChangeListener(workingSetListener);
			}
			BaseHelpSystem.getWorkingSetManager().removePropertyChangeListener(
					workingSetListener);
		}
		plugin = null;
		bundleContext = null;
		super.stop(context);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.osgi.framework.BundleActivator#start(org.osgi.framework.BundleContext)
	 */
	public void start(BundleContext context) throws Exception {
		super.start(context);
		plugin = this;
		bundleContext = context;
		// Setup debugging options
		DEBUG = isDebugging();

		BaseHelpSystem.setDefaultErrorUtil(new ErrorUtil());
		if (BaseHelpSystem.getMode() == BaseHelpSystem.MODE_WORKBENCH) {
			if (PlatformUI.isWorkbenchRunning()) {
				// register the working set listener to keep the ui and the help
				// working sets in sych
				workingSetListener = new HelpWorkingSetSynchronizer();
				PlatformUI.getWorkbench().getWorkingSetManager()
						.addPropertyChangeListener(workingSetListener);
				BaseHelpSystem.getWorkingSetManager()
						.addPropertyChangeListener(workingSetListener);
			} else {
				// running tests, workbench not running
			}
		}
	}

	public HelpWorkingSetSynchronizer getWorkingSetSynchronizer() {
		return workingSetListener;
	}
}
