/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.data;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.help.IToc;
import org.eclipse.help.ITopic;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.base.HelpBasePlugin;
import org.eclipse.help.internal.model.INavigationElement;
import org.eclipse.help.internal.model.ITocElement;
import org.eclipse.help.internal.model.ITopicElement;
import org.eclipse.help.internal.toc.Toc;
import org.eclipse.help.internal.toc.Topic;
import org.eclipse.help.internal.webapp.data.ActivitiesData;
import org.eclipse.help.internal.webapp.data.ServletResources;
import org.eclipse.help.internal.webapp.data.UrlUtil;
import org.eclipse.help.internal.webapp.data.WebappPreferences;

public class TocData
extends ActivitiesData {
    private static int loadBookAtOnceLimit;
    private static int dynamicLoadDepths;
    private static int honorLevelsLimit;
    private String tocHref;
    private String topicHref;
    private String topicHelpHref;
    private int selectedToc;
    private int[] rootPath = null;
    private ITopic[] topicPath = null;
    private int topicsGenerated = 0;
    private ITocElement[] tocs;
    private IToc[] filteredTocs;
    private String imagesDirectory;

    public TocData(ServletContext context, HttpServletRequest request, HttpServletResponse response) {
        super(context, request, response);
        String pathStr;
        if (dynamicLoadDepths < 1) {
            WebappPreferences pref = new WebappPreferences();
            loadBookAtOnceLimit = pref.getBookAtOnceLimit();
            dynamicLoadDepths = pref.getLoadDepth();
            honorLevelsLimit = loadBookAtOnceLimit / 4;
        }
        this.tocHref = request.getParameter("toc");
        this.topicHref = request.getParameter("topic");
        if (this.tocHref != null && this.tocHref.length() == 0) {
            this.tocHref = null;
        }
        if (this.topicHref != null && this.topicHref.length() == 0) {
            this.topicHref = null;
        }
        if ((pathStr = request.getParameter("path")) != null && pathStr.length() > 0) {
            String[] paths = pathStr.split("_", -1);
            int[] indexes = new int[paths.length];
            boolean indexesOK = true;
            int i = 0;
            while (i < paths.length) {
                try {
                    indexes[i] = Integer.parseInt(paths[i]);
                }
                catch (NumberFormatException numberFormatException) {
                    indexesOK = false;
                    break;
                }
                if (indexesOK) {
                    this.rootPath = indexes;
                }
                ++i;
            }
        }
        this.imagesDirectory = this.preferences.getImagesDirectory();
        this.loadTocs();
    }

    public int getTocCount() {
        return this.tocs.length;
    }

    public String getTocLabel(int i) {
        return this.tocs[i].getLabel();
    }

    public String getTocHref(int i) {
        return this.tocs[i].getHref();
    }

    public String getTocDescriptionTopic(int i) {
        return UrlUtil.getHelpURL(this.tocs[i].getTopic(null).getHref());
    }

    public int getSelectedToc() {
        return this.selectedToc;
    }

    public String getSelectedTopic() {
        if (this.topicHref != null && this.topicHref.length() > 0) {
            return UrlUtil.getHelpURL(this.topicHref);
        }
        if (this.selectedToc == -1) {
            return null;
        }
        ITocElement toc = this.tocs[this.selectedToc];
        ITopic tocDescription = toc.getTopic(null);
        if (tocDescription != null) {
            return UrlUtil.getHelpURL(tocDescription.getHref());
        }
        return UrlUtil.getHelpURL(null);
    }

    public ITocElement[] getTocs() {
        return this.tocs;
    }

    public boolean isEnabled(int toc) {
        if (!this.isEnabled(this.tocs[toc])) {
            return false;
        }
        return this.getEnabledSubtopicList((INavigationElement)this.tocs[toc]).size() > 0;
    }

    private boolean isEnabled(ITocElement toc) {
        if (!this.isAdvancedUI()) {
            return true;
        }
        return HelpBasePlugin.getActivitySupport().isEnabled(toc.getHref());
    }

    private void loadTocs() {
        this.tocs = HelpPlugin.getTocManager().getTocs(this.getLocale());
        this.selectedToc = -1;
        if (this.tocHref != null && this.tocHref.length() > 0) {
            this.tocs = this.getTocs();
            int i = 0;
            while (this.selectedToc == -1 && i < this.tocs.length) {
                if (this.tocHref.equals(this.tocs[i].getHref())) {
                    this.selectedToc = i;
                }
                ++i;
            }
        } else {
            this.selectedToc = this.findTocContainingTopic(this.topicHref);
            ITopic topic = this.findTopic();
            if (topic != null && topic instanceof Topic) {
                this.topicPath = ((Topic)topic).getPathInToc((IToc)this.tocs[this.selectedToc]);
            }
        }
    }

    private int findTocContainingTopic(String topic) {
        if (topic == null || topic.equals("")) {
            return -1;
        }
        int index = topic.indexOf("/topic/");
        if (index != -1) {
            topic = topic.substring(index + 6);
        }
        if ((index = topic.indexOf(63)) != -1) {
            topic = topic.substring(0, index);
        }
        if (topic == null || topic.equals("")) {
            return -1;
        }
        this.tocs = this.getTocs();
        int i = 0;
        while (i < this.tocs.length) {
            if (this.isEnabled(i) && this.tocs[i].getTopic(topic) != null) {
                return i;
            }
            ++i;
        }
        i = 0;
        while (i < this.tocs.length) {
            if (!this.isEnabled(i) && this.tocs[i].getTopic(topic) != null) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private ITopic findTopic() {
        String topic = this.getSelectedTopic();
        if (topic == null || topic.equals("")) {
            return null;
        }
        int index = topic.indexOf("/topic/");
        if (index != -1) {
            topic = topic.substring(index + 6);
        }
        if ((index = topic.indexOf(63)) != -1) {
            topic = topic.substring(0, index);
        }
        if (topic == null || topic.equals("")) {
            return null;
        }
        if (this.getSelectedToc() < 0) {
            return null;
        }
        ITocElement selectedToc = this.getTocs()[this.getSelectedToc()];
        if (selectedToc == null) {
            return null;
        }
        return selectedToc.getTopic(topic);
    }

    public void generateToc(int toc, Writer out) throws IOException {
        ITopicElement[] topics = this.getEnabledSubtopics((INavigationElement)this.tocs[toc]);
        if (topics.length <= 0) {
            return;
        }
        int maxLevels = dynamicLoadDepths;
        if (this.tocs[toc] instanceof Toc && ((Toc)this.tocs[toc]).size() <= loadBookAtOnceLimit) {
            maxLevels = -1;
        }
        StringBuffer id = new StringBuffer();
        if (this.rootPath != null) {
            int p = 0;
            while (p < this.rootPath.length) {
                if (id.length() > 0) {
                    id.append('_');
                }
                topics = this.getEnabledSubtopics((INavigationElement)topics[this.rootPath[p]]);
                id.append(this.rootPath[p]);
                ++p;
            }
            out.write("<ul class='expanded' id=\"" + id.toString() + "\">\n");
        }
        int i = 0;
        while (i < topics.length) {
            String idPrefix = id.toString();
            idPrefix = idPrefix.length() > 0 ? String.valueOf(idPrefix) + "_" + Integer.toString(i) : Integer.toString(i);
            this.generateTopic(topics[i], out, idPrefix, maxLevels, this.rootPath == null ? 0 : this.rootPath.length);
            ++i;
        }
        if (this.rootPath != null) {
            out.write("</ul>\n");
        }
    }

    private void generateTopic(ITopicElement topic, Writer out, String id, int maxLevels, int currentLevel) throws IOException {
        ITopicElement[] topics;
        boolean hasNodes;
        if (maxLevels == 0) {
            return;
        }
        ++this.topicsGenerated;
        if (maxLevels > 1 && this.topicsGenerated > honorLevelsLimit) {
            maxLevels = 1;
        }
        boolean bl = hasNodes = (topics = this.getEnabledSubtopics((INavigationElement)topic)).length > 0;
        if (hasNodes) {
            boolean isAncestor;
            out.write("<li>");
            out.write("<img src='");
            out.write(this.imagesDirectory);
            out.write("/plus.gif' class='collapsed' alt=\"" + ServletResources.getString("topicClosed", this.request) + "\">");
            out.write("<a href='" + UrlUtil.getHelpURL(topic.getHref()) + "'>");
            out.write("<img src='");
            out.write(this.imagesDirectory);
            out.write("/container_obj.gif' alt=\"\">");
            out.write(UrlUtil.htmlEncode(topic.getLabel()));
            out.write("</a>");
            boolean bl2 = isAncestor = this.topicPath != null && this.topicPath.length > currentLevel + 1 && this.topicPath[currentLevel] == topic;
            if (maxLevels != 1 || isAncestor) {
                out.write("<ul class='collapsed'>\n");
            } else {
                out.write("<ul class='collapsed' id=\"" + id + "\">\n");
            }
            if (1 <= maxLevels && maxLevels <= dynamicLoadDepths && isAncestor) {
                int i = 0;
                while (i < topics.length) {
                    this.generateTopic(topics[i], out, String.valueOf(id) + "_" + i, dynamicLoadDepths, currentLevel + 1);
                    ++i;
                }
            } else {
                int i = 0;
                while (i < topics.length) {
                    this.generateTopic(topics[i], out, String.valueOf(id) + "_" + i, maxLevels - 1, currentLevel + 1);
                    ++i;
                }
            }
            out.write("</ul>\n");
        } else {
            out.write("<li>");
            out.write("<img src='");
            out.write(this.imagesDirectory);
            out.write("/plus.gif' class='h' alt=\"\">");
            out.write("<a href='" + UrlUtil.getHelpURL(topic.getHref()) + "'>");
            out.write("<img src='");
            out.write(this.imagesDirectory);
            out.write("/topic.gif' alt=\"\">");
            out.write(UrlUtil.htmlEncode(topic.getLabel()));
            out.write("</a>");
        }
        out.write("</li>\n");
    }

    public void generateBasicToc(int toc, Writer out) throws IOException {
        ITopicElement[] topics = this.getEnabledSubtopics((INavigationElement)this.tocs[toc]);
        int i = 0;
        while (i < topics.length) {
            this.generateBasicTopic(topics[i], out);
            ++i;
        }
    }

    private void generateBasicTopic(ITopicElement topic, Writer out) throws IOException {
        boolean hasNodes;
        out.write("<li>");
        ITopicElement[] topics = this.getEnabledSubtopics((INavigationElement)topic);
        boolean bl = hasNodes = topics.length > 0;
        if (hasNodes) {
            out.write("<nobr>");
            out.write("<a ");
            if (this.getSelectedTopicHelpHref().equals(topic.getHref())) {
                out.write("name=\"selectedItem\" ");
            }
            out.write("href='" + UrlUtil.getHelpURL(topic.getHref()) + "'>");
            out.write("<img src='");
            out.write(this.imagesDirectory);
            out.write("/container_obj.gif' alt=\"\" border=0>&nbsp;");
            out.write(UrlUtil.htmlEncode(topic.getLabel()));
            out.write("</a>");
            out.write("</nobr>");
            out.write("<ul>\n");
            int i = 0;
            while (i < topics.length) {
                this.generateBasicTopic(topics[i], out);
                ++i;
            }
            out.write("</ul>\n");
        } else {
            out.write("<nobr>");
            out.write("<a ");
            if (this.getSelectedTopicHelpHref().equals(topic.getHref())) {
                out.write("name=\"selectedItem\" ");
            }
            out.write("href='" + UrlUtil.getHelpURL(topic.getHref()) + "'>");
            out.write("<img src='");
            out.write(this.imagesDirectory);
            out.write("/topic.gif' alt=\"\" border=0>&nbsp;");
            out.write(UrlUtil.htmlEncode(topic.getLabel()));
            out.write("</a>");
            out.write("</nobr>");
        }
        out.write("</li>\n");
    }

    private String getSelectedTopicHelpHref() {
        if (this.topicHelpHref == null) {
            String topic = this.getSelectedTopic();
            if (topic == null || topic.length() == 0) {
                this.topicHelpHref = "";
                return this.topicHelpHref;
            }
            int index = topic.indexOf("/topic/");
            if (index != -1) {
                topic = topic.substring(index + 6);
            }
            if ((index = topic.indexOf(63)) != -1) {
                topic = topic.substring(0, index);
            }
            this.topicHelpHref = topic;
            if (topic == null) {
                this.topicHelpHref = "";
            }
        }
        return this.topicHelpHref;
    }

    private ITopicElement[] getEnabledSubtopics(INavigationElement navigationElement) {
        List topics = this.getEnabledSubtopicList(navigationElement);
        return topics.toArray(new ITopicElement[topics.size()]);
    }

    private List getEnabledSubtopicList(INavigationElement navigationElement) {
        if (navigationElement instanceof ITocElement && !this.isEnabled((ITocElement)navigationElement)) {
            return Collections.EMPTY_LIST;
        }
        List children = navigationElement.getChildren();
        ArrayList<INavigationElement> childTopics = new ArrayList<INavigationElement>(children.size());
        Iterator childrenIt = children.iterator();
        while (childrenIt.hasNext()) {
            INavigationElement c = (INavigationElement)childrenIt.next();
            if (c instanceof ITopicElement) {
                if ((((ITopicElement)c).getHref() == null || ((ITopicElement)c).getHref().length() <= 0) && this.getEnabledSubtopicList(c).size() <= 0) continue;
                childTopics.add(c);
                continue;
            }
            childTopics.addAll(this.getEnabledSubtopicList(c));
        }
        return childTopics;
    }
}

