/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.operations;

import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSStatus;
import org.eclipse.team.internal.ccvs.core.util.Assert;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.ui.TeamOperation;
import org.eclipse.ui.IWorkbenchPart;

public abstract class CVSOperation
extends TeamOperation {
    private int statusCount;
    private boolean involvesMultipleResources = false;
    private List errors = new ArrayList();
    protected static final IStatus OK = Status.OK_STATUS;
    private Shell shell;
    private boolean confirmOverwrite = true;

    protected CVSOperation(IWorkbenchPart part) {
        super(part);
    }

    protected String getJobName() {
        return this.getTaskName();
    }

    protected URL getOperationIcon() {
        try {
            URL baseURL = CVSUIPlugin.getPlugin().getDescriptor().getInstallURL();
            return new URL(baseURL, "icons/full/eview16/cvs_persp.gif");
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        this.startOperation();
        try {
            try {
                monitor = Policy.monitorFor(monitor);
                monitor.beginTask(null, 100);
                monitor.setTaskName(this.getTaskName());
                this.execute(Policy.subMonitorFor(monitor, 100));
                this.endOperation();
            }
            catch (CVSException e) {
                throw new InvocationTargetException(e);
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        monitor.done();
    }

    protected void startOperation() {
        this.statusCount = 0;
        this.resetErrors();
        this.confirmOverwrite = true;
    }

    protected void endOperation() throws CVSException {
        this.handleErrors(this.errors.toArray(new IStatus[this.errors.size()]));
    }

    protected abstract void execute(IProgressMonitor var1) throws CVSException, InterruptedException;

    protected void addError(IStatus status) {
        if (status.isOK()) {
            return;
        }
        if (this.isLastError(status)) {
            return;
        }
        this.errors.add(status);
    }

    protected void collectStatus(IStatus status) {
        if (this.isLastError(status)) {
            return;
        }
        ++this.statusCount;
        if (!status.isOK()) {
            this.addError(status);
        }
    }

    protected void resetErrors() {
        this.errors.clear();
        this.statusCount = 0;
    }

    protected IStatus getLastError() {
        Assert.isTrue((this.errors.size() > 0 ? 1 : 0) != 0);
        IStatus status = (IStatus)this.errors.get(this.errors.size() - 1);
        return status;
    }

    private boolean isLastError(IStatus status) {
        return this.errors.size() > 0 && this.getLastError() == status;
    }

    protected void handleErrors(IStatus[] errors) throws CVSException {
        if (errors.length == 0) {
            return;
        }
        if (errors.length == 1 && this.statusCount == 1) {
            throw new CVSException(errors[0]);
        }
        MultiStatus result = new MultiStatus("org.eclipse.team.cvs.ui", 0, this.getErrorMessage(errors, this.statusCount), null);
        int i = 0;
        while (i < errors.length) {
            IStatus s = errors[i];
            if (s.isMultiStatus()) {
                result.add((IStatus)new CVSStatus(s.getSeverity(), s.getMessage(), s.getException()));
                result.addAll(s);
            } else {
                result.add(s);
            }
            ++i;
        }
        throw new CVSException((IStatus)result);
    }

    protected String getErrorMessage(IStatus[] failures, int totalOperations) {
        return Policy.bind("CVSOperation.0", String.valueOf(failures.length), String.valueOf(totalOperations));
    }

    protected boolean promptToOverwrite(final String title, final String msg) {
        if (!this.confirmOverwrite) {
            return true;
        }
        final String[] buttons = this.involvesMultipleResources() ? new String[]{IDialogConstants.YES_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL} : new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL};
        final Shell displayShell = this.getShell();
        if (displayShell == null) {
            return false;
        }
        final int[] code = new int[1];
        displayShell.getDisplay().syncExec(new Runnable(){

            public void run() {
                MessageDialog dialog = new MessageDialog(displayShell, title, null, msg, 3, buttons, 0);
                dialog.open();
                code[0] = dialog.getReturnCode();
            }
        });
        if (this.involvesMultipleResources()) {
            switch (code[0]) {
                case 0: {
                    return true;
                }
                case 1: {
                    this.confirmOverwrite = false;
                    return true;
                }
                case 2: {
                    return false;
                }
            }
            throw new OperationCanceledException();
        }
        return code[0] == 0;
    }

    protected boolean involvesMultipleResources() {
        return this.involvesMultipleResources;
    }

    public void setInvolvesMultipleResources(boolean b) {
        this.involvesMultipleResources = b;
    }

    protected abstract String getTaskName();

    protected boolean errorsOccurred() {
        Iterator iter = this.errors.iterator();
        while (iter.hasNext()) {
            IStatus status = (IStatus)iter.next();
            if (status.getSeverity() != 4) continue;
            return true;
        }
        return false;
    }

    protected Shell getShell() {
        if (this.shell != null && !this.shell.isDisposed()) {
            return this.shell;
        }
        return super.getShell();
    }

    public void setShell(Shell shell) {
        this.shell = shell;
    }

    protected boolean canRunAsJob() {
        return true;
    }
}

