/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.operations;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSTeamProvider;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.Session;
import org.eclipse.team.internal.ccvs.core.connection.CVSServerException;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.operations.RepositoryProviderOperation;
import org.eclipse.ui.IWorkbenchPart;

public class AddOperation
extends RepositoryProviderOperation {
    public AddOperation(IWorkbenchPart part, IResource[] resources) {
        super(part, resources);
    }

    protected void execute(CVSTeamProvider provider, IResource[] resources, IProgressMonitor monitor) throws CVSException, InterruptedException {
        this.add(provider, resources, 2, monitor);
    }

    protected String getTaskName() {
        return Policy.bind("AddAction.adding");
    }

    protected String getTaskName(CVSTeamProvider provider) {
        return Policy.bind("AddOperation.0", provider.getProject().getName());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void add(CVSTeamProvider provider, IResource[] resources, int depth, IProgressMonitor progress) throws CVSException {
        final TreeSet<ICVSResource> folders = new TreeSet<ICVSResource>();
        final HashMap files = new HashMap();
        CVSException[] eHolder = new CVSException[1];
        int i = 0;
        while (true) {
            if (i >= resources.length) {
                if (eHolder[0] == null) break;
                throw eHolder[0];
            }
            final IResource currentResource = resources[i];
            try {
                IContainer parent = currentResource.getParent();
                ICVSResource cvsParentResource = CVSWorkspaceRoot.getCVSResourceFor((IResource)parent);
                while (true) {
                    if (parent.getType() == 8 || parent.getType() == 4 || this.isManaged(cvsParentResource)) {
                        final TeamException[] exception = new TeamException[1];
                        currentResource.accept(new IResourceVisitor(){

                            public boolean visit(IResource resource) {
                                try {
                                    ICVSResource mResource = CVSWorkspaceRoot.getCVSResourceFor((IResource)resource);
                                    if (!(AddOperation.this.isManaged(mResource) || !currentResource.equals((Object)resource) && mResource.isIgnored())) {
                                        if (resource.getType() == 1) {
                                            Command.KSubstOption ksubst = Command.KSubstOption.fromFile((IFile)((IFile)resource));
                                            HashSet<ICVSResource> set = (HashSet<ICVSResource>)files.get(ksubst);
                                            if (set == null) {
                                                set = new HashSet<ICVSResource>();
                                                files.put(ksubst, set);
                                            }
                                            set.add(mResource);
                                        } else {
                                            folders.add(mResource);
                                        }
                                    }
                                    return true;
                                }
                                catch (CVSException e) {
                                    exception[0] = e;
                                    return false;
                                }
                            }
                        }, depth, false);
                        if (exception[0] == null) break;
                        throw exception[0];
                    }
                    folders.add(cvsParentResource);
                    parent = parent.getParent();
                    cvsParentResource = cvsParentResource.getParent();
                }
            }
            catch (CoreException e) {
                throw new CVSException((IStatus)new Status(4, "org.eclipse.team.cvs.core", -6, Policy.bind("CVSTeamProvider.visitError", new Object[]{resources[i].getFullPath()}), (Throwable)e));
            }
            ++i;
        }
        progress.beginTask(null, files.size() * 10 + (folders.isEmpty() ? 0 : 10));
        try {
            if (!folders.isEmpty()) {
                Object e;
                Session session = new Session(this.getRemoteLocation(provider), this.getLocalRoot(provider), true);
                session.open(Policy.subMonitorFor(progress, 2), true);
                try {
                    IStatus status = Command.ADD.execute(session, Command.NO_GLOBAL_OPTIONS, Command.NO_LOCAL_OPTIONS, folders.toArray(new ICVSResource[folders.size()]), null, Policy.subMonitorFor(progress, 8));
                    if (status.getCode() == -10) {
                        throw new CVSServerException(status);
                    }
                }
                catch (Throwable cvsParentResource) {
                    e = null;
                    session.close();
                    throw cvsParentResource;
                }
                {
                    e = null;
                }
                session.close();
            }
            Iterator it = files.entrySet().iterator();
            while (it.hasNext()) {
                Object var14_18;
                Map.Entry entry = it.next();
                Command.KSubstOption ksubst = (Command.KSubstOption)entry.getKey();
                Set set = (Set)entry.getValue();
                Session session = new Session(this.getRemoteLocation(provider), this.getLocalRoot(provider), true);
                session.open(Policy.subMonitorFor(progress, 2), true);
                try {
                    IStatus status = Command.ADD.execute(session, Command.NO_GLOBAL_OPTIONS, new Command.LocalOption[]{ksubst}, set.toArray(new ICVSResource[set.size()]), null, Policy.subMonitorFor(progress, 8));
                    if (status.getCode() == -10) {
                        throw new CVSServerException(status);
                    }
                }
                catch (Throwable throwable) {
                    var14_18 = null;
                    session.close();
                    throw throwable;
                }
                {
                    var14_18 = null;
                }
                session.close();
            }
        }
        catch (Throwable throwable) {
            Object var16_21 = null;
            progress.done();
            throw throwable;
        }
        {
            Object var16_22 = null;
        }
        progress.done();
    }

    private boolean isManaged(ICVSResource cvsResource) throws CVSException {
        return cvsResource.isManaged() && (!cvsResource.isFolder() || ((ICVSFolder)cvsResource).isCVSFolder());
    }

    protected String getErrorMessage(IStatus[] failures, int totalOperations) {
        return Policy.bind("AddAction.addFailed");
    }
}

