/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui;

import java.text.DateFormat;
import java.util.Date;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;
import org.eclipse.team.internal.ccvs.core.util.Util;
import org.eclipse.team.internal.ccvs.ui.CVSPropertiesPage;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.ui.help.WorkbenchHelp;

public class CVSFilePropertiesPage
extends CVSPropertiesPage {
    IFile file;
    static /* synthetic */ Class class$0;

    protected Control createContents(Composite parent) {
        this.initialize();
        this.noDefaultAndApplyButton();
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        try {
            ICVSFile cvsResource = CVSWorkspaceRoot.getCVSFileFor((IFile)this.file);
            if (!cvsResource.isManaged()) {
                if (cvsResource.isIgnored()) {
                    this.createLabel(composite, Policy.bind("CVSFilePropertiesPage.ignored"));
                } else {
                    this.createLabel(composite, Policy.bind("CVSFilePropertiesPage.notManaged"));
                }
                this.createLabel(composite, "");
                return composite;
            }
            ResourceSyncInfo syncInfo = cvsResource.getSyncInfo();
            if (syncInfo.isAdded()) {
                this.createLabel(composite, Policy.bind("CVSFilePropertiesPage.isAdded"), 2);
            } else {
                this.createLabel(composite, Policy.bind("CVSFilePropertiesPage.baseRevision"));
                this.createLabel(composite, syncInfo.getRevision());
                Date baseTime = syncInfo.getTimeStamp();
                if (baseTime != null) {
                    this.createLabel(composite, Policy.bind("CVSFilePropertiesPage.baseTimestamp"));
                    this.createLabel(composite, DateFormat.getDateTimeInstance(0, 0).format(syncInfo.getTimeStamp()));
                }
                this.createLabel(composite, Policy.bind("CVSFilePropertiesPage.modified"));
                this.createLabel(composite, cvsResource.isModified(null) ? Policy.bind("yes") : Policy.bind("no"));
            }
            this.createLabel(composite, Policy.bind("CVSFilePropertiesPage.keywordMode"));
            this.createLabel(composite, syncInfo.getKeywordMode().getLongDisplayText());
            this.createLabel(composite, Policy.bind("CVSFilePropertiesPage.tag"));
            CVSTag tag = Util.getAccurateFileTag((ICVSResource)cvsResource);
            this.createLabel(composite, CVSPropertiesPage.getTagLabel(tag));
            this.createLabel(composite, Policy.bind("CVSFilePropertiesPage.permissions"));
            String permissions = syncInfo.getPermissions();
            if (permissions == null) {
                this.createLabel(composite, Policy.bind("CVSFilePropertiesPage.notAvailable"));
            } else {
                this.createLabel(composite, syncInfo.getPermissions());
            }
        }
        catch (TeamException teamException) {
            this.createLabel(composite, Policy.bind("CVSFilePropertiesPage.error"));
            this.createLabel(composite, "");
        }
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)"org.eclipse.team.cvs.ui.file_property_page_context");
        Dialog.applyDialogFont((Control)parent);
        return composite;
    }

    protected Label createLabel(Composite parent, String text, int span) {
        Label label = new Label(parent, 16384);
        label.setText(text);
        GridData data = new GridData();
        data.horizontalSpan = span;
        data.horizontalAlignment = 4;
        label.setLayoutData((Object)data);
        return label;
    }

    protected Label createLabel(Composite parent, String text) {
        return this.createLabel(parent, text, 1);
    }

    private void initialize() {
        this.file = null;
        IAdaptable element = this.getElement();
        if (element instanceof IFile) {
            this.file = (IFile)element;
        } else {
            Object adapter;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.resources.IFile");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((adapter = element.getAdapter((Class)clazz)) instanceof IFile) {
                this.file = (IFile)adapter;
            }
        }
    }
}

