/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.base.HelpBasePlugin;
import org.eclipse.help.internal.base.IHelpActivitySupport;
import org.eclipse.help.internal.model.ITocElement;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.IIdentifier;
import org.eclipse.ui.activities.IWorkbenchActivitySupport;

public class HelpActivitySupport
implements IHelpActivitySupport {
    private static final String PREF_KEY_SHOW_DISABLED_ACTIVITIES = "showDisabledActivityTopics";
    private static final String SHOW_DISABLED_ACTIVITIES_NEVER = "never";
    private static final String SHOW_DISABLED_ACTIVITIES_OFF = "off";
    private static final String SHOW_DISABLED_ACTIVITIES_ON = "on";
    private static final String SHOW_DISABLED_ACTIVITIES_ALWAYS = "always";
    private Preferences pref;
    private IWorkbenchActivitySupport activitySupport;
    private boolean userCanToggleFiltering;
    private boolean filteringEnabled;

    public HelpActivitySupport(IWorkbench workbench) {
        this.activitySupport = workbench.getActivitySupport();
        this.pref = HelpBasePlugin.getDefault().getPluginPreferences();
        String showDisabledActivities = this.pref.getString(PREF_KEY_SHOW_DISABLED_ACTIVITIES);
        this.userCanToggleFiltering = SHOW_DISABLED_ACTIVITIES_OFF.equalsIgnoreCase(showDisabledActivities) || SHOW_DISABLED_ACTIVITIES_ON.equalsIgnoreCase(showDisabledActivities);
        this.userCanToggleFiltering = this.userCanToggleFiltering && HelpActivitySupport.isWorkbenchFiltering();
        this.filteringEnabled = SHOW_DISABLED_ACTIVITIES_OFF.equalsIgnoreCase(showDisabledActivities) || SHOW_DISABLED_ACTIVITIES_NEVER.equalsIgnoreCase(showDisabledActivities);
        this.filteringEnabled = this.filteringEnabled && HelpActivitySupport.isWorkbenchFiltering();
    }

    public boolean isFilteringEnabled() {
        return this.filteringEnabled;
    }

    public void setFilteringEnabled(boolean enabled) {
        if (this.userCanToggleFiltering) {
            this.filteringEnabled = enabled;
            if (enabled) {
                this.pref.setValue(PREF_KEY_SHOW_DISABLED_ACTIVITIES, SHOW_DISABLED_ACTIVITIES_OFF);
            } else {
                this.pref.setValue(PREF_KEY_SHOW_DISABLED_ACTIVITIES, SHOW_DISABLED_ACTIVITIES_ON);
            }
        }
    }

    public boolean isUserCanToggleFiltering() {
        return this.userCanToggleFiltering;
    }

    public boolean isEnabled(String href) {
        if (!this.isFilteringEnabled()) {
            return true;
        }
        if (href.startsWith("/")) {
            href = href.substring(1);
        }
        return this.activitySupport.getActivityManager().getIdentifier(href).isEnabled();
    }

    public boolean isEnabledTopic(String href, String locale) {
        if (href == null) {
            return false;
        }
        if (!this.isFilteringEnabled()) {
            return true;
        }
        int ix = href.indexOf("?resultof=");
        if (ix >= 0) {
            href = href.substring(0, ix);
        }
        ITocElement[] tocs = HelpPlugin.getTocManager().getTocs(locale);
        int t = 0;
        while (t < tocs.length) {
            String descriptionHref = tocs[t].getTocTopicHref();
            if (descriptionHref != null && descriptionHref.length() > 0 && descriptionHref.equals(href) && HelpBasePlugin.getActivitySupport().isEnabled(tocs[t].getHref())) {
                return true;
            }
            ++t;
        }
        return this.isInTocSubtree(href, Arrays.asList(tocs));
    }

    private boolean isInTocSubtree(String href, List tocList) {
        Iterator it = tocList.iterator();
        while (it.hasNext()) {
            ITocElement toc = (ITocElement)it.next();
            if (!HelpBasePlugin.getActivitySupport().isEnabled(toc.getHref())) continue;
            if (toc.getOwnedTopic(href) != null) {
                return true;
            }
            if (toc.getOwnedExtraTopic(href) != null) {
                return true;
            }
            if (!this.isInTocSubtree(href, toc.getChildrenTocs())) continue;
            return true;
        }
        return false;
    }

    public void enableActivities(String href) {
        IIdentifier identifier;
        Set activitityIds;
        if (href.startsWith("/")) {
            href = href.substring(1);
        }
        if ((activitityIds = (identifier = this.activitySupport.getActivityManager().getIdentifier(href)).getActivityIds()).isEmpty()) {
            return;
        }
        HashSet enabledIds = new HashSet(this.activitySupport.getActivityManager().getEnabledActivityIds());
        enabledIds.addAll(activitityIds);
        this.activitySupport.setEnabledActivityIds(enabledIds);
    }

    private static boolean isWorkbenchFiltering() {
        return !PlatformUI.getWorkbench().getActivitySupport().getActivityManager().getDefinedActivityIds().isEmpty();
    }
}

