/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.ui;

import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.actions.ITeamRunnableContext;
import org.eclipse.team.internal.ui.actions.JobRunnableContext;
import org.eclipse.team.internal.ui.actions.ProgressDialogRunnableContext;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;

public abstract class TeamOperation
extends JobChangeAdapter
implements IRunnableWithProgress {
    private IWorkbenchPart part;
    private IRunnableContext context;

    protected TeamOperation(IWorkbenchPart part) {
        this(part, null);
    }

    protected TeamOperation(IRunnableContext context) {
        this(null, context);
    }

    protected TeamOperation(IWorkbenchPart part, IRunnableContext context) {
        this.part = part;
        this.context = context;
    }

    public IWorkbenchPart getPart() {
        return this.part;
    }

    public final void run() throws InvocationTargetException, InterruptedException {
        if (this.shouldRun()) {
            this.getRunnableContext().run(this);
        }
    }

    protected boolean shouldRun() {
        return true;
    }

    protected ISchedulingRule getSchedulingRule() {
        return null;
    }

    protected boolean isPostponeAutobuild() {
        return true;
    }

    protected boolean canRunAsJob() {
        return false;
    }

    protected String getJobName() {
        return "";
    }

    protected IAction getGotoAction() {
        return null;
    }

    protected URL getOperationIcon() {
        return null;
    }

    protected boolean getKeepOperation() {
        return false;
    }

    protected Shell getShell() {
        final Shell[] shell = new Shell[1];
        if (this.canRunAsJob()) {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    shell[0] = Utils.getShell(TeamOperation.this.getSite());
                }
            });
        } else {
            shell[0] = Utils.getShell(this.getSite());
        }
        return shell[0];
    }

    private ITeamRunnableContext getRunnableContext() {
        if (this.context == null && this.canRunAsJob()) {
            JobRunnableContext context = new JobRunnableContext(this.getJobName(), this.getOperationIcon(), this.getGotoAction(), this.getKeepOperation(), (IJobChangeListener)this, this.getSite());
            context.setPostponeBuild(this.isPostponeAutobuild());
            context.setSchedulingRule(this.getSchedulingRule());
            return context;
        }
        ProgressDialogRunnableContext context = new ProgressDialogRunnableContext(this.getShell());
        context.setPostponeBuild(this.isPostponeAutobuild());
        context.setSchedulingRule(this.getSchedulingRule());
        if (this.context != null) {
            context.setRunnableContext(this.context);
        }
        return context;
    }

    private IWorkbenchSite getSite() {
        IWorkbenchPartSite site = null;
        if (this.part != null) {
            site = this.part.getSite();
        }
        return site;
    }
}

