/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ui.Policy;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.synchronize.actions.ShowSynchronizeParticipantAction;
import org.eclipse.team.internal.ui.wizards.GlobalSynchronizeWizard;
import org.eclipse.team.ui.TeamImages;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipantListener;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipantReference;
import org.eclipse.team.ui.synchronize.ISynchronizeView;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.IUpdate;

public class SynchronizePageDropDownAction
extends Action
implements IMenuCreator,
ISynchronizeParticipantListener,
IUpdate {
    private ISynchronizeView fView;
    private Menu fMenu;
    private Action synchronizeAction;

    public void update() {
        this.updateTooltipText();
    }

    protected ISynchronizeParticipantReference[] getParticipants() {
        return TeamUI.getSynchronizeManager().getSynchronizeParticipants();
    }

    protected boolean select(ISynchronizeParticipantReference ref) {
        return true;
    }

    public SynchronizePageDropDownAction(ISynchronizeView view) {
        this.fView = view;
        Utils.initAction((IAction)this, "action.refreshSubscriber.");
        this.synchronizeAction = new Action(Policy.bind("GlobalRefreshAction.4")){

            public void run() {
                GlobalSynchronizeWizard wizard = new GlobalSynchronizeWizard();
                WizardDialog dialog = new WizardDialog(SynchronizePageDropDownAction.this.fView.getViewSite().getShell(), (IWizard)wizard);
                dialog.open();
            }
        };
        this.synchronizeAction.setImageDescriptor(TeamImages.getImageDescriptor("eview16/synch_synch.gif"));
        this.setMenuCreator(this);
        this.update();
    }

    public void dispose() {
        if (this.fMenu != null) {
            this.fMenu.dispose();
            this.fMenu = null;
        }
        TeamUI.getSynchronizeManager().removeSynchronizeParticipantListener(this);
    }

    public Menu getMenu(Menu parent) {
        return null;
    }

    public Menu getMenu(Control parent) {
        if (this.fMenu != null) {
            this.fMenu.dispose();
        }
        this.fMenu = new Menu(parent);
        ISynchronizeParticipantReference[] participants = TeamUI.getSynchronizeManager().getSynchronizeParticipants();
        this.addParticipantsToMenu(this.fMenu, participants);
        if (participants.length > 0) {
            this.addMenuSeparator();
        }
        this.addActionToMenu(this.fMenu, this.synchronizeAction);
        TeamUI.getSynchronizeManager().addSynchronizeParticipantListener(this);
        return this.fMenu;
    }

    protected void addParticipantsToMenu(Menu parent, ISynchronizeParticipantReference[] refs) {
        ISynchronizeParticipant current = this.fView.getParticipant();
        int i = 0;
        while (i < refs.length) {
            block3: {
                ISynchronizeParticipantReference page = refs[i];
                ShowSynchronizeParticipantAction action = new ShowSynchronizeParticipantAction(this.fView, page);
                try {
                    boolean isCurrent = page.getParticipant().equals(current);
                    action.setChecked(isCurrent);
                }
                catch (TeamException teamException) {
                    break block3;
                }
                this.addActionToMenu(this.fMenu, action);
            }
            ++i;
        }
    }

    protected void addActionToMenu(Menu parent, Action action) {
        ActionContributionItem item = new ActionContributionItem((IAction)action);
        item.fill(parent, -1);
    }

    protected void addMenuSeparator() {
        new MenuItem(this.fMenu, 2);
    }

    public void run() {
        ISynchronizeParticipant current = this.fView.getParticipant();
        if (current != null) {
            current.run((IWorkbenchPart)this.fView);
        } else {
            this.synchronizeAction.run();
        }
        this.update();
    }

    public void participantsAdded(ISynchronizeParticipant[] consoles) {
        Display display = TeamUIPlugin.getStandardDisplay();
        display.asyncExec(new Runnable(){

            public void run() {
                SynchronizePageDropDownAction.this.update();
            }
        });
    }

    public void participantsRemoved(ISynchronizeParticipant[] consoles) {
        Display display = TeamUIPlugin.getStandardDisplay();
        display.asyncExec(new Runnable(){

            public void run() {
                if (SynchronizePageDropDownAction.this.fMenu != null) {
                    SynchronizePageDropDownAction.this.fMenu.dispose();
                }
                SynchronizePageDropDownAction.this.update();
            }
        });
    }

    private void updateTooltipText() {
        ISynchronizeParticipant current = this.fView.getParticipant();
        ISynchronizeParticipantReference[] refs = TeamUI.getSynchronizeManager().getSynchronizeParticipants();
        String text = null;
        if (current != null && refs.length > 0) {
            text = Policy.bind("GlobalRefreshAction.5", Utils.shortenText(100, current.getName()));
            this.setToolTipText(text);
            this.setText(text);
        } else {
            text = Policy.bind("GlobalRefreshAction.4");
            this.setToolTipText(text);
            this.setText(text);
        }
    }
}

