/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.progress;

import java.util.HashSet;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.ui.internal.progress.GroupInfo;
import org.eclipse.ui.internal.progress.JobInfo;
import org.eclipse.ui.internal.progress.JobTreeElement;
import org.eclipse.ui.internal.progress.ProgressContentProvider;
import org.eclipse.ui.internal.progress.ProgressManager;
import org.eclipse.ui.internal.progress.ProgressViewer;

public class ProgressViewerContentProvider
extends ProgressContentProvider
implements IStructuredContentProvider {
    ProgressViewer progressViewer;

    public ProgressViewerContentProvider(ProgressViewer structured) {
        this.progressViewer = structured;
    }

    public ProgressViewerContentProvider(ProgressViewer structured, boolean noDebug) {
        super(noDebug);
        this.progressViewer = structured;
    }

    public void add(Object[] elements) {
        this.progressViewer.setInput(this);
    }

    public Object[] getDisplayedValues(Object[] elements) {
        HashSet<JobTreeElement> showing = new HashSet<JobTreeElement>();
        int i = 0;
        while (i < elements.length) {
            JobTreeElement element = (JobTreeElement)elements[i];
            if (element.isActive() && (!element.isJobInfo() || ((JobInfo)element).getJob().getState() == 4)) {
                showing.add(element);
            }
            ++i;
        }
        return showing.toArray();
    }

    public void refresh() {
        this.progressViewer.refresh(true);
    }

    public void refresh(Object[] elements) {
        Object[] refreshes = this.getRoots(elements, true);
        int i = 0;
        while (i < refreshes.length) {
            this.progressViewer.refresh(refreshes[i], true);
            ++i;
        }
    }

    public void remove(Object[] elements) {
        this.progressViewer.setInput(this);
    }

    public Object[] getElements(Object inputElement) {
        Object[] elements = ProgressManager.getInstance().getRootElements(false);
        return this.getDisplayedValues(elements);
    }

    private Object[] getRoots(Object[] elements, boolean subWithParent) {
        if (elements.length == 0) {
            return elements;
        }
        HashSet<JobTreeElement> roots = new HashSet<JobTreeElement>();
        int i = 0;
        while (i < elements.length) {
            JobTreeElement element = (JobTreeElement)elements[i];
            if (element.isJobInfo()) {
                GroupInfo group = ((JobInfo)element).getGroupInfo();
                if (group == null) {
                    roots.add(element);
                } else if (subWithParent) {
                    roots.add(group);
                }
            } else {
                roots.add(element);
            }
            ++i;
        }
        return roots.toArray();
    }
}

