/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.progress;

import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.progress.ErrorInfo;
import org.eclipse.ui.internal.progress.ErrorNotificationManager;
import org.eclipse.ui.internal.progress.ProgressManager;
import org.eclipse.ui.internal.progress.ProgressManagerUtil;
import org.eclipse.ui.internal.progress.ProgressMessages;

public class ErrorNotificationDialog
extends Dialog {
    TableViewer errorViewer;
    Button clearButton;
    List detailsList;
    private Clipboard clipboard;
    private ErrorInfo selectedError = null;
    private static final int DETAILS_LIST_ITEM_COUNT = 7;
    private static final String NESTING_INDENT = "  ";

    public ErrorNotificationDialog(Shell parentShell) {
        super(parentShell == null ? ProgressManagerUtil.getDefaultParent() : parentShell);
        this.setBlockOnOpen(false);
        this.setShellStyle(2160);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(ProgressMessages.getString("ErrorNotificationDialog.ErrorNotificationTitle"));
        newShell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ErrorNotificationDialog.this.getManager().clearDialog();
            }
        });
    }

    protected int getShellStyle() {
        return super.getShellStyle() | 0x80;
    }

    protected Control createDialogArea(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite topArea = (Composite)super.createDialogArea(parent);
        this.errorViewer = new TableViewer(topArea, 2818);
        this.errorViewer.setSorter(this.getViewerSorter());
        this.errorViewer.getControl().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                ErrorNotificationDialog.this.openErrorDialog();
            }
        });
        this.errorViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ErrorNotificationDialog.this.clearButton.setEnabled(!ErrorNotificationDialog.this.errorViewer.getSelection().isEmpty());
                ErrorNotificationDialog.this.setDetailsContents();
            }
        });
        Control control = this.errorViewer.getControl();
        GridData data = new GridData(1808);
        data.widthHint = this.convertWidthInCharsToPixels(60);
        data.heightHint = this.convertHeightInCharsToPixels(10);
        control.setLayoutData((Object)data);
        this.initContentProvider();
        this.initLabelProvider();
        Dialog.applyDialogFont((Control)parent);
        this.createDetailsList(topArea);
        return topArea;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.clearButton = this.createButton(parent, 1026, ProgressMessages.getString("ErrorNotificationDialog.ClearButtonTitle"), false);
        this.clearButton.setEnabled(false);
        this.clearButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ISelection rawSelection = ErrorNotificationDialog.this.errorViewer.getSelection();
                if (rawSelection != null && rawSelection instanceof IStructuredSelection) {
                    IStructuredSelection selection = (IStructuredSelection)rawSelection;
                    ErrorNotificationDialog.this.getManager().removeErrors(selection.toList());
                }
                ErrorNotificationDialog.this.refresh();
            }
        });
        Button button = this.createButton(parent, 12, IDialogConstants.CLOSE_LABEL, true);
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ErrorNotificationDialog.this.close();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ErrorNotificationDialog.this.close();
            }
        });
    }

    private ViewerSorter getViewerSorter() {
        return new ViewerSorter(){

            public int compare(Viewer testViewer, Object e1, Object e2) {
                return ((Comparable)e1).compareTo(e2);
            }
        };
    }

    protected void initContentProvider() {
        IStructuredContentProvider provider = new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return ErrorNotificationDialog.this.getManager().getErrors().toArray();
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                if (newInput != null) {
                    ErrorNotificationDialog.this.refresh();
                }
            }
        };
        this.errorViewer.setContentProvider((IContentProvider)provider);
        this.errorViewer.setInput((Object)this.getManager());
    }

    private ErrorNotificationManager getManager() {
        return ProgressManager.getInstance().errorManager;
    }

    void refresh() {
        this.errorViewer.refresh();
    }

    private void initLabelProvider() {
        ITableLabelProvider provider = new ITableLabelProvider(){

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return JFaceResources.getImageRegistry().get("ERROR_JOB");
            }

            public String getColumnText(Object element, int columnIndex) {
                return ((ErrorInfo)element).getDisplayString();
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        };
        this.errorViewer.setLabelProvider((IBaseLabelProvider)provider);
    }

    private void openErrorDialog() {
        ErrorInfo element = this.getSingleSelection();
        if (element == null) {
            return;
        }
        ErrorDialog.openError((Shell)this.getShell(), (String)element.getDisplayString(), null, (IStatus)element.getErrorStatus());
    }

    private ErrorInfo getSingleSelection() {
        IStructuredSelection selection;
        ISelection rawSelection = this.errorViewer.getSelection();
        if (rawSelection != null && rawSelection instanceof IStructuredSelection && (selection = (IStructuredSelection)rawSelection).size() == 1) {
            return (ErrorInfo)selection.getFirstElement();
        }
        return null;
    }

    public boolean close() {
        this.getManager().clearAllErrors();
        Rectangle shellPosition = this.getShell().getBounds();
        boolean result = super.close();
        ProgressManagerUtil.animateDown(shellPosition);
        return result;
    }

    protected void initializeBounds() {
        super.initializeBounds();
        Rectangle shellPosition = this.getShell().getBounds();
        ProgressManagerUtil.animateUp(shellPosition);
    }

    private void createDetailsList(Composite detailsParent) {
        this.detailsList = new List(detailsParent, 2818);
        GridData data = new GridData(1808);
        data.heightHint = this.detailsList.getItemHeight() * 7;
        data.horizontalSpan = 2;
        this.detailsList.setLayoutData((Object)data);
        Menu copyMenu = new Menu((Control)this.detailsList);
        MenuItem copyItem = new MenuItem(copyMenu, 0);
        copyItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ErrorNotificationDialog.this.copyToClipboard();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ErrorNotificationDialog.this.copyToClipboard();
            }
        });
        copyItem.setText(JFaceResources.getString((String)"copy"));
        this.detailsList.setMenu(copyMenu);
    }

    private void setDetailsContents() {
        ArrayList<String> statusList = new ArrayList<String>();
        ErrorInfo info = this.getSingleSelection();
        if (info != null) {
            this.selectedError = info;
            statusList.add(this.selectedError.getErrorStatus().getMessage());
            if (this.selectedError.getErrorStatus().getException() != null) {
                Throwable exception = this.selectedError.getErrorStatus().getException();
                statusList.add(exception.toString());
                StackTraceElement[] elements = exception.getStackTrace();
                int i = 0;
                while (i < elements.length) {
                    statusList.add(elements[i].toString());
                    ++i;
                }
            }
            IStatus[] statuses = this.selectedError.getErrorStatus().getChildren();
            int i = 0;
            while (i < statuses.length) {
                statusList.add(NESTING_INDENT + statuses[i].getMessage());
                ++i;
            }
        }
        String[] items = new String[statusList.size()];
        statusList.toArray(items);
        this.detailsList.setItems(items);
    }

    private void copyToClipboard() {
        if (this.selectedError == null) {
            return;
        }
        if (this.clipboard != null) {
            this.clipboard.dispose();
        }
        StringBuffer statusBuffer = new StringBuffer();
        this.populateCopyBuffer(this.selectedError.getErrorStatus(), statusBuffer, 0);
        this.clipboard = new Clipboard(this.detailsList.getDisplay());
        this.clipboard.setContents(new Object[]{statusBuffer.toString()}, new Transfer[]{TextTransfer.getInstance()});
    }

    private void populateCopyBuffer(IStatus buildingStatus, StringBuffer buffer, int nesting) {
        int i = 0;
        while (i < nesting) {
            buffer.append(NESTING_INDENT);
            ++i;
        }
        buffer.append(buildingStatus.getMessage());
        if (buildingStatus.getException() != null) {
            Throwable exception = buildingStatus.getException();
            buffer.append("\n");
            buffer.append(exception.toString());
            StackTraceElement[] elements = exception.getStackTrace();
            int i2 = 0;
            while (i2 < elements.length) {
                buffer.append("\n");
                buffer.append(elements[i2].toString());
                ++i2;
            }
        }
        buffer.append("\n");
        IStatus[] children = buildingStatus.getChildren();
        int i3 = 0;
        while (i3 < children.length) {
            this.populateCopyBuffer(children[i3], buffer, nesting + 1);
            ++i3;
        }
    }
}

