/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockRetrieval;
import org.eclipse.debug.internal.core.memory.IExtendedMemoryBlock;
import org.eclipse.debug.internal.core.memory.IMemoryBlockListener;
import org.eclipse.debug.internal.core.memory.IMemoryRendering;
import org.eclipse.debug.internal.core.memory.MemoryBlockManager;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.views.memory.AddMemoryBlockAction;
import org.eclipse.debug.internal.ui.views.memory.CopyViewTabToClipboardAction;
import org.eclipse.debug.internal.ui.views.memory.HexRenderer;
import org.eclipse.debug.internal.ui.views.memory.HexRendering;
import org.eclipse.debug.internal.ui.views.memory.IMemoryView;
import org.eclipse.debug.internal.ui.views.memory.IMemoryViewTab;
import org.eclipse.debug.internal.ui.views.memory.MemoryViewTab;
import org.eclipse.debug.internal.ui.views.memory.MemoryViewUtil;
import org.eclipse.debug.internal.ui.views.memory.PrintViewTabAction;
import org.eclipse.debug.internal.ui.views.memory.RemoveMemoryBlockAction;
import org.eclipse.debug.internal.ui.views.memory.ResetMemoryBlockAction;
import org.eclipse.debug.internal.ui.views.memory.SetDefaultColumnSizePrefAction;
import org.eclipse.debug.internal.ui.views.memory.ViewTabEnablementManager;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.debug.ui.IDebugView;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.PageBookView;
import org.eclipse.ui.texteditor.IUpdate;

public class MemoryView
extends PageBookView
implements IDebugView,
IMemoryBlockListener,
ISelectionListener,
IMemoryView {
    private Composite parent;
    protected StackLayout stackLayout;
    private TabFolder emptyTabFolder;
    protected Hashtable tabFolderHashtable;
    private Action addMemoryBlockAction;
    private Action removeMemoryBlockAction;
    private Action resetMemoryBlockAction;
    private Action copyViewToClipboardAction;
    private Action printViewTabAction;
    protected IMemoryBlockRetrieval key;
    private MemoryViewPartListener fListener = null;
    private boolean fVisible;
    protected MemoryViewSelectionProvider fSelectionProvider;
    protected ViewTabEnablementManager fViewTabEnablementManager;
    protected Hashtable fMenuMgr;
    static /* synthetic */ Class class$0;

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.parent = parent;
        this.stackLayout = new StackLayout();
        parent.setLayout((Layout)this.stackLayout);
        WorkbenchHelp.setHelp((Control)parent, (String)(String.valueOf(IDebugUIConstants.PLUGIN_ID) + ".MemoryView_context"));
        this.fSelectionProvider = new MemoryViewSelectionProvider();
        this.fViewTabEnablementManager = new ViewTabEnablementManager();
        this.makeActions();
        this.contributeToActionBars();
        this.getViewSite().getActionBars().updateActionBars();
        this.emptyTabFolder = new TabFolder(parent, 0);
        this.setTabFolder(this.emptyTabFolder);
        this.tabFolderHashtable = new Hashtable(3);
        this.fMenuMgr = new Hashtable();
        this.addListeners();
        ISelection selection = DebugUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection("org.eclipse.debug.ui.DebugView");
        if (MemoryViewUtil.isValidSelection(selection)) {
            this.createFolder(selection);
        }
        this.fVisible = true;
        this.getSite().setSelectionProvider((ISelectionProvider)this.fSelectionProvider);
    }

    protected void addListeners() {
        this.fListener = new MemoryViewPartListener(this);
        this.getSite().getPage().addPartListener((IPartListener2)this.fListener);
        MemoryBlockManager.getMemoryBlockManager().addListener((IMemoryBlockListener)this);
        DebugUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getSelectionService().addSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
        DebugUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getSelectionService().addSelectionListener((ISelectionListener)this);
    }

    private MenuManager createContextMenuManager() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                IMemoryViewTab top = MemoryView.this.getTopMemoryTab();
                if (top != null) {
                    top.fillContextMenu(manager);
                }
                manager.add((IContributionItem)new Separator("additions"));
            }
        });
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.fSelectionProvider);
        return menuMgr;
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalToolBar(bars.getToolBarManager());
        bars.getMenuManager().add((IAction)new SetDefaultColumnSizePrefAction());
        bars.updateActionBars();
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.addMemoryBlockAction);
        manager.add((IAction)this.removeMemoryBlockAction);
        manager.add((IAction)this.resetMemoryBlockAction);
        manager.add((IContributionItem)new Separator("Additions"));
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.addMemoryBlockAction);
        manager.add((IAction)this.removeMemoryBlockAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.resetMemoryBlockAction);
        manager.add((IAction)this.copyViewToClipboardAction);
        manager.add((IAction)this.printViewTabAction);
    }

    private void makeActions() {
        this.addMemoryBlockAction = new AddMemoryBlockAction();
        this.removeMemoryBlockAction = new RemoveMemoryBlockAction();
        this.removeMemoryBlockAction.setEnabled(false);
        this.resetMemoryBlockAction = new ResetMemoryBlockAction();
        this.resetMemoryBlockAction.setEnabled(false);
        this.copyViewToClipboardAction = new CopyViewTabToClipboardAction();
        this.copyViewToClipboardAction.setEnabled(false);
        this.printViewTabAction = new PrintViewTabAction();
        this.printViewTabAction.setEnabled(false);
    }

    public void setFocus() {
        this.stackLayout.topControl.setFocus();
    }

    public void MemoryBlockAdded(IMemoryBlock memoryblk) {
        IMemoryBlockRetrieval standardMemRetrieval;
        IMemoryBlock memory = memoryblk;
        if (this.getTopMemoryTab() != null) {
            this.getTopMemoryTab().setEnabled(false);
        }
        TabFolder tabFolder = (TabFolder)this.stackLayout.topControl;
        TabItem tab = new TabItem(tabFolder, 0);
        MenuManager menuMgr = this.createContextMenuManager();
        HexRendering hexRendering = new HexRendering(memory, "org.eclipse.debug.ui.rendering.raw_memory");
        MemoryViewTab memoryTab = new MemoryViewTab(memory, tab, menuMgr, hexRendering, new HexRenderer());
        this.fMenuMgr.put(memoryTab, menuMgr);
        tabFolder.setSelection(tabFolder.indexOf(memoryTab.getTab()));
        this.updateToolBarActionsEnablement();
        this.fSelectionProvider.setSelection((ISelection)new StructuredSelection((Object)memoryTab.getMemoryBlock()));
        IDebugTarget debugTarget = memory.getDebugTarget();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.debug.core.model.IMemoryBlockRetrieval");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((standardMemRetrieval = (IMemoryBlockRetrieval)memory.getAdapter((Class)clazz)) == null) {
            standardMemRetrieval = debugTarget;
        }
    }

    public void MemoryBlockRemoved(IMemoryBlock memoryblk) {
        final IMemoryBlock memory = memoryblk;
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                IMemoryViewTab viewTab;
                TabFolder tabFolder = (TabFolder)MemoryView.this.stackLayout.topControl;
                if (tabFolder.isDisposed()) {
                    return;
                }
                TabItem[] tabs = tabFolder.getItems();
                boolean foundTab = false;
                int i = 0;
                while (i < tabs.length) {
                    viewTab = (IMemoryViewTab)tabs[i].getData();
                    if (viewTab.getMemoryBlock() == memory) {
                        MemoryView.this.disposeViewTab(viewTab, tabs[i]);
                        foundTab = true;
                        break;
                    }
                    ++i;
                }
                if (foundTab && tabFolder.getItemCount() == 0) {
                    MemoryView.this.removeMemoryBlockAction.setEnabled(false);
                    MemoryView.this.resetMemoryBlockAction.setEnabled(false);
                    MemoryView.this.copyViewToClipboardAction.setEnabled(false);
                    MemoryView.this.printViewTabAction.setEnabled(false);
                    MemoryView.this.fSelectionProvider.setSelection((ISelection)new StructuredSelection(new Object[0]));
                    IDebugTarget dt = memory.getDebugTarget();
                    if (dt.isTerminated() || dt.isDisconnected()) {
                        if (MemoryView.this.key != null) {
                            MemoryView.this.tabFolderHashtable.remove(MemoryView.this.key);
                        }
                        if (!tabFolder.isDisposed()) {
                            tabFolder.dispose();
                        }
                        MemoryView.this.emptyFolder();
                    }
                }
                if (!foundTab) {
                    Enumeration enumeration = MemoryView.this.tabFolderHashtable.elements();
                    while (enumeration.hasMoreElements()) {
                        IDebugTarget dt;
                        tabFolder = (TabFolder)enumeration.nextElement();
                        tabs = tabFolder.getItems();
                        viewTab = null;
                        int i2 = 0;
                        while (i2 < tabs.length) {
                            viewTab = (IMemoryViewTab)tabs[i2].getData();
                            if (viewTab.getMemoryBlock() == memory) {
                                MemoryView.this.disposeViewTab(viewTab, tabs[i2]);
                                foundTab = true;
                                break;
                            }
                            ++i2;
                        }
                        if (!foundTab) continue;
                        if (tabFolder.getItemCount() != 0 || !(dt = memory.getDebugTarget()).isTerminated() && !dt.isDisconnected()) break;
                        Enumeration keyEnum = MemoryView.this.tabFolderHashtable.keys();
                        Object tabKey = null;
                        while (keyEnum.hasMoreElements()) {
                            tabKey = keyEnum.nextElement();
                            if (MemoryView.this.tabFolderHashtable.get(tabKey) == tabFolder) break;
                        }
                        if (!tabFolder.isDisposed()) {
                            tabFolder.dispose();
                        }
                        if (tabKey != null) {
                            MemoryView.this.tabFolderHashtable.remove(tabKey);
                        }
                        MemoryView.this.emptyFolder();
                        break;
                    }
                }
            }
        });
    }

    public void dispose() {
        this.removeListeners();
        this.emptyTabFolder.dispose();
        try {
            if (this.tabFolderHashtable != null) {
                Enumeration enumeration = this.tabFolderHashtable.elements();
                while (enumeration.hasMoreElements()) {
                    TabFolder tabFolder = (TabFolder)enumeration.nextElement();
                    if (tabFolder.isDisposed()) continue;
                    TabItem[] tabs = tabFolder.getItems();
                    int i = 0;
                    while (i < tabs.length) {
                        IMemoryViewTab viewTab = (IMemoryViewTab)tabs[i].getData();
                        if (!tabs[i].isDisposed()) {
                            this.disposeViewTab(viewTab, tabs[i]);
                        }
                        ++i;
                    }
                    tabFolder.dispose();
                }
                this.tabFolderHashtable = null;
            }
        }
        catch (Exception e) {
            Status status = new Status(4, DebugUIPlugin.getUniqueIdentifier(), 0, "Exception occurred when the Memory  View is disposed", (Throwable)e);
            DebugUIPlugin.log((IStatus)status);
        }
        super.dispose();
    }

    private void removeListeners() {
        MemoryBlockManager.getMemoryBlockManager().removeListener((IMemoryBlockListener)this);
        DebugUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getSelectionService().removeSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
        DebugUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getSelectionService().removeSelectionListener((ISelectionListener)this);
        this.getSite().getPage().removePartListener((IPartListener2)this.fListener);
        this.fListener = null;
    }

    protected IPage createDefaultPage(PageBook book) {
        ViewerPage page = new ViewerPage();
        page.createControl((Composite)book);
        this.initPage((IPageBookViewPage)page);
        return page;
    }

    protected PageBookView.PageRec doCreatePage(IWorkbenchPart part) {
        return null;
    }

    protected void doDestroyPage(IWorkbenchPart part, PageBookView.PageRec pageRecord) {
    }

    protected IWorkbenchPart getBootstrapPart() {
        return null;
    }

    protected boolean isImportant(IWorkbenchPart part) {
        return false;
    }

    public Viewer getViewer() {
        return null;
    }

    public IDebugModelPresentation getPresentation(String id) {
        return null;
    }

    public void setAction(String actionID, IAction action) {
    }

    public void add(IUpdate updatable) {
    }

    public void remove(IUpdate updatable) {
    }

    public IAction getAction(String actionID) {
        return null;
    }

    public IMenuManager getContextMenuManager() {
        return null;
    }

    public IMemoryViewTab getTopMemoryTab() {
        TabFolder folder;
        int index;
        if (this.stackLayout.topControl instanceof TabFolder && (index = (folder = (TabFolder)this.stackLayout.topControl).getSelectionIndex()) >= 0) {
            TabItem tab = folder.getItem(index);
            return (IMemoryViewTab)tab.getData();
        }
        return null;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        block10: {
            try {
                if (part == this) {
                    return;
                }
                if (!(selection instanceof IStructuredSelection)) {
                    return;
                }
                IMemoryViewTab lastViewTab = this.getTopMemoryTab();
                if (selection == null || selection.isEmpty() || ((IStructuredSelection)selection).size() > 1) {
                    return;
                }
                Object elem = ((IStructuredSelection)selection).getFirstElement();
                if (elem instanceof IMemoryRendering) {
                    this.handleMemoryBlockSelection(lastViewTab, ((IMemoryRendering)elem).getBlock());
                    break block10;
                }
                if (elem instanceof IMemoryBlock) {
                    this.handleMemoryBlockSelection(lastViewTab, (IMemoryBlock)elem);
                    break block10;
                }
                if (elem instanceof IDebugElement) {
                    this.handleDebugElementSelection(lastViewTab, (IDebugElement)elem);
                    break block10;
                }
                if (part.getSite().getId().equals("org.eclipse.debug.ui.DebugView")) {
                    if (lastViewTab != null) {
                        lastViewTab.setEnabled(false);
                    }
                    this.emptyFolder();
                }
                this.key = null;
                return;
            }
            catch (SWTException se) {
                Status status = new Status(4, DebugUIPlugin.getUniqueIdentifier(), 0, "SWT Exception occurred in Memory View selection changed", (Throwable)se);
                DebugUIPlugin.log((IStatus)status);
            }
        }
    }

    private void handleMemoryBlockSelection(IMemoryViewTab lastViewTab, IMemoryBlock memoryBlock) {
        if (this.getTopMemoryTab() != null) {
            if (this.getTopMemoryTab().getMemoryBlock() == memoryBlock) {
                return;
            }
            TabFolder folder = (TabFolder)this.stackLayout.topControl;
            TabItem[] items = folder.getItems();
            int i = 0;
            while (i < items.length) {
                IMemoryViewTab viewTab = (IMemoryViewTab)items[i].getData();
                if (viewTab.getMemoryBlock() == memoryBlock) {
                    boolean isEnabled = lastViewTab.isEnabled();
                    lastViewTab.setEnabled(false);
                    folder.setSelection(i);
                    this.fSelectionProvider.setSelection((ISelection)new StructuredSelection((Object)memoryBlock));
                    this.getTopMemoryTab().setEnabled(isEnabled);
                    break;
                }
                ++i;
            }
        }
    }

    private void handleDebugElementSelection(IMemoryViewTab lastViewTab, IDebugElement elem) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.debug.core.model.IMemoryBlockRetrieval");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IMemoryBlockRetrieval retrieve = (IMemoryBlockRetrieval)elem.getAdapter((Class)clazz);
        IDebugTarget debugTarget = elem.getDebugTarget();
        if (retrieve == null) {
            retrieve = debugTarget;
        }
        this.key = retrieve;
        if (debugTarget == null || debugTarget.isTerminated() || debugTarget.isDisconnected()) {
            this.emptyFolder();
            if (this.tabFolderHashtable != null && this.tabFolderHashtable.containsKey(this.key)) {
                TabFolder deleteFolder = (TabFolder)this.tabFolderHashtable.get(this.key);
                if (!deleteFolder.isDisposed()) {
                    deleteFolder.dispose();
                }
                this.tabFolderHashtable.remove(this.key);
            }
            this.key = null;
            return;
        }
        if (this.tabFolderHashtable == null) {
            this.emptyFolder();
            this.key = null;
            return;
        }
        if (this.tabFolderHashtable.containsKey(retrieve)) {
            if (this.stackLayout.topControl != (TabFolder)this.tabFolderHashtable.get(retrieve)) {
                this.setTabFolder((TabFolder)this.tabFolderHashtable.get(retrieve));
                this.parent.layout();
            }
        } else {
            this.tabFolderHashtable.put(retrieve, new TabFolder(this.parent, 0));
            this.setTabFolder((TabFolder)this.tabFolderHashtable.get(retrieve));
            this.parent.layout();
        }
        IMemoryBlock[] memoryBlocks = MemoryBlockManager.getMemoryBlockManager().getMemoryBlocks(retrieve);
        TabFolder toDisplay = (TabFolder)this.stackLayout.topControl;
        if (toDisplay.getItemCount() == 0) {
            this.restoreViewTabs(memoryBlocks);
        }
        IMemoryViewTab newViewTab = this.getTopMemoryTab();
        if (lastViewTab != null && lastViewTab != newViewTab) {
            lastViewTab.setEnabled(false);
        }
        if (newViewTab != null && !newViewTab.isEnabled() && this.fVisible) {
            newViewTab.setEnabled(true);
            this.fSelectionProvider.setSelection((ISelection)new StructuredSelection((Object)newViewTab.getMemoryBlock()));
        }
        this.updateToolBarActionsEnablement();
    }

    protected void emptyFolder() {
        this.setTabFolder(this.emptyTabFolder);
        if (!this.parent.isDisposed()) {
            this.parent.layout();
        }
        this.removeMemoryBlockAction.setEnabled(false);
        this.resetMemoryBlockAction.setEnabled(false);
        this.copyViewToClipboardAction.setEnabled(false);
        this.printViewTabAction.setEnabled(false);
        this.fSelectionProvider.setSelection((ISelection)new StructuredSelection(new Object[0]));
    }

    private void createFolder(ISelection selection) {
        IMemoryBlockRetrieval memRetrieval;
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        if (selection == null || selection.isEmpty() || ((IStructuredSelection)selection).size() > 1) {
            return;
        }
        Object elem = ((IStructuredSelection)selection).getFirstElement();
        if (!(elem instanceof IDebugElement)) {
            return;
        }
        IDebugTarget debugTarget = ((IDebugElement)elem).getDebugTarget();
        IDebugElement iDebugElement = (IDebugElement)elem;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.debug.core.model.IMemoryBlockRetrieval");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((memRetrieval = (IMemoryBlockRetrieval)iDebugElement.getAdapter((Class)clazz)) == null) {
            memRetrieval = debugTarget;
        }
        if (this.tabFolderHashtable.containsKey(memRetrieval)) {
            if (this.stackLayout.topControl != (TabFolder)this.tabFolderHashtable.get(memRetrieval)) {
                this.setTabFolder((TabFolder)this.tabFolderHashtable.get(memRetrieval));
                this.parent.layout();
            }
        } else {
            this.tabFolderHashtable.put(memRetrieval, new TabFolder(this.parent, 0));
            this.setTabFolder((TabFolder)this.tabFolderHashtable.get(memRetrieval));
            this.parent.layout();
        }
        this.updateToolBarActionsEnablement();
    }

    protected void updateToolBarActionsEnablement() {
        TabFolder folder = (TabFolder)this.stackLayout.topControl;
        int index = folder.getSelectionIndex();
        if (index >= 0) {
            this.removeMemoryBlockAction.setEnabled(true);
            this.resetMemoryBlockAction.setEnabled(true);
            this.copyViewToClipboardAction.setEnabled(true);
            this.printViewTabAction.setEnabled(true);
        } else {
            this.removeMemoryBlockAction.setEnabled(false);
            this.resetMemoryBlockAction.setEnabled(false);
            this.copyViewToClipboardAction.setEnabled(false);
            this.printViewTabAction.setEnabled(false);
        }
    }

    private void restoreViewTabs(IMemoryBlock[] memoryBlocks) {
        int i = 0;
        while (i < memoryBlocks.length) {
            if (memoryBlocks[i] instanceof IExtendedMemoryBlock) {
                ((IExtendedMemoryBlock)memoryBlocks[i]).enable();
            }
            this.MemoryBlockAdded(memoryBlocks[i]);
            if (memoryBlocks[i] instanceof IExtendedMemoryBlock) {
                ((IExtendedMemoryBlock)memoryBlocks[i]).disable();
            }
            ++i;
        }
        IMemoryViewTab viewTab = this.getTopMemoryTab();
        if (viewTab != null && viewTab.getMemoryBlock() instanceof IExtendedMemoryBlock) {
            ((IExtendedMemoryBlock)viewTab.getMemoryBlock()).enable();
        }
    }

    private void setTabFolder(TabFolder folder) {
        TabFolder old;
        if (this.stackLayout.topControl != null && !(old = (TabFolder)this.stackLayout.topControl).isDisposed()) {
            old.removeSelectionListener((SelectionListener)this.fSelectionProvider);
            old.removeSelectionListener((SelectionListener)this.fViewTabEnablementManager);
        }
        this.stackLayout.topControl = folder;
        if (folder.getItemCount() > 0) {
            TabItem[] selectedItem = folder.getSelection();
            if (selectedItem.length > 0) {
                IMemoryViewTab viewTab = (IMemoryViewTab)selectedItem[0].getData();
                this.fSelectionProvider.setSelection((ISelection)new StructuredSelection((Object)viewTab.getMemoryBlock()));
            }
        } else {
            this.fSelectionProvider.setSelection((ISelection)new StructuredSelection());
        }
        folder.addSelectionListener((SelectionListener)this.fSelectionProvider);
        folder.addSelectionListener((SelectionListener)this.fViewTabEnablementManager);
    }

    private void disposeViewTab(IMemoryViewTab viewTab, TabItem tabItem) {
        if (viewTab == null) {
            return;
        }
        IMenuManager menuMgr = (IMenuManager)this.fMenuMgr.get(viewTab);
        if (menuMgr != null) {
            menuMgr.dispose();
        }
        viewTab.dispose();
        if (tabItem == null) {
            return;
        }
        if (!tabItem.isDisposed()) {
            tabItem.dispose();
        }
    }

    public IMemoryViewTab[] getAllViewTabs() {
        TabFolder folder = (TabFolder)this.stackLayout.topControl;
        TabItem[] items = folder.getItems();
        IMemoryViewTab[] viewTabs = new IMemoryViewTab[folder.getItemCount()];
        int i = 0;
        while (i < items.length) {
            viewTabs[i] = (IMemoryViewTab)items[i].getData();
            ++i;
        }
        return viewTabs;
    }

    public void moveToTop(IMemoryViewTab viewTab) {
        IMemoryViewTab lastViewTab = this.getTopMemoryTab();
        if (viewTab == lastViewTab) {
            return;
        }
        TabFolder folder = (TabFolder)this.stackLayout.topControl;
        TabItem[] items = folder.getItems();
        int i = 0;
        while (i < items.length) {
            IMemoryViewTab tab = (IMemoryViewTab)items[i].getData();
            if (viewTab == tab) {
                boolean isEnabled = lastViewTab.isEnabled();
                lastViewTab.setEnabled(false);
                folder.setSelection(i);
                this.fSelectionProvider.setSelection((ISelection)new StructuredSelection((Object)this.getTopMemoryTab().getMemoryBlock()));
                this.getTopMemoryTab().setEnabled(isEnabled);
                break;
            }
            ++i;
        }
    }

    class ViewerPage
    extends Page {
        ViewerPage() {
        }

        public void createControl(Composite parent) {
        }

        public Control getControl() {
            return null;
        }

        public void setFocus() {
            Control c;
            Viewer viewer = MemoryView.this.getViewer();
            if (viewer != null && !(c = viewer.getControl()).isFocusControl()) {
                c.setFocus();
            }
        }
    }

    class MemoryViewPartListener
    implements IPartListener2 {
        MemoryView fView = null;
        static /* synthetic */ Class class$0;

        public MemoryViewPartListener(MemoryView view) {
            this.fView = view;
        }

        public void partActivated(IWorkbenchPartReference ref) {
        }

        public void partBroughtToTop(IWorkbenchPartReference ref) {
        }

        public void partClosed(IWorkbenchPartReference ref) {
        }

        public void partDeactivated(IWorkbenchPartReference ref) {
        }

        public void partHidden(IWorkbenchPartReference ref) {
            IWorkbenchPart part = ref.getPart(false);
            if (part == this.fView) {
                MemoryView.this.fVisible = false;
                IMemoryViewTab top = MemoryView.this.getTopMemoryTab();
                if (top != null) {
                    top.setEnabled(false);
                }
            }
        }

        public void partVisible(IWorkbenchPartReference ref) {
            IWorkbenchPart part = ref.getPart(false);
            if (part == this.fView) {
                MemoryView.this.fVisible = true;
                ISelection selection = DebugUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection("org.eclipse.debug.ui.DebugView");
                if (MemoryViewUtil.isValidSelection(selection)) {
                    IMemoryViewTab top;
                    TabFolder toDisplay;
                    IMemoryBlockRetrieval memRetrieval;
                    Object elem = ((IStructuredSelection)selection).getFirstElement();
                    IDebugTarget debugTarget = ((IDebugElement)elem).getDebugTarget();
                    IDebugElement iDebugElement = (IDebugElement)elem;
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.eclipse.debug.core.model.IMemoryBlockRetrieval");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((memRetrieval = (IMemoryBlockRetrieval)iDebugElement.getAdapter((Class)clazz)) == null) {
                        memRetrieval = debugTarget;
                    }
                    if (MemoryView.this.tabFolderHashtable.containsKey(memRetrieval) && (toDisplay = (TabFolder)MemoryView.this.tabFolderHashtable.get(memRetrieval)) != null) {
                        MemoryView.this.setTabFolder(toDisplay);
                        MemoryView.this.parent.layout();
                        IMemoryBlock[] memoryBlocks = MemoryBlockManager.getMemoryBlockManager().getMemoryBlocks(debugTarget);
                        if (toDisplay.getItemCount() == 0) {
                            MemoryView.this.restoreViewTabs(memoryBlocks);
                        }
                    }
                    if ((top = MemoryView.this.getTopMemoryTab()) != null && !top.isEnabled()) {
                        top.setEnabled(true);
                    }
                }
            }
        }

        public void partInputChanged(IWorkbenchPartReference ref) {
        }

        public void partOpened(IWorkbenchPartReference ref) {
        }
    }

    class MemoryViewSelectionProvider
    implements ISelectionProvider,
    SelectionListener {
        ArrayList fListeners = new ArrayList();
        ISelection selectedMemoryBlock;

        MemoryViewSelectionProvider() {
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
            if (!this.fListeners.contains(listener)) {
                this.fListeners.add(listener);
            }
        }

        public ISelection getSelection() {
            return this.selectedMemoryBlock;
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            if (this.fListeners.contains(listener)) {
                this.fListeners.remove(listener);
            }
        }

        public void setSelection(ISelection selection) {
            this.selectedMemoryBlock = selection;
            this.fireChanged();
        }

        public void widgetSelected(SelectionEvent e) {
            if (MemoryView.this.getTopMemoryTab() == null) {
                return;
            }
            IMemoryBlock blk = MemoryView.this.getTopMemoryTab().getMemoryBlock();
            if (blk != null) {
                this.setSelection((ISelection)new StructuredSelection((Object)blk));
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void fireChanged() {
            SelectionChangedEvent evt = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
            int i = 0;
            while (i < this.fListeners.size()) {
                ((ISelectionChangedListener)this.fListeners.get(i)).selectionChanged(evt);
                ++i;
            }
        }
    }
}

