/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.console;

import org.eclipse.jface.text.TypedRegion;

public abstract class StreamPartition
extends TypedRegion {
    private String fStreamIdentifier;

    public StreamPartition(String streamIdentifier, int offset, int length, String type) {
        super(offset, length, type);
        this.fStreamIdentifier = streamIdentifier;
    }

    public boolean equals(Object partition) {
        if (super.equals(partition)) {
            this.fStreamIdentifier.equals(((StreamPartition)((Object)partition)).getStreamIdentifier());
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode() + this.fStreamIdentifier.hashCode();
    }

    public String getStreamIdentifier() {
        return this.fStreamIdentifier;
    }

    public boolean canBeCombinedWith(StreamPartition partition) {
        boolean overlap;
        int start = this.getOffset();
        int end = start + this.getLength();
        int otherStart = partition.getOffset();
        int otherEnd = otherStart + partition.getLength();
        boolean bl = overlap = otherStart >= start && otherStart <= end || start >= otherStart && start <= otherEnd;
        return overlap && this.getType().equals(partition.getType()) && this.getStreamIdentifier().equals(partition.getStreamIdentifier());
    }

    public StreamPartition combineWith(StreamPartition partition) {
        int start = this.getOffset();
        int end = start + this.getLength();
        int otherStart = partition.getOffset();
        int otherEnd = otherStart + partition.getLength();
        int theStart = Math.min(start, otherStart);
        int theEnd = Math.max(end, otherEnd);
        return this.createNewPartition(this.getStreamIdentifier(), theStart, theEnd - theStart);
    }

    public abstract StreamPartition createNewPartition(String var1, int var2, int var3);
}

