/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.sourcelookup;

import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourceContainerType;
import org.eclipse.debug.internal.ui.sourcelookup.SourceLookupUIUtils;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class SourceContainerLabelProvider
extends LabelProvider {
    private ILabelProvider fLabelProvider = null;

    public Image getImage(Object element) {
        Image image = this.getWorkbenchLabelProvider().getImage(element);
        if (image == null) {
            ISourceContainerType type = null;
            if (element instanceof ISourceContainer) {
                type = ((ISourceContainer)element).getType();
            } else if (element instanceof ISourceContainerType) {
                type = (ISourceContainerType)element;
            }
            if (type != null) {
                image = SourceLookupUIUtils.getSourceContainerImage(type.getId());
            }
        }
        if (image != null) {
            return image;
        }
        return super.getImage(element);
    }

    public String getText(Object element) {
        String label = this.getWorkbenchLabelProvider().getText(element);
        if (label == null || label.length() == 0) {
            if (element instanceof ISourceContainer) {
                return ((ISourceContainer)element).getName();
            }
            if (element instanceof ISourceContainerType) {
                return ((ISourceContainerType)element).getName();
            }
        } else {
            return label;
        }
        return super.getText(element);
    }

    private ILabelProvider getWorkbenchLabelProvider() {
        if (this.fLabelProvider == null) {
            this.fLabelProvider = new WorkbenchLabelProvider();
        }
        return this.fLabelProvider;
    }

    public void dispose() {
        super.dispose();
        if (this.fLabelProvider != null) {
            this.fLabelProvider.dispose();
        }
    }
}

