/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.launchConfigurations;

import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;

public class LaunchConfigurationTabImageDescriptor
extends CompositeImageDescriptor {
    public static final int ERROR = 1;
    private Image fBaseImage;
    private int fFlags;
    private Point fSize;

    public LaunchConfigurationTabImageDescriptor(Image baseImage, int flags) {
        this.setBaseImage(baseImage);
        this.setFlags(flags);
    }

    protected Point getSize() {
        if (this.fSize == null) {
            ImageData data = this.getBaseImage().getImageData();
            this.setSize(new Point(data.width, data.height));
        }
        return this.fSize;
    }

    public boolean equals(Object object) {
        if (!(object instanceof LaunchConfigurationTabImageDescriptor)) {
            return false;
        }
        LaunchConfigurationTabImageDescriptor other = (LaunchConfigurationTabImageDescriptor)((Object)object);
        return this.getBaseImage().equals((Object)other.getBaseImage()) && this.getFlags() == other.getFlags();
    }

    public int hashCode() {
        return this.getBaseImage().hashCode() | this.getFlags();
    }

    protected void drawCompositeImage(int width, int height) {
        ImageData bg = this.getBaseImage().getImageData();
        if (bg == null) {
            bg = ImageDescriptor.DEFAULT_IMAGE_DATA;
        }
        this.drawImage(bg, 0, 0);
        this.drawOverlays();
    }

    protected void drawOverlays() {
        int flags = this.getFlags();
        ImageData data = null;
        if ((flags & 1) != 0) {
            data = DebugUITools.getImage("IMG_OVR_ERROR").getImageData();
            this.drawImage(data, 0, 0);
        }
    }

    protected Image getBaseImage() {
        return this.fBaseImage;
    }

    protected void setBaseImage(Image baseImage) {
        this.fBaseImage = baseImage;
    }

    protected int getFlags() {
        return this.fFlags;
    }

    protected void setFlags(int flags) {
        this.fFlags = flags;
    }

    protected void setSize(Point size) {
        this.fSize = size;
    }
}

