/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.adaptor;

import org.eclipse.core.runtime.adaptor.EclipseAdaptorMsg;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.PlatformAdmin;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.VersionConstraint;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class EclipseCommandProvider
implements CommandProvider {
    private BundleContext context;
    static /* synthetic */ Class class$0;

    public EclipseCommandProvider(BundleContext context) {
        this.context = context;
    }

    public String getHelp() {
        StringBuffer help = new StringBuffer(512);
        help.append(EclipseAdaptorMsg.NEW_LINE);
        help.append("---");
        help.append(EclipseAdaptorMsg.formatter.getString("ECLIPSE_CONSOLE_COMMANDS_HEADER"));
        help.append("---");
        help.append(EclipseAdaptorMsg.NEW_LINE);
        help.append("\tdiag - " + EclipseAdaptorMsg.formatter.getString("ECLIPSE_CONSOLE_HELP_DIAG_COMMAND_DESCRIPTION"));
        help.append(EclipseAdaptorMsg.NEW_LINE);
        help.append("\tactive - " + EclipseAdaptorMsg.formatter.getString("ECLIPSE_CONSOLE_HELP_ACTIVE_COMMAND_DESCRIPTION"));
        return help.toString();
    }

    private BundleDescription getBundleDescriptionFromToken(State state, String token) {
        try {
            long id = Long.parseLong(token);
            return state.getBundle(id);
        }
        catch (NumberFormatException numberFormatException) {
            BundleDescription[] allBundles = state.getBundles(token);
            if (allBundles.length > 0) {
                return allBundles[0];
            }
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _diag(CommandInterpreter ci) throws Exception {
        ServiceReference platformAdminRef;
        block17: {
            block16: {
                String nextArg = ci.nextArgument();
                if (nextArg == null) {
                    ci.println((Object)EclipseAdaptorMsg.formatter.getString("ECLIPSE_CONSOLE_NO_BUNDLE_SPECIFIED_ERROR"));
                    return;
                }
                Class<?> clazz = class$0;
                if (clazz == null) {
                    Class<?> clazz2;
                    try {
                        clazz2 = Class.forName("org.eclipse.osgi.service.resolver.PlatformAdmin");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    clazz = class$0 = clazz2;
                }
                if ((platformAdminRef = this.context.getServiceReference(clazz.getName())) == null) {
                    ci.print((Object)"  ");
                    ci.println((Object)EclipseAdaptorMsg.formatter.getString("ECLIPSE_CONSOLE_NO_CONSTRAINTS_NO_PLATFORM_ADMIN_MESSAGE"));
                    return;
                }
                try {
                    PlatformAdmin platformAdmin = (PlatformAdmin)this.context.getService(platformAdminRef);
                    if (platformAdmin == null) {
                        Object var11_5 = null;
                        break block16;
                    }
                    State systemState = platformAdmin.getState(false);
                    block5: while (nextArg != null) {
                        BundleDescription bundle = this.getBundleDescriptionFromToken(systemState, nextArg);
                        if (bundle == null) {
                            ci.println((Object)EclipseAdaptorMsg.formatter.getString("ECLIPSE_CONSOLE_CANNOT_FIND_BUNDLE_ERROR", (Object)nextArg));
                            nextArg = ci.nextArgument();
                            continue;
                        }
                        ci.println((Object)(String.valueOf(bundle.getLocation()) + " [" + bundle.getBundleId() + "]"));
                        VersionConstraint[] unsatisfied = platformAdmin.getStateHelper().getUnsatisfiedConstraints(bundle);
                        if (unsatisfied.length == 0) {
                            String message = EclipseAdaptorMsg.formatter.getString("ECLIPSE_CONSOLE_NO_CONSTRAINTS");
                            if (!bundle.isResolved()) {
                                BundleDescription resolved;
                                String symbolicName = bundle.getSymbolicName();
                                BundleDescription bundleDescription = resolved = symbolicName == null ? null : this.getResolvedBundle(systemState, symbolicName);
                                if (resolved != null) {
                                    message = EclipseAdaptorMsg.formatter.getString("ECLIPSE_CONSOLE_OTHER_VERSION", (Object)resolved.getLocation());
                                }
                            }
                            ci.print((Object)"  ");
                            ci.println((Object)message);
                        }
                        int i = 0;
                        while (true) {
                            if (i >= unsatisfied.length) {
                                nextArg = ci.nextArgument();
                                continue block5;
                            }
                            ci.print((Object)"  ");
                            ci.println((Object)EclipseAdaptorMsg.getResolutionFailureMessage(unsatisfied[i]));
                            ++i;
                        }
                    }
                    break block17;
                }
                catch (Throwable throwable) {
                    Object var11_6 = null;
                    this.context.ungetService(platformAdminRef);
                    throw throwable;
                }
            }
            this.context.ungetService(platformAdminRef);
            return;
        }
        Object var11_7 = null;
        this.context.ungetService(platformAdminRef);
    }

    private BundleDescription getResolvedBundle(State state, String symbolicName) {
        BundleDescription[] homonyms = state.getBundles(symbolicName);
        int i = 0;
        while (i < homonyms.length) {
            if (homonyms[i].isResolved()) {
                return homonyms[i];
            }
            ++i;
        }
        return null;
    }

    public void _active(CommandInterpreter ci) throws Exception {
        Bundle[] allBundles = this.context.getBundles();
        int activeCount = 0;
        int i = 0;
        while (i < allBundles.length) {
            if (allBundles[i].getState() == 32) {
                ci.println((Object)allBundles[i]);
                ++activeCount;
            }
            ++i;
        }
        ci.print((Object)"  ");
        ci.println((Object)EclipseAdaptorMsg.formatter.getString("ECLIPSE_CONSOLE_BUNDLES_ACTIVE", activeCount));
    }
}

