/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.adaptor;

import java.util.Hashtable;
import org.eclipse.core.runtime.adaptor.EclipseAdaptor;
import org.eclipse.core.runtime.adaptor.EclipseAdaptorMsg;
import org.eclipse.core.runtime.adaptor.EclipseBundleData;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.BundleHost;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.StateHelper;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class BundleStopper {
    private Hashtable stoppedBundles;
    private BundleDescription[] allToStop = null;

    private void logCycles(Object[][] cycles) {
        if (cycles.length > 0) {
            StringBuffer cycleText = new StringBuffer("[");
            int i = 0;
            while (i < cycles.length) {
                cycleText.append('[');
                int j = 0;
                while (j < cycles[i].length) {
                    cycleText.append(((BundleDescription)cycles[i][j]).getSymbolicName());
                    cycleText.append(',');
                    ++j;
                }
                cycleText.insert(cycleText.length() - 1, ']');
                ++i;
            }
            cycleText.setCharAt(cycleText.length() - 1, ']');
            String message = EclipseAdaptorMsg.formatter.getString("ECLIPSE_BUNDLESTOPPER_CYCLES_FOUND", (Object)cycleText);
            FrameworkLogEntry entry = new FrameworkLogEntry("org.eclipse.osgi", message, 0, null, null);
            EclipseAdaptor.getDefault().getFrameworkLog().log(entry);
        }
    }

    public void stopBundles() {
        this.allToStop = EclipseAdaptor.getDefault().getState().getResolvedBundles();
        StateHelper stateHelper = EclipseAdaptor.getDefault().getPlatformAdmin().getStateHelper();
        Object[][] cycles = stateHelper.sortBundles(this.allToStop);
        this.logCycles(cycles);
        this.stoppedBundles = new Hashtable(this.allToStop.length);
        this.basicStopBundles();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void basicStopBundles() {
        BundleContext context = EclipseAdaptor.getDefault().getContext();
        int stoppingIndex = this.allToStop.length - 1;
        while (true) {
            block10: {
                Object var7_7;
                AbstractBundle toStop;
                block12: {
                    block11: {
                        if (stoppingIndex < 0) {
                            return;
                        }
                        toStop = (AbstractBundle)context.getBundle(this.allToStop[stoppingIndex].getBundleId());
                        try {
                            try {
                                block14: {
                                    block13: {
                                        if (toStop.getState() != 32 || !(toStop instanceof BundleHost)) break block13;
                                        if (toStop.getBundleId() != 0L) break block14;
                                    }
                                    var7_7 = null;
                                    this.stoppedBundles.put(toStop, toStop);
                                    break block10;
                                }
                                if (!((EclipseBundleData)toStop.getBundleData()).isAutoStartable()) {
                                    break block11;
                                }
                                toStop.stop();
                            }
                            catch (Exception e) {
                                String message = EclipseAdaptorMsg.formatter.getString("ECLIPSE_BUNDLESTOPPER_ERROR_STOPPING_BUNDLE", (Object)this.allToStop[stoppingIndex].toString());
                                FrameworkLogEntry entry = new FrameworkLogEntry("org.eclipse.osgi", message, 0, (Throwable)e, null);
                                EclipseAdaptor.getDefault().getFrameworkLog().log(entry);
                            }
                            break block12;
                        }
                        catch (Throwable throwable) {
                            var7_7 = null;
                            this.stoppedBundles.put(toStop, toStop);
                            throw throwable;
                        }
                    }
                    var7_7 = null;
                    this.stoppedBundles.put(toStop, toStop);
                    break block10;
                }
                var7_7 = null;
                this.stoppedBundles.put(toStop, toStop);
            }
            --stoppingIndex;
        }
    }

    public boolean isStopped(Bundle bundle) {
        if (this.stoppedBundles == null) {
            return false;
        }
        return this.stoppedBundles.get(bundle) != null;
    }
}

