/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.dependencies;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.internal.dependencies.Element;
import org.eclipse.core.internal.dependencies.ElementChange;

public class ResolutionDelta {
    private Map changes = new HashMap();

    ResolutionDelta() {
    }

    public ElementChange[] getAllChanges() {
        return this.changes.values().toArray(new ElementChange[this.changes.size()]);
    }

    public ElementChange getChange(Object id, Object versionId, Object userObject) {
        return (ElementChange)this.changes.get(new ElementIdentifier(id, versionId, userObject));
    }

    void recordChange(Element element, int kind) {
        ElementChange existingChange = this.getChange(element.getId(), element.getVersionId(), element.getUserObject());
        if (existingChange == null) {
            this.changes.put(new ElementIdentifier(element.getId(), element.getVersionId(), element.getUserObject()), new ElementChange(element, kind));
            return;
        }
        if (kind == 2) {
            if (existingChange.getKind() == 1) {
                this.changes.remove(new ElementIdentifier(element.getId(), element.getVersionId(), element.getUserObject()));
                return;
            }
            if ((existingChange.getKind() & 1) != 0) {
                existingChange.setKind(existingChange.getKind() & 0xFFFFFFFE | 2);
                return;
            }
        }
        existingChange.setKind(existingChange.getKind() | kind);
    }

    public String toString() {
        return this.changes.values().toString();
    }

    class ElementIdentifier {
        private Object id;
        private Object userObject;
        private Object versionId;

        ElementIdentifier(Object id, Object versionId, Object userObject) {
            this.id = id;
            this.versionId = versionId;
            this.userObject = userObject;
        }

        public boolean equals(Object anObject) {
            if (!(anObject instanceof ElementIdentifier)) {
                return false;
            }
            ElementIdentifier change = (ElementIdentifier)anObject;
            return change.userObject != null && change.userObject.equals(this.userObject) || this.id.equals(change.id) && this.versionId.equals(change.versionId) && change.userObject == null && this.userObject == null;
        }

        public int hashCode() {
            return this.id.hashCode() << 16 | this.versionId.hashCode() & 0xFFFF;
        }
    }
}

