/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.actions.JDTQuickMenuAction;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.internal.ui.javaeditor.JavaTextSelection;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.ui.actions.ChangeTypeAction;
import org.eclipse.jdt.ui.actions.ConvertAnonymousToNestedAction;
import org.eclipse.jdt.ui.actions.ConvertLocalToFieldAction;
import org.eclipse.jdt.ui.actions.ConvertNestedToTopAction;
import org.eclipse.jdt.ui.actions.ExtractConstantAction;
import org.eclipse.jdt.ui.actions.ExtractInterfaceAction;
import org.eclipse.jdt.ui.actions.ExtractMethodAction;
import org.eclipse.jdt.ui.actions.ExtractTempAction;
import org.eclipse.jdt.ui.actions.InlineAction;
import org.eclipse.jdt.ui.actions.IntroduceFactoryAction;
import org.eclipse.jdt.ui.actions.IntroduceParameterAction;
import org.eclipse.jdt.ui.actions.ModifyParametersAction;
import org.eclipse.jdt.ui.actions.MoveAction;
import org.eclipse.jdt.ui.actions.PullUpAction;
import org.eclipse.jdt.ui.actions.PushDownAction;
import org.eclipse.jdt.ui.actions.RenameAction;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jdt.ui.actions.SelfEncapsulateFieldAction;
import org.eclipse.jdt.ui.actions.UseSupertypeAction;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IKeyBindingService;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.part.Page;

public class RefactorActionGroup
extends ActionGroup {
    public static final String MENU_ID = "org.eclipse.jdt.ui.refactoring.menu";
    public static final String GROUP_REORG = "reorgGroup";
    public static final String GROUP_TYPE = "typeGroup";
    public static final String GROUP_CODING = "codingGroup";
    private IWorkbenchSite fSite;
    private CompilationUnitEditor fEditor;
    private String fGroupName = "group.reorganize";
    private SelectionDispatchAction fMoveAction;
    private SelectionDispatchAction fRenameAction;
    private SelectionDispatchAction fModifyParametersAction;
    private SelectionDispatchAction fConvertAnonymousToNestedAction;
    private SelectionDispatchAction fConvertNestedToTopAction;
    private SelectionDispatchAction fPullUpAction;
    private SelectionDispatchAction fPushDownAction;
    private SelectionDispatchAction fExtractInterfaceAction;
    private SelectionDispatchAction fChangeTypeAction;
    private SelectionDispatchAction fUseSupertypeAction;
    private SelectionDispatchAction fInlineAction;
    private SelectionDispatchAction fExtractMethodAction;
    private SelectionDispatchAction fExtractTempAction;
    private SelectionDispatchAction fExtractConstantAction;
    private SelectionDispatchAction fIntroduceParameterAction;
    private SelectionDispatchAction fIntroduceFactoryAction;
    private SelectionDispatchAction fConvertLocalToFieldAction;
    private SelectionDispatchAction fSelfEncapsulateField;
    private List fEditorActions;
    private static final String QUICK_MENU_ID = "org.eclipse.jdt.ui.edit.text.java.refactor.quickMenu";
    private RefactorQuickAccessAction fQuickAccessAction;
    private IKeyBindingService fKeyBindingService;
    private Action fNoActionAvailable = new NoActionAvailable();

    public RefactorActionGroup(IViewPart part) {
        this((IWorkbenchSite)part.getSite(), part.getSite().getKeyBindingService());
    }

    public RefactorActionGroup(Page page) {
        this((IWorkbenchSite)page.getSite(), null);
    }

    public RefactorActionGroup(CompilationUnitEditor editor, String groupName) {
        this.fSite = editor.getEditorSite();
        this.fEditor = editor;
        this.fGroupName = groupName;
        ISelectionProvider provider = editor.getSelectionProvider();
        ISelection selection = provider.getSelection();
        this.fEditorActions = new ArrayList();
        this.fRenameAction = new RenameAction(editor);
        this.fRenameAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.rename.element");
        this.fRenameAction.update(selection);
        editor.setAction("RenameElement", (IAction)this.fRenameAction);
        this.fEditorActions.add(this.fRenameAction);
        this.fMoveAction = new MoveAction(editor);
        this.fMoveAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.move.element");
        this.fMoveAction.update(selection);
        editor.setAction("MoveElement", (IAction)this.fMoveAction);
        this.fEditorActions.add(this.fMoveAction);
        this.fModifyParametersAction = new ModifyParametersAction(editor);
        this.fModifyParametersAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.modify.method.parameters");
        this.fModifyParametersAction.update(selection);
        editor.setAction("ModifyParameters", (IAction)this.fModifyParametersAction);
        this.fEditorActions.add(this.fModifyParametersAction);
        this.fConvertAnonymousToNestedAction = new ConvertAnonymousToNestedAction(editor);
        this.fConvertAnonymousToNestedAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.convert.anonymous.to.nested");
        RefactorActionGroup.initAction(this.fConvertAnonymousToNestedAction, provider, selection);
        editor.setAction("ConvertAnonymousToNested", (IAction)this.fConvertAnonymousToNestedAction);
        this.fEditorActions.add(this.fConvertAnonymousToNestedAction);
        this.fConvertNestedToTopAction = new ConvertNestedToTopAction(editor);
        this.fConvertNestedToTopAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.move.inner.to.top.level");
        this.fConvertNestedToTopAction.update(selection);
        editor.setAction("MoveInnerToTop", (IAction)this.fConvertNestedToTopAction);
        this.fEditorActions.add(this.fConvertNestedToTopAction);
        this.fPullUpAction = new PullUpAction(editor);
        this.fPullUpAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.pull.up");
        this.fPullUpAction.update(selection);
        editor.setAction("PullUp", (IAction)this.fPullUpAction);
        this.fEditorActions.add(this.fPullUpAction);
        this.fPushDownAction = new PushDownAction(editor);
        this.fPushDownAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.push.down");
        this.fPushDownAction.update(selection);
        editor.setAction("PushDown", (IAction)this.fPushDownAction);
        this.fEditorActions.add(this.fPushDownAction);
        this.fExtractInterfaceAction = new ExtractInterfaceAction(editor);
        this.fExtractInterfaceAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.extract.interface");
        this.fExtractInterfaceAction.update(selection);
        editor.setAction("ExtractInterface", (IAction)this.fExtractInterfaceAction);
        this.fEditorActions.add(this.fExtractInterfaceAction);
        this.fChangeTypeAction = new ChangeTypeAction(editor);
        this.fChangeTypeAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.change.type");
        RefactorActionGroup.initAction(this.fChangeTypeAction, provider, selection);
        editor.setAction("ChangeType", (IAction)this.fChangeTypeAction);
        this.fEditorActions.add(this.fChangeTypeAction);
        this.fUseSupertypeAction = new UseSupertypeAction(editor);
        this.fUseSupertypeAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.use.supertype");
        this.fUseSupertypeAction.update(selection);
        editor.setAction("UseSupertype", (IAction)this.fUseSupertypeAction);
        this.fEditorActions.add(this.fUseSupertypeAction);
        this.fInlineAction = new InlineAction(editor);
        this.fInlineAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.inline");
        this.fInlineAction.update(selection);
        editor.setAction("Inline", (IAction)this.fInlineAction);
        this.fEditorActions.add(this.fInlineAction);
        this.fExtractMethodAction = new ExtractMethodAction(editor);
        this.fExtractMethodAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.extract.method");
        RefactorActionGroup.initAction(this.fExtractMethodAction, provider, selection);
        editor.setAction("ExtractMethod", (IAction)this.fExtractMethodAction);
        this.fEditorActions.add(this.fExtractMethodAction);
        this.fExtractTempAction = new ExtractTempAction(editor);
        this.fExtractTempAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.extract.local.variable");
        RefactorActionGroup.initAction(this.fExtractTempAction, provider, selection);
        editor.setAction("ExtractLocalVariable", (IAction)this.fExtractTempAction);
        this.fEditorActions.add(this.fExtractTempAction);
        this.fExtractConstantAction = new ExtractConstantAction(editor);
        this.fExtractConstantAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.extract.constant");
        RefactorActionGroup.initAction(this.fExtractConstantAction, provider, selection);
        editor.setAction("ExtractConstant", (IAction)this.fExtractConstantAction);
        this.fEditorActions.add(this.fExtractConstantAction);
        this.fIntroduceParameterAction = new IntroduceParameterAction(editor);
        this.fIntroduceParameterAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.introduce.parameter");
        RefactorActionGroup.initAction(this.fIntroduceParameterAction, provider, selection);
        editor.setAction("IntroduceParameter", (IAction)this.fIntroduceParameterAction);
        this.fEditorActions.add(this.fIntroduceParameterAction);
        this.fIntroduceFactoryAction = new IntroduceFactoryAction(editor);
        this.fIntroduceFactoryAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.introduce.factory");
        RefactorActionGroup.initAction(this.fIntroduceFactoryAction, provider, selection);
        editor.setAction("IntroduceFactory", (IAction)this.fIntroduceFactoryAction);
        this.fEditorActions.add(this.fIntroduceFactoryAction);
        this.fConvertLocalToFieldAction = new ConvertLocalToFieldAction(editor);
        this.fConvertLocalToFieldAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.promote.local.variable");
        RefactorActionGroup.initAction(this.fConvertLocalToFieldAction, provider, selection);
        editor.setAction("PromoteTemp", (IAction)this.fConvertLocalToFieldAction);
        this.fEditorActions.add(this.fConvertLocalToFieldAction);
        this.fSelfEncapsulateField = new SelfEncapsulateFieldAction(editor);
        this.fSelfEncapsulateField.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.self.encapsulate.field");
        this.fSelfEncapsulateField.update(selection);
        editor.setAction("SelfEncapsulateField", (IAction)this.fSelfEncapsulateField);
        this.fEditorActions.add(this.fSelfEncapsulateField);
        this.fQuickAccessAction = new RefactorQuickAccessAction(editor);
        this.fKeyBindingService = editor.getEditorSite().getKeyBindingService();
        this.fKeyBindingService.registerAction((IAction)this.fQuickAccessAction);
    }

    private RefactorActionGroup(IWorkbenchSite site, IKeyBindingService keyBindingService) {
        this.fSite = site;
        ISelectionProvider provider = this.fSite.getSelectionProvider();
        ISelection selection = provider.getSelection();
        this.fMoveAction = new MoveAction(site);
        this.fMoveAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.move.element");
        RefactorActionGroup.initAction(this.fMoveAction, provider, selection);
        this.fRenameAction = new RenameAction(site);
        this.fRenameAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.rename.element");
        RefactorActionGroup.initAction(this.fRenameAction, provider, selection);
        this.fModifyParametersAction = new ModifyParametersAction(this.fSite);
        this.fModifyParametersAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.modify.method.parameters");
        RefactorActionGroup.initAction(this.fModifyParametersAction, provider, selection);
        this.fPullUpAction = new PullUpAction(this.fSite);
        this.fPullUpAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.pull.up");
        RefactorActionGroup.initAction(this.fPullUpAction, provider, selection);
        this.fPushDownAction = new PushDownAction(this.fSite);
        this.fPushDownAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.push.down");
        RefactorActionGroup.initAction(this.fPushDownAction, provider, selection);
        this.fSelfEncapsulateField = new SelfEncapsulateFieldAction(this.fSite);
        this.fSelfEncapsulateField.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.self.encapsulate.field");
        RefactorActionGroup.initAction(this.fSelfEncapsulateField, provider, selection);
        this.fExtractInterfaceAction = new ExtractInterfaceAction(this.fSite);
        this.fExtractInterfaceAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.extract.interface");
        RefactorActionGroup.initAction(this.fExtractInterfaceAction, provider, selection);
        this.fChangeTypeAction = new ChangeTypeAction(this.fSite);
        this.fChangeTypeAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.change.type");
        RefactorActionGroup.initAction(this.fChangeTypeAction, provider, selection);
        this.fConvertNestedToTopAction = new ConvertNestedToTopAction(this.fSite);
        this.fConvertNestedToTopAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.move.inner.to.top.level");
        RefactorActionGroup.initAction(this.fConvertNestedToTopAction, provider, selection);
        this.fUseSupertypeAction = new UseSupertypeAction(this.fSite);
        this.fUseSupertypeAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.use.supertype");
        RefactorActionGroup.initAction(this.fUseSupertypeAction, provider, selection);
        this.fInlineAction = new InlineAction(this.fSite);
        this.fInlineAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.inline");
        RefactorActionGroup.initAction(this.fInlineAction, provider, selection);
        this.fIntroduceFactoryAction = new IntroduceFactoryAction(this.fSite);
        this.fIntroduceFactoryAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.introduce.factory");
        RefactorActionGroup.initAction(this.fIntroduceFactoryAction, provider, selection);
        this.fConvertAnonymousToNestedAction = new ConvertAnonymousToNestedAction(this.fSite);
        this.fConvertAnonymousToNestedAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.convert.anonymous.to.nested");
        RefactorActionGroup.initAction(this.fConvertAnonymousToNestedAction, provider, selection);
        this.fKeyBindingService = keyBindingService;
        if (this.fKeyBindingService != null) {
            this.fQuickAccessAction = new RefactorQuickAccessAction(null);
            this.fKeyBindingService.registerAction((IAction)this.fQuickAccessAction);
        }
    }

    private static void initAction(SelectionDispatchAction action, ISelectionProvider provider, ISelection selection) {
        action.update(selection);
        provider.addSelectionChangedListener((ISelectionChangedListener)action);
    }

    public void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
        actionBars.setGlobalActionHandler("org.eclipse.jdt.ui.actions.SelfEncapsulateField", (IAction)this.fSelfEncapsulateField);
        actionBars.setGlobalActionHandler("org.eclipse.jdt.ui.actions.Move", (IAction)this.fMoveAction);
        actionBars.setGlobalActionHandler("org.eclipse.jdt.ui.actions.Rename", (IAction)this.fRenameAction);
        actionBars.setGlobalActionHandler("org.eclipse.jdt.ui.actions.ModifyParameters", (IAction)this.fModifyParametersAction);
        actionBars.setGlobalActionHandler("org.eclipse.jdt.ui.actions.PullUp", (IAction)this.fPullUpAction);
        actionBars.setGlobalActionHandler("org.eclipse.jdt.ui.actions.PushDown", (IAction)this.fPushDownAction);
        actionBars.setGlobalActionHandler("org.eclipse.jdt.ui.actions.ExtractTemp", (IAction)this.fExtractTempAction);
        actionBars.setGlobalActionHandler("org.eclipse.jdt.ui.actions.ExtractConstant", (IAction)this.fExtractConstantAction);
        actionBars.setGlobalActionHandler("org.eclipse.jdt.ui.actions.IntroduceParameter", (IAction)this.fIntroduceParameterAction);
        actionBars.setGlobalActionHandler("org.eclipse.jdt.ui.actions.IntroduceFactory", (IAction)this.fIntroduceFactoryAction);
        actionBars.setGlobalActionHandler("org.eclipse.jdt.ui.actions.ExtractMethod", (IAction)this.fExtractMethodAction);
        actionBars.setGlobalActionHandler("org.eclipse.jdt.ui.actions.Inline", (IAction)this.fInlineAction);
        actionBars.setGlobalActionHandler("org.eclipse.jdt.ui.actions.ExtractInterface", (IAction)this.fExtractInterfaceAction);
        actionBars.setGlobalActionHandler("org.eclipse.jdt.ui.actions.ChangeType", (IAction)this.fChangeTypeAction);
        actionBars.setGlobalActionHandler("org.eclipse.jdt.ui.actions.ConvertNestedToTop", (IAction)this.fConvertNestedToTopAction);
        actionBars.setGlobalActionHandler("org.eclipse.jdt.ui.actions.UseSupertype", (IAction)this.fUseSupertypeAction);
        actionBars.setGlobalActionHandler("org.eclipse.jdt.ui.actions.ConvertLocalToField", (IAction)this.fConvertLocalToFieldAction);
        actionBars.setGlobalActionHandler("org.eclipse.jdt.ui.actions.ConvertAnonymousToNested", (IAction)this.fConvertAnonymousToNestedAction);
    }

    public void retargetFileMenuActions(IActionBars actionBars) {
        actionBars.setGlobalActionHandler(ActionFactory.RENAME.getId(), (IAction)this.fRenameAction);
        actionBars.setGlobalActionHandler(ActionFactory.MOVE.getId(), (IAction)this.fMoveAction);
    }

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        this.addRefactorSubmenu(menu);
    }

    public void dispose() {
        ISelectionProvider provider = this.fSite.getSelectionProvider();
        this.disposeAction(this.fSelfEncapsulateField, provider);
        this.disposeAction(this.fMoveAction, provider);
        this.disposeAction(this.fRenameAction, provider);
        this.disposeAction(this.fModifyParametersAction, provider);
        this.disposeAction(this.fPullUpAction, provider);
        this.disposeAction(this.fPushDownAction, provider);
        this.disposeAction(this.fExtractTempAction, provider);
        this.disposeAction(this.fExtractConstantAction, provider);
        this.disposeAction(this.fIntroduceParameterAction, provider);
        this.disposeAction(this.fIntroduceFactoryAction, provider);
        this.disposeAction(this.fExtractMethodAction, provider);
        this.disposeAction(this.fInlineAction, provider);
        this.disposeAction(this.fExtractInterfaceAction, provider);
        this.disposeAction(this.fChangeTypeAction, provider);
        this.disposeAction(this.fConvertNestedToTopAction, provider);
        this.disposeAction(this.fUseSupertypeAction, provider);
        this.disposeAction(this.fConvertLocalToFieldAction, provider);
        this.disposeAction(this.fConvertAnonymousToNestedAction, provider);
        if (this.fQuickAccessAction != null && this.fKeyBindingService != null) {
            this.fKeyBindingService.unregisterAction((IAction)this.fQuickAccessAction);
        }
        super.dispose();
    }

    private void disposeAction(ISelectionChangedListener action, ISelectionProvider provider) {
        if (action != null) {
            provider.removeSelectionChangedListener(action);
        }
    }

    private void addRefactorSubmenu(IMenuManager menu) {
        String shortCut = null;
        if (this.fQuickAccessAction != null) {
            shortCut = this.fQuickAccessAction.getShortCutString();
        }
        MenuManager refactorSubmenu = new MenuManager(String.valueOf(ActionMessages.getString("RefactorMenu.label")) + (shortCut != null ? "\t" + shortCut : ""), MENU_ID);
        if (this.fEditor != null) {
            IJavaElement element = SelectionConverter.getInput(this.fEditor);
            if (element != null && ActionUtil.isOnBuildPath(element)) {
                refactorSubmenu.addMenuListener(new IMenuListener(){

                    public void menuAboutToShow(IMenuManager manager) {
                        RefactorActionGroup.this.refactorMenuShown(manager);
                    }
                });
                refactorSubmenu.add((IAction)this.fNoActionAvailable);
                menu.appendToGroup(this.fGroupName, (IContributionItem)refactorSubmenu);
            }
        } else if (this.fillRefactorMenu((IMenuManager)refactorSubmenu) > 0) {
            menu.appendToGroup(this.fGroupName, (IContributionItem)refactorSubmenu);
        }
    }

    private int fillRefactorMenu(IMenuManager refactorSubmenu) {
        int added = 0;
        refactorSubmenu.add((IContributionItem)new Separator(GROUP_REORG));
        added += this.addAction(refactorSubmenu, (IAction)this.fRenameAction);
        added += this.addAction(refactorSubmenu, (IAction)this.fMoveAction);
        added += this.addAction(refactorSubmenu, (IAction)this.fModifyParametersAction);
        added += this.addAction(refactorSubmenu, (IAction)this.fConvertAnonymousToNestedAction);
        added += this.addAction(refactorSubmenu, (IAction)this.fConvertNestedToTopAction);
        refactorSubmenu.add((IContributionItem)new Separator(GROUP_TYPE));
        added += this.addAction(refactorSubmenu, (IAction)this.fPullUpAction);
        added += this.addAction(refactorSubmenu, (IAction)this.fPushDownAction);
        added += this.addAction(refactorSubmenu, (IAction)this.fExtractInterfaceAction);
        added += this.addAction(refactorSubmenu, (IAction)this.fChangeTypeAction);
        added += this.addAction(refactorSubmenu, (IAction)this.fUseSupertypeAction);
        refactorSubmenu.add((IContributionItem)new Separator(GROUP_CODING));
        added += this.addAction(refactorSubmenu, (IAction)this.fInlineAction);
        added += this.addAction(refactorSubmenu, (IAction)this.fExtractMethodAction);
        added += this.addAction(refactorSubmenu, (IAction)this.fExtractTempAction);
        added += this.addAction(refactorSubmenu, (IAction)this.fExtractConstantAction);
        added += this.addAction(refactorSubmenu, (IAction)this.fIntroduceParameterAction);
        added += this.addAction(refactorSubmenu, (IAction)this.fIntroduceFactoryAction);
        added += this.addAction(refactorSubmenu, (IAction)this.fConvertLocalToFieldAction);
        return added += this.addAction(refactorSubmenu, (IAction)this.fSelfEncapsulateField);
    }

    private int addAction(IMenuManager menu, IAction action) {
        if (action != null && action.isEnabled()) {
            menu.add(action);
            return 1;
        }
        return 0;
    }

    private void refactorMenuShown(final IMenuManager refactorSubmenu) {
        Menu menu = ((MenuManager)refactorSubmenu).getMenu();
        menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuHidden(MenuEvent e) {
                RefactorActionGroup.this.refactorMenuHidden(refactorSubmenu);
            }
        });
        ITextSelection textSelection = (ITextSelection)this.fEditor.getSelectionProvider().getSelection();
        JavaTextSelection javaSelection = new JavaTextSelection(this.getEditorInput(), this.getDocument(), textSelection.getOffset(), textSelection.getLength());
        Iterator iter = this.fEditorActions.iterator();
        while (iter.hasNext()) {
            SelectionDispatchAction action = (SelectionDispatchAction)((Object)iter.next());
            action.update((ISelection)javaSelection);
        }
        refactorSubmenu.removeAll();
        if (this.fillRefactorMenu(refactorSubmenu) == 0) {
            refactorSubmenu.add((IAction)this.fNoActionAvailable);
        }
    }

    private void refactorMenuHidden(IMenuManager manager) {
        ITextSelection textSelection = (ITextSelection)this.fEditor.getSelectionProvider().getSelection();
        Iterator iter = this.fEditorActions.iterator();
        while (iter.hasNext()) {
            SelectionDispatchAction action = (SelectionDispatchAction)((Object)iter.next());
            action.update((ISelection)textSelection);
        }
    }

    private IJavaElement getEditorInput() {
        return JavaPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(this.fEditor.getEditorInput());
    }

    private IDocument getDocument() {
        return JavaPlugin.getDefault().getCompilationUnitDocumentProvider().getDocument(this.fEditor.getEditorInput());
    }

    private void fillQuickMenu(IMenuManager menu) {
        if (this.fEditor != null) {
            IJavaElement element = SelectionConverter.getInput(this.fEditor);
            if (element == null || !ActionUtil.isOnBuildPath(element)) {
                menu.add((IAction)this.fNoActionAvailable);
                return;
            }
            ITextSelection textSelection = (ITextSelection)this.fEditor.getSelectionProvider().getSelection();
            JavaTextSelection javaSelection = new JavaTextSelection(this.getEditorInput(), this.getDocument(), textSelection.getOffset(), textSelection.getLength());
            Iterator iter = this.fEditorActions.iterator();
            while (iter.hasNext()) {
                ((SelectionDispatchAction)((Object)iter.next())).update((ISelection)javaSelection);
            }
            this.fillRefactorMenu(menu);
            iter = this.fEditorActions.iterator();
            while (iter.hasNext()) {
                ((SelectionDispatchAction)((Object)iter.next())).update((ISelection)textSelection);
            }
        } else {
            this.fillRefactorMenu(menu);
        }
    }

    private class RefactorQuickAccessAction
    extends JDTQuickMenuAction {
        public RefactorQuickAccessAction(CompilationUnitEditor editor) {
            super(editor, RefactorActionGroup.QUICK_MENU_ID);
        }

        protected void fillMenu(IMenuManager menu) {
            RefactorActionGroup.this.fillQuickMenu(menu);
        }
    }

    private static class NoActionAvailable
    extends Action {
        public NoActionAvailable() {
            this.setEnabled(true);
            this.setText(RefactoringMessages.getString("RefactorActionGroup.no_refactoring_available"));
        }
    }
}

