/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards;

import java.io.File;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.preferences.NewJavaProjectPreferencePage;
import org.eclipse.jdt.internal.ui.preferences.PreferencePageSupport;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class JavaProjectWizardFirstPage
extends WizardPage {
    private NameGroup fNameGroup;
    private LocationGroup fLocationGroup;
    private LayoutGroup fLayoutGroup;
    private DetectGroup fDetectGroup;
    private Validator fValidator;
    private String fInitialName;
    private static final String PAGE_NAME = NewWizardMessages.getString("JavaProjectWizardFirstPage.page.pageName");

    public JavaProjectWizardFirstPage() {
        super(PAGE_NAME);
        this.setPageComplete(false);
        this.setTitle(NewWizardMessages.getString("JavaProjectWizardFirstPage.page.title"));
        this.setDescription(NewWizardMessages.getString("JavaProjectWizardFirstPage.page.description"));
        this.fInitialName = "";
    }

    public void setName(String name) {
        this.fInitialName = name;
        if (this.fNameGroup != null) {
            this.fNameGroup.setName(name);
        }
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayout((Layout)this.initGridLayout(new GridLayout(1, false), true));
        composite.setLayoutData((Object)new GridData(256));
        this.fNameGroup = new NameGroup(composite, this.fInitialName);
        this.fLocationGroup = new LocationGroup(composite);
        this.fLayoutGroup = new LayoutGroup(composite);
        this.fDetectGroup = new DetectGroup(composite);
        this.fNameGroup.addObserver(this.fLocationGroup);
        this.fDetectGroup.addObserver(this.fLayoutGroup);
        this.fLocationGroup.addObserver(this.fDetectGroup);
        this.fNameGroup.notifyObservers();
        this.fValidator = new Validator();
        this.fNameGroup.addObserver(this.fValidator);
        this.fLocationGroup.addObserver(this.fValidator);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
    }

    public IPath getLocationPath() {
        return this.fLocationGroup.getLocation();
    }

    public IProject getProjectHandle() {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(this.fNameGroup.getName());
    }

    public boolean isInWorkspace() {
        return this.fLocationGroup.isInWorkspace();
    }

    public String getProjectName() {
        return this.fNameGroup.getName();
    }

    public boolean getDetect() {
        return this.fDetectGroup.mustDetect();
    }

    public boolean isSrcBin() {
        return this.fLayoutGroup.isSrcBin();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.fNameGroup.postSetFocus();
        }
    }

    protected GridLayout initGridLayout(GridLayout layout, boolean margins) {
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        if (margins) {
            layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
            layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        } else {
            layout.marginWidth = 0;
            layout.marginHeight = 0;
        }
        return layout;
    }

    protected GridData setButtonLayoutData(Button button) {
        return super.setButtonLayoutData(button);
    }

    private final class NameGroup
    extends Observable
    implements IDialogFieldListener {
        protected final StringDialogField fNameField;

        public NameGroup(Composite composite, String initialName) {
            Composite nameComposite = new Composite(composite, 0);
            nameComposite.setFont(composite.getFont());
            nameComposite.setLayout((Layout)JavaProjectWizardFirstPage.this.initGridLayout(new GridLayout(2, false), false));
            nameComposite.setLayoutData((Object)new GridData(768));
            this.fNameField = new StringDialogField();
            this.fNameField.setLabelText(NewWizardMessages.getString("JavaProjectWizardFirstPage.NameGroup.label.text"));
            this.fNameField.setDialogFieldListener(this);
            this.setName(initialName);
            this.fNameField.doFillIntoGrid(nameComposite, 2);
            LayoutUtil.setHorizontalGrabbing((Control)this.fNameField.getTextControl(null));
        }

        protected void fireEvent() {
            this.setChanged();
            this.notifyObservers();
        }

        public String getName() {
            return this.fNameField.getText().trim();
        }

        public void postSetFocus() {
            this.fNameField.postSetFocusOnDialogField(JavaProjectWizardFirstPage.this.getShell().getDisplay());
        }

        public void setName(String name) {
            this.fNameField.setText(name);
        }

        public void dialogFieldChanged(DialogField field) {
            this.fireEvent();
        }
    }

    private final class LocationGroup
    extends Observable
    implements Observer,
    IStringButtonAdapter,
    IDialogFieldListener {
        protected final SelectionButtonDialogField fWorkspaceRadio;
        protected final SelectionButtonDialogField fExternalRadio;
        protected final StringButtonDialogField fLocation;
        private String fPreviousExternalLocation;
        private static final String DIALOGSTORE_LAST_EXTERNAL_LOC = "org.eclipse.jdt.ui.last.external.project";

        public LocationGroup(Composite composite) {
            Group group = new Group(composite, 0);
            group.setLayoutData((Object)new GridData(768));
            group.setLayout((Layout)JavaProjectWizardFirstPage.this.initGridLayout(new GridLayout(3, false), true));
            group.setText(NewWizardMessages.getString("JavaProjectWizardFirstPage.LocationGroup.title"));
            this.fWorkspaceRadio = new SelectionButtonDialogField(16);
            this.fWorkspaceRadio.setDialogFieldListener(this);
            this.fWorkspaceRadio.setLabelText(NewWizardMessages.getString("JavaProjectWizardFirstPage.LocationGroup.workspace.desc"));
            this.fExternalRadio = new SelectionButtonDialogField(16);
            this.fExternalRadio.setLabelText(NewWizardMessages.getString("JavaProjectWizardFirstPage.LocationGroup.external.desc"));
            this.fLocation = new StringButtonDialogField(this);
            this.fLocation.setDialogFieldListener(this);
            this.fLocation.setLabelText(NewWizardMessages.getString("JavaProjectWizardFirstPage.LocationGroup.locationLabel.desc"));
            this.fLocation.setButtonLabel(NewWizardMessages.getString("JavaProjectWizardFirstPage.LocationGroup.browseButton.desc"));
            this.fExternalRadio.attachDialogField(this.fLocation);
            this.fWorkspaceRadio.setSelection(true);
            this.fExternalRadio.setSelection(false);
            this.fPreviousExternalLocation = "";
            this.fWorkspaceRadio.doFillIntoGrid((Composite)group, 3);
            this.fExternalRadio.doFillIntoGrid((Composite)group, 3);
            this.fLocation.doFillIntoGrid((Composite)group, 3);
            LayoutUtil.setHorizontalGrabbing((Control)this.fLocation.getTextControl(null));
        }

        protected void fireEvent() {
            this.setChanged();
            this.notifyObservers();
        }

        protected String getDefaultPath(String name) {
            IPath path = Platform.getLocation().append(name);
            return path.toOSString();
        }

        public void update(Observable o, Object arg) {
            if (this.isInWorkspace()) {
                this.fLocation.setText(this.getDefaultPath(JavaProjectWizardFirstPage.this.fNameGroup.getName()));
            }
            this.fireEvent();
        }

        public IPath getLocation() {
            if (this.isInWorkspace()) {
                return Platform.getLocation();
            }
            return new Path(this.fLocation.getText().trim());
        }

        public boolean isInWorkspace() {
            return this.fWorkspaceRadio.isSelected();
        }

        public void changeControlPressed(DialogField field) {
            String selectedDirectory;
            File path;
            String prevLocation;
            DirectoryDialog dialog = new DirectoryDialog(JavaProjectWizardFirstPage.this.getShell());
            dialog.setMessage(NewWizardMessages.getString("JavaProjectWizardFirstPage.directory.message"));
            String directoryName = this.fLocation.getText().trim();
            if (directoryName.length() == 0 && (prevLocation = JavaPlugin.getDefault().getDialogSettings().get(DIALOGSTORE_LAST_EXTERNAL_LOC)) != null) {
                directoryName = prevLocation;
            }
            if (directoryName.length() > 0 && (path = new File(directoryName)).exists()) {
                dialog.setFilterPath(new Path(directoryName).toOSString());
            }
            if ((selectedDirectory = dialog.open()) != null) {
                this.fLocation.setText(selectedDirectory);
                JavaPlugin.getDefault().getDialogSettings().put(DIALOGSTORE_LAST_EXTERNAL_LOC, selectedDirectory);
            }
        }

        public void dialogFieldChanged(DialogField field) {
            if (field == this.fWorkspaceRadio) {
                boolean checked = this.fWorkspaceRadio.isSelected();
                if (checked) {
                    this.fPreviousExternalLocation = this.fLocation.getText();
                    this.fLocation.setText(this.getDefaultPath(JavaProjectWizardFirstPage.this.fNameGroup.getName()));
                } else {
                    this.fLocation.setText(this.fPreviousExternalLocation);
                }
            }
            this.fireEvent();
        }
    }

    private final class LayoutGroup
    implements Observer,
    IDialogFieldListener {
        protected final SelectionButtonDialogField fStdRadio;
        protected final SelectionButtonDialogField fSrcBinRadio;
        protected final SelectionButtonDialogField fConfigureButton;
        protected final Group fGroup;

        public LayoutGroup(Composite composite) {
            this.fGroup = new Group(composite, 0);
            this.fGroup.setLayoutData((Object)new GridData(768));
            this.fGroup.setLayout((Layout)JavaProjectWizardFirstPage.this.initGridLayout(new GridLayout(), true));
            this.fGroup.setText(NewWizardMessages.getString("JavaProjectWizardFirstPage.LayoutGroup.title"));
            this.fStdRadio = new SelectionButtonDialogField(16);
            this.fStdRadio.setLabelText(NewWizardMessages.getString("JavaProjectWizardFirstPage.LayoutGroup.option.oneFolder"));
            this.fSrcBinRadio = new SelectionButtonDialogField(16);
            this.fSrcBinRadio.setLabelText(NewWizardMessages.getString("JavaProjectWizardFirstPage.LayoutGroup.option.separateFolders"));
            this.fStdRadio.doFillIntoGrid((Composite)this.fGroup, 1);
            this.fSrcBinRadio.doFillIntoGrid((Composite)this.fGroup, 1);
            this.fConfigureButton = new SelectionButtonDialogField(8);
            this.fConfigureButton.setLabelText(NewWizardMessages.getString("JavaProjectWizardFirstPage.LayoutGroup.configure"));
            this.fConfigureButton.setDialogFieldListener(this);
            this.fConfigureButton.doFillIntoGrid(composite, 1);
            this.fConfigureButton.getSelectionButton(null).setLayoutData((Object)new GridData(128));
            boolean useSrcBin = PreferenceConstants.getPreferenceStore().getBoolean("org.eclipse.jdt.ui.wizards.srcBinFoldersInNewProjects");
            this.fSrcBinRadio.setSelection(useSrcBin);
            this.fStdRadio.setSelection(!useSrcBin);
        }

        public void update(Observable o, Object arg) {
            boolean detect = JavaProjectWizardFirstPage.this.fDetectGroup.mustDetect();
            this.fStdRadio.setEnabled(!detect);
            this.fSrcBinRadio.setEnabled(!detect);
            this.fGroup.setEnabled(!detect);
        }

        public boolean isSrcBin() {
            return this.fSrcBinRadio.isSelected();
        }

        public void dialogFieldChanged(DialogField field) {
            if (field == this.fConfigureButton) {
                PreferencePageSupport.showPreferencePage(JavaProjectWizardFirstPage.this.getShell(), "org.eclipse.jdt.ui.preferences.NewJavaProjectPreferencePage", (IPreferencePage)new NewJavaProjectPreferencePage());
            }
        }
    }

    private final class DetectGroup
    extends Observable
    implements Observer {
        private final Text fText;
        private boolean fDetect;

        public DetectGroup(Composite composite) {
            this.fText = new Text(composite, 74);
            GridData gd = new GridData(784);
            gd.widthHint = 0;
            gd.heightHint = JavaProjectWizardFirstPage.this.convertHeightInCharsToPixels(6);
            this.fText.setLayoutData((Object)gd);
            this.fText.setFont(composite.getFont());
            this.fText.setText(NewWizardMessages.getString("JavaProjectWizardFirstPage.DetectGroup.message"));
            this.fText.setVisible(false);
        }

        public void update(Observable o, Object arg) {
            if (JavaProjectWizardFirstPage.this.fLocationGroup.isInWorkspace()) {
                String name = JavaProjectWizardFirstPage.this.getProjectName();
                if (name.length() == 0 || JavaPlugin.getWorkspace().getRoot().findMember(name) != null) {
                    this.fDetect = false;
                } else {
                    File directory = JavaProjectWizardFirstPage.this.fLocationGroup.getLocation().append(JavaProjectWizardFirstPage.this.getProjectName()).toFile();
                    this.fDetect = directory.isDirectory();
                }
            } else {
                File directory = JavaProjectWizardFirstPage.this.fLocationGroup.getLocation().toFile();
                this.fDetect = directory.isDirectory();
            }
            this.fText.setVisible(this.fDetect);
            this.setChanged();
            this.notifyObservers();
        }

        public boolean mustDetect() {
            return this.fDetect;
        }
    }

    private final class Validator
    implements Observer {
        Validator() {
        }

        public void update(Observable o, Object arg) {
            IStatus locationStatus;
            IWorkspace workspace = JavaPlugin.getWorkspace();
            String name = JavaProjectWizardFirstPage.this.fNameGroup.getName();
            if (name.length() == 0) {
                JavaProjectWizardFirstPage.this.setErrorMessage(null);
                JavaProjectWizardFirstPage.this.setMessage(NewWizardMessages.getString("JavaProjectWizardFirstPage.Message.enterProjectName"));
                JavaProjectWizardFirstPage.this.setPageComplete(false);
                return;
            }
            IStatus nameStatus = workspace.validateName(name, 4);
            if (!nameStatus.isOK()) {
                JavaProjectWizardFirstPage.this.setErrorMessage(nameStatus.getMessage());
                JavaProjectWizardFirstPage.this.setPageComplete(false);
                return;
            }
            IProject handle = JavaProjectWizardFirstPage.this.getProjectHandle();
            if (handle.exists()) {
                JavaProjectWizardFirstPage.this.setErrorMessage(NewWizardMessages.getString("JavaProjectWizardFirstPage.Message.projectAlreadyExists"));
                JavaProjectWizardFirstPage.this.setPageComplete(false);
                return;
            }
            String location = JavaProjectWizardFirstPage.this.fLocationGroup.getLocation().toOSString();
            if (location.length() == 0) {
                JavaProjectWizardFirstPage.this.setErrorMessage(null);
                JavaProjectWizardFirstPage.this.setMessage(NewWizardMessages.getString("JavaProjectWizardFirstPage.Message.enterLocation"));
                JavaProjectWizardFirstPage.this.setPageComplete(false);
                return;
            }
            if (!Path.EMPTY.isValidPath(location)) {
                JavaProjectWizardFirstPage.this.setErrorMessage(NewWizardMessages.getString("JavaProjectWizardFirstPage.Message.invalidDirectory"));
                JavaProjectWizardFirstPage.this.setPageComplete(false);
                return;
            }
            Path projectPath = new Path(location);
            if (!JavaProjectWizardFirstPage.this.fLocationGroup.isInWorkspace() && Platform.getLocation().isPrefixOf((IPath)projectPath)) {
                JavaProjectWizardFirstPage.this.setErrorMessage(NewWizardMessages.getString("JavaProjectWizardFirstPage.Message.cannotCreateInWorkspace"));
                JavaProjectWizardFirstPage.this.setPageComplete(false);
                return;
            }
            if (!JavaProjectWizardFirstPage.this.fLocationGroup.isInWorkspace() && !(locationStatus = workspace.validateProjectLocation(handle, (IPath)projectPath)).isOK()) {
                JavaProjectWizardFirstPage.this.setErrorMessage(locationStatus.getMessage());
                JavaProjectWizardFirstPage.this.setPageComplete(false);
                return;
            }
            JavaProjectWizardFirstPage.this.setPageComplete(true);
            JavaProjectWizardFirstPage.this.setErrorMessage(null);
            JavaProjectWizardFirstPage.this.setMessage(null);
        }
    }
}

