/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.packageview;

import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.actions.MultiActionGroup;
import org.eclipse.jdt.internal.ui.packageview.LayoutAction;
import org.eclipse.jdt.internal.ui.packageview.PackageExplorerPart;
import org.eclipse.jdt.internal.ui.packageview.PackagesMessages;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.IActionBars;

class LayoutActionGroup
extends MultiActionGroup {
    LayoutActionGroup(PackageExplorerPart packageExplorer) {
        super(LayoutActionGroup.createActions(packageExplorer), LayoutActionGroup.getSelectedState(packageExplorer));
    }

    public void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
        this.contributeToViewMenu(actionBars.getMenuManager());
    }

    private void contributeToViewMenu(IMenuManager viewMenu) {
        viewMenu.add((IContributionItem)new Separator());
        MenuManager layoutSubMenu = new MenuManager(PackagesMessages.getString("LayoutActionGroup.label"));
        Separator marker = new Separator("layout");
        viewMenu.add((IContributionItem)new Separator("additions"));
        viewMenu.add((IContributionItem)marker);
        viewMenu.appendToGroup("layout", (IContributionItem)layoutSubMenu);
        viewMenu.add((IContributionItem)new Separator("additions-end"));
        this.addActions((IMenuManager)layoutSubMenu);
    }

    static int getSelectedState(PackageExplorerPart packageExplorer) {
        if (packageExplorer.isFlatLayout()) {
            return 0;
        }
        return 1;
    }

    static IAction[] createActions(PackageExplorerPart packageExplorer) {
        LayoutAction flatLayoutAction = new LayoutAction(packageExplorer, true);
        flatLayoutAction.setText(PackagesMessages.getString("LayoutActionGroup.flatLayoutAction.label"));
        JavaPluginImages.setLocalImageDescriptors(flatLayoutAction, "flatLayout.gif");
        LayoutAction hierarchicalLayout = new LayoutAction(packageExplorer, false);
        hierarchicalLayout.setText(PackagesMessages.getString("LayoutActionGroup.hierarchicalLayoutAction.label"));
        JavaPluginImages.setLocalImageDescriptors(hierarchicalLayout, "hierarchicalLayout.gif");
        return new IAction[]{flatLayoutAction, hierarchicalLayout};
    }
}

