/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.callhierarchy;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.ui.callhierarchy.CallHierarchyMessages;
import org.eclipse.jdt.internal.ui.callhierarchy.SearchScopeAction;
import org.eclipse.jdt.internal.ui.callhierarchy.SearchScopeActionGroup;
import org.eclipse.jdt.internal.ui.search.SearchMessages;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.help.WorkbenchHelp;

class SearchScopeProjectAction
extends SearchScopeAction {
    private final SearchScopeActionGroup fGroup;

    public SearchScopeProjectAction(SearchScopeActionGroup group) {
        super(group, CallHierarchyMessages.getString("SearchScopeActionGroup.project.text"));
        this.fGroup = group;
        this.setToolTipText(CallHierarchyMessages.getString("SearchScopeActionGroup.project.tooltip"));
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.jdt.ui.call_hierarchy_search_scope_action_context");
    }

    public IJavaSearchScope getSearchScope() {
        IMethod method = this.fGroup.getView().getMethod();
        IJavaProject project = null;
        if (method != null) {
            project = method.getJavaProject();
        }
        if (project != null) {
            return SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{project}, (boolean)false);
        }
        return null;
    }

    public int getSearchScopeType() {
        return 2;
    }

    public String getFullDescription() {
        IMethod method = this.fGroup.getView().getMethod();
        IJavaProject project = null;
        if (method != null) {
            project = method.getJavaProject();
        }
        return SearchMessages.getFormattedString("ProjectScope", project.getElementName());
    }
}

