/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.structure;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringSearchEngine;
import org.eclipse.jdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.jdt.internal.corext.refactoring.rename.RefactoringScopeFactory;
import org.eclipse.jdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

class ConstructorReferenceFinder {
    private final IType fType;
    private final IMethod[] fConstructors;

    private ConstructorReferenceFinder(IType type) throws JavaModelException {
        this.fConstructors = JavaElementUtil.getAllConstructors(type);
        this.fType = type;
    }

    private ConstructorReferenceFinder(IMethod constructor) {
        this.fConstructors = new IMethod[]{constructor};
        this.fType = constructor.getDeclaringType();
    }

    public static SearchResultGroup[] getConstructorReferences(IType type, IProgressMonitor pm, RefactoringStatus status) throws JavaModelException {
        return new ConstructorReferenceFinder(type).getConstructorReferences(pm, 2, status);
    }

    public static SearchResultGroup[] getConstructorOccurrences(IMethod constructor, IProgressMonitor pm, RefactoringStatus status) throws JavaModelException {
        Assert.isTrue(constructor.isConstructor());
        return new ConstructorReferenceFinder(constructor).getConstructorReferences(pm, 3, status);
    }

    private SearchResultGroup[] getConstructorReferences(IProgressMonitor pm, int limitTo, RefactoringStatus status) throws JavaModelException {
        IJavaSearchScope scope = this.createSearchScope();
        SearchPattern pattern = RefactoringSearchEngine.createOrPattern((IJavaElement[])this.fConstructors, limitTo);
        if (pattern == null) {
            if (this.fConstructors.length != 0) {
                return new SearchResultGroup[0];
            }
            return this.getImplicitConstructorReferences(pm, status);
        }
        return this.removeUnrealReferences(RefactoringSearchEngine.search(pattern, scope, pm, status));
    }

    private SearchResultGroup[] removeUnrealReferences(SearchResultGroup[] groups) {
        ArrayList<SearchResultGroup> result = new ArrayList<SearchResultGroup>(groups.length);
        int i = 0;
        while (i < groups.length) {
            SearchResultGroup group = groups[i];
            ICompilationUnit cu = group.getCompilationUnit();
            if (cu != null) {
                CompilationUnit cuNode = new RefactoringASTParser(2).parse(cu, false);
                SearchMatch[] allSearchResults = group.getSearchResults();
                ArrayList<SearchMatch> realConstructorReferences = new ArrayList<SearchMatch>(Arrays.asList(allSearchResults));
                int j = 0;
                while (j < allSearchResults.length) {
                    SearchMatch searchResult = allSearchResults[j];
                    if (!this.isRealConstructorReferenceNode(ASTNodeSearchUtil.getAstNode(searchResult, cuNode))) {
                        realConstructorReferences.remove(searchResult);
                    }
                    ++j;
                }
                if (!realConstructorReferences.isEmpty()) {
                    result.add(new SearchResultGroup(group.getResource(), realConstructorReferences.toArray(new SearchMatch[realConstructorReferences.size()])));
                }
            }
            ++i;
        }
        return result.toArray(new SearchResultGroup[result.size()]);
    }

    private boolean isRealConstructorReferenceNode(ASTNode node) {
        MethodDeclaration md;
        String typeName = this.fConstructors[0].getDeclaringType().getElementName();
        if (node.getParent() instanceof TypeDeclaration) {
            return false;
        }
        return !(node.getParent() instanceof MethodDeclaration) || !(md = (MethodDeclaration)node.getParent()).isConstructor() || md.getName().getIdentifier().equals(typeName);
    }

    private IJavaSearchScope createSearchScope() throws JavaModelException {
        if (this.fConstructors.length == 0) {
            return RefactoringScopeFactory.create((IJavaElement)this.fType);
        }
        return RefactoringScopeFactory.create((IJavaElement)this.getMostVisibleConstructor());
    }

    private IMethod getMostVisibleConstructor() throws JavaModelException {
        Assert.isTrue(this.fConstructors.length > 0);
        IMethod candidate = this.fConstructors[0];
        int visibility = JdtFlags.getVisibilityCode((IMember)this.fConstructors[0]);
        int i = 1;
        while (i < this.fConstructors.length) {
            IMethod constructor = this.fConstructors[i];
            if (JdtFlags.isHigherVisibility(JdtFlags.getVisibilityCode((IMember)constructor), visibility)) {
                candidate = constructor;
            }
            ++i;
        }
        return candidate;
    }

    private SearchResultGroup[] getImplicitConstructorReferences(IProgressMonitor pm, RefactoringStatus status) throws JavaModelException {
        pm.beginTask("", 2);
        ArrayList searchMatches = new ArrayList();
        searchMatches.addAll(this.getImplicitConstructorReferencesFromHierarchy((IProgressMonitor)new SubProgressMonitor(pm, 1)));
        searchMatches.addAll(this.getImplicitConstructorReferencesInClassCreations((IProgressMonitor)new SubProgressMonitor(pm, 1), status));
        pm.done();
        return RefactoringSearchEngine.groupByCu(searchMatches.toArray(new SearchMatch[searchMatches.size()]), status);
    }

    private List getImplicitConstructorReferencesInClassCreations(IProgressMonitor pm, RefactoringStatus status) throws JavaModelException {
        SearchPattern pattern = SearchPattern.createPattern((IJavaElement)this.fType, (int)2);
        IJavaSearchScope scope = RefactoringScopeFactory.create((IJavaElement)this.fType);
        SearchResultGroup[] refs = RefactoringSearchEngine.search(pattern, scope, pm, status);
        ArrayList<SearchMatch> result = new ArrayList<SearchMatch>();
        int i = 0;
        while (i < refs.length) {
            SearchResultGroup group = refs[i];
            ICompilationUnit cu = group.getCompilationUnit();
            if (cu != null) {
                CompilationUnit cuNode = new RefactoringASTParser(2).parse(cu, false);
                SearchMatch[] results = group.getSearchResults();
                int j = 0;
                while (j < results.length) {
                    SearchMatch searchResult = results[j];
                    ASTNode node = ASTNodeSearchUtil.getAstNode(searchResult, cuNode);
                    if (ConstructorReferenceFinder.isImplicitConstructorReferenceNodeInClassCreations(node)) {
                        result.add(searchResult);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return result;
    }

    public static boolean isImplicitConstructorReferenceNodeInClassCreations(ASTNode node) {
        if (node instanceof Name && node.getParent() instanceof ClassInstanceCreation) {
            ClassInstanceCreation cic = (ClassInstanceCreation)node.getParent();
            return node.equals((Object)cic.getName());
        }
        return false;
    }

    private List getImplicitConstructorReferencesFromHierarchy(IProgressMonitor pm) throws JavaModelException {
        IType[] subTypes = ConstructorReferenceFinder.getNonBinarySubtypes(this.fType, pm);
        ArrayList result = new ArrayList(subTypes.length);
        int i = 0;
        while (i < subTypes.length) {
            result.addAll(ConstructorReferenceFinder.getAllSuperConstructorInvocations(subTypes[i]));
            ++i;
        }
        return result;
    }

    private static IType[] getNonBinarySubtypes(IType type, IProgressMonitor pm) throws JavaModelException {
        ITypeHierarchy hierarchy = type.newTypeHierarchy(pm);
        IType[] subTypes = hierarchy.getAllSubtypes(type);
        ArrayList<IType> result = new ArrayList<IType>(subTypes.length);
        int i = 0;
        while (i < subTypes.length) {
            if (!subTypes[i].isBinary()) {
                result.add(subTypes[i]);
            }
            ++i;
        }
        return result.toArray(new IType[result.size()]);
    }

    private static Collection getAllSuperConstructorInvocations(IType type) throws JavaModelException {
        IMethod[] constructors = JavaElementUtil.getAllConstructors(type);
        CompilationUnit cuNode = new RefactoringASTParser(2).parse(type.getCompilationUnit(), false);
        ArrayList<SearchMatch> result = new ArrayList<SearchMatch>(constructors.length);
        int i = 0;
        while (i < constructors.length) {
            SuperConstructorInvocation superCall = ConstructorReferenceFinder.getSuperConstructorCallNode(constructors[i], cuNode);
            if (superCall != null) {
                result.add(ConstructorReferenceFinder.createSearchResult((ASTNode)superCall, constructors[i]));
            }
            ++i;
        }
        return result;
    }

    private static SearchMatch createSearchResult(ASTNode superCall, IMethod constructor) {
        int start = superCall.getStartPosition();
        int end = ASTNodes.getInclusiveEnd(superCall);
        IResource resource = constructor.getResource();
        return new SearchMatch((IJavaElement)constructor, 0, start, end - start, SearchEngine.getDefaultSearchParticipant(), resource);
    }

    private static SuperConstructorInvocation getSuperConstructorCallNode(IMethod constructor, CompilationUnit cuNode) throws JavaModelException {
        Assert.isTrue(constructor.isConstructor());
        MethodDeclaration constructorNode = ASTNodeSearchUtil.getMethodDeclarationNode(constructor, cuNode);
        Assert.isTrue(constructorNode.isConstructor());
        Block body = constructorNode.getBody();
        Assert.isNotNull(body);
        List statements = body.statements();
        if (!statements.isEmpty() && statements.get(0) instanceof SuperConstructorInvocation) {
            return (SuperConstructorInvocation)statements.get(0);
        }
        return null;
    }
}

