/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.reorg;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.codemanipulation.GetterSetterUtil;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.participants.JavaProcessors;
import org.eclipse.jdt.internal.corext.refactoring.participants.ResourceModifications;
import org.eclipse.jdt.internal.corext.refactoring.participants.ResourceProcessors;
import org.eclipse.jdt.internal.corext.refactoring.reorg.DeleteChangeCreator;
import org.eclipse.jdt.internal.corext.refactoring.reorg.IConfirmQuery;
import org.eclipse.jdt.internal.corext.refactoring.reorg.IReorgQueries;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ParentChecker;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReadOnlyResourceFinder;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReorgUtils;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringFileBuffers;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.jdt.internal.corext.util.Resources;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.DeleteArguments;
import org.eclipse.ltk.core.refactoring.participants.DeleteProcessor;
import org.eclipse.ltk.core.refactoring.participants.ParticipantManager;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.ltk.core.refactoring.participants.ValidateEditChecker;

public class JavaDeleteProcessor
extends DeleteProcessor {
    private boolean fWasCanceled;
    private boolean fSuggestGetterSetterDeletion;
    private Object[] fElements;
    private IResource[] fResources;
    private IJavaElement[] fJavaElements;
    private IReorgQueries fDeleteQueries;
    private Change fDeleteChange;
    public static final String IDENTIFIER = "org.eclipse.jdt.ui.DeleteProcessor";
    static /* synthetic */ Class class$0;

    public JavaDeleteProcessor(Object[] elements) {
        this.fElements = elements;
        this.fResources = JavaDeleteProcessor.getResources(elements);
        this.fJavaElements = JavaDeleteProcessor.getJavaElements(elements);
        this.fSuggestGetterSetterDeletion = true;
        this.fWasCanceled = false;
    }

    public String getIdentifier() {
        return IDENTIFIER;
    }

    public boolean isApplicable() throws CoreException {
        if (this.fElements.length == 0) {
            return false;
        }
        if (this.fElements.length != this.fResources.length + this.fJavaElements.length) {
            return false;
        }
        int i = 0;
        while (i < this.fResources.length) {
            if (!this.canDelete(this.fResources[i])) {
                return false;
            }
            ++i;
        }
        i = 0;
        while (i < this.fJavaElements.length) {
            if (!this.canDelete(this.fJavaElements[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean needsProgressMonitor() {
        if (this.fResources != null && this.fResources.length > 0) {
            return true;
        }
        if (this.fJavaElements != null) {
            int i = 0;
            while (i < this.fJavaElements.length) {
                int type = this.fJavaElements[i].getElementType();
                if (type <= 6) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private boolean canDelete(IResource resource) {
        if (!resource.exists() || resource.isPhantom()) {
            return false;
        }
        return resource.getType() != 8 && resource.getType() != 4;
    }

    private boolean canDelete(IJavaElement element) throws CoreException {
        IPackageFragmentRoot root;
        if (!element.exists()) {
            return false;
        }
        if (element instanceof IJavaModel || element instanceof IJavaProject) {
            return false;
        }
        if (element.getParent() != null && element.getParent().isReadOnly()) {
            return false;
        }
        if (element instanceof IPackageFragmentRoot && ((root = (IPackageFragmentRoot)element).isExternal() || Checks.isClasspathDelete(root))) {
            return false;
        }
        if (element instanceof IPackageFragment && JavaDeleteProcessor.isEmptySuperPackage((IPackageFragment)element)) {
            return false;
        }
        if (JavaDeleteProcessor.isFromExternalArchive(element)) {
            return false;
        }
        if (element instanceof IMember && ((IMember)element).isBinary()) {
            return false;
        }
        return !ReorgUtils.isDeletedFromEditor(element);
    }

    private static boolean isFromExternalArchive(IJavaElement element) {
        return element.getResource() == null && !JavaDeleteProcessor.isWorkingCopyElement(element);
    }

    private static boolean isWorkingCopyElement(IJavaElement element) {
        if (element instanceof ICompilationUnit) {
            return ((ICompilationUnit)element).isWorkingCopy();
        }
        if (ReorgUtils.isInsideCompilationUnit(element)) {
            return ReorgUtils.getCompilationUnit(element).isWorkingCopy();
        }
        return false;
    }

    private static boolean isEmptySuperPackage(IPackageFragment pack) throws JavaModelException {
        return pack.hasSubpackages() && pack.getNonJavaResources().length == 0 && pack.getChildren().length == 0;
    }

    public String getProcessorName() {
        return RefactoringCoreMessages.getString("DeleteRefactoring.7");
    }

    public Object[] getElements() {
        return this.fElements;
    }

    public RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants shared) throws CoreException {
        String[] natures = this.getAffectedProjectNatures();
        ResourceModifications mod = new ResourceModifications();
        ArrayList collected = new ArrayList();
        int i = 0;
        while (i < this.fJavaElements.length) {
            this.handleJavaElementDelete(collected, this.fJavaElements[i], natures, mod, shared);
            ++i;
        }
        i = 0;
        while (i < this.fResources.length) {
            this.handleResourceDelete(collected, this.fResources[i], natures, shared);
            ++i;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        Iterator iter = collected.iterator();
        while (iter.hasNext()) {
            result.addAll(Arrays.asList(ParticipantManager.loadDeleteParticipants((RefactoringStatus)status, (RefactoringProcessor)this, iter.next(), (DeleteArguments)new DeleteArguments(), (String[])natures, (SharableParticipants)shared)));
        }
        result.addAll(Arrays.asList(mod.getParticipants(status, (RefactoringProcessor)this, natures, shared)));
        return result.toArray(new RefactoringParticipant[result.size()]);
    }

    private void handleJavaElementDelete(List collected, IJavaElement element, String[] natures, ResourceModifications mod, SharableParticipants shared) throws CoreException {
        switch (element.getElementType()) {
            case 1: {
                return;
            }
            case 2: {
                collected.add(element);
                if (element.getResource() != null) {
                    mod.addDelete(element.getResource());
                }
                return;
            }
            case 3: {
                collected.add(element);
                IPackageFragmentRoot root = (IPackageFragmentRoot)element;
                if (!root.isArchive() && element.getResource() != null) {
                    mod.addDelete(element.getResource());
                }
                return;
            }
            case 4: {
                this.handlePackageFragmentDelete(collected, (IPackageFragment)element, natures, mod, shared);
                return;
            }
            case 5: {
                collected.add(element);
                IType[] types = ((ICompilationUnit)element).getTypes();
                collected.addAll(Arrays.asList(types));
                if (element.getResource() != null) {
                    mod.addDelete(element.getResource());
                }
                return;
            }
            case 7: {
                collected.add(element);
                IType type = (IType)element;
                ICompilationUnit unit = type.getCompilationUnit();
                if (type.getDeclaringType() == null && unit.getElementName().endsWith(type.getElementName()) && unit.getTypes().length == 1) {
                    collected.add(unit);
                    if (unit.getResource() != null) {
                        mod.addDelete(unit.getResource());
                    }
                }
                return;
            }
        }
        collected.add(element);
    }

    private void handlePackageFragmentDelete(List collected, IPackageFragment pack, String[] natures, ResourceModifications mod, SharableParticipants shared) throws CoreException {
        collected.add(pack);
        IContainer container = (IContainer)pack.getResource();
        if (container == null) {
            return;
        }
        IResource[] members = container.members();
        int files = 0;
        int m = 0;
        while (m < members.length) {
            IResource member = members[m];
            if (member instanceof IFile) {
                ++files;
                IFile file = (IFile)member;
                if (!"class".equals(file.getFileExtension()) || !file.isDerived()) {
                    mod.addDelete(member);
                }
            }
            ++m;
        }
        if (files == members.length) {
            mod.addDelete((IResource)container);
        }
    }

    private void handleResourceDelete(List collected, IResource element, String[] natures, SharableParticipants shared) throws CoreException {
        collected.add(element);
    }

    private String[] getAffectedProjectNatures() throws CoreException {
        String[] jNatures = JavaProcessors.computeAffectedNaturs(this.fJavaElements);
        String[] rNatures = ResourceProcessors.computeAffectedNatures(this.fResources);
        HashSet<String> result = new HashSet<String>();
        result.addAll(Arrays.asList(jNatures));
        result.addAll(Arrays.asList(rNatures));
        return result.toArray(new String[result.size()]);
    }

    private static IResource[] getResources(Object[] elements) {
        ArrayList<Object> result = new ArrayList<Object>();
        int i = 0;
        while (i < elements.length) {
            if (elements[i] instanceof IResource) {
                result.add(elements[i]);
            }
            ++i;
        }
        return result.toArray(new IResource[result.size()]);
    }

    private static IJavaElement[] getJavaElements(Object[] elements) {
        ArrayList<Object> result = new ArrayList<Object>();
        int i = 0;
        while (i < elements.length) {
            if (elements[i] instanceof IJavaElement) {
                result.add(elements[i]);
            }
            ++i;
        }
        return result.toArray(new IJavaElement[result.size()]);
    }

    public void setSuggestGetterSetterDeletion(boolean suggest) {
        this.fSuggestGetterSetterDeletion = suggest;
    }

    public void setQueries(IReorgQueries queries) {
        Assert.isNotNull(queries);
        this.fDeleteQueries = queries;
    }

    public IJavaElement[] getJavaElementsToDelete() {
        return this.fJavaElements;
    }

    public boolean wasCanceled() {
        return this.fWasCanceled;
    }

    public IResource[] getResourcesToDelete() {
        return this.fResources;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        Assert.isNotNull(this.fDeleteQueries);
        RefactoringStatus result = new RefactoringStatus();
        result.merge(RefactoringStatus.create((IStatus)Resources.checkInSync(ReorgUtils.getNotLinked(this.fResources))));
        IResource[] javaResources = ReorgUtils.getResources(this.fJavaElements);
        result.merge(RefactoringStatus.create((IStatus)Resources.checkInSync(ReorgUtils.getNotNulls(javaResources))));
        int i = 0;
        while (i < this.fJavaElements.length) {
            IJavaElement element = this.fJavaElements[i];
            if (element instanceof IType) {
                ((IType)element).isAnonymous();
            }
            ++i;
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException {
        RefactoringStatus refactoringStatus;
        pm.beginTask(RefactoringCoreMessages.getString("DeleteRefactoring.1"), 1);
        try {
            try {
                this.fWasCanceled = false;
                RefactoringStatus result = new RefactoringStatus();
                this.recalculateElementsToDelete();
                TextChangeManager manager = new TextChangeManager();
                this.fDeleteChange = DeleteChangeCreator.createDeleteChange(manager, this.fResources, this.fJavaElements, this.getProcessorName());
                this.checkDirtyCompilationUnits(result);
                Class<?> clazz = class$0;
                if (clazz == null) {
                    Class<?> clazz2;
                    try {
                        clazz2 = Class.forName("org.eclipse.ltk.core.refactoring.participants.ValidateEditChecker");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    clazz = class$0 = clazz2;
                }
                ValidateEditChecker checker = (ValidateEditChecker)context.getChecker((Class)clazz);
                IFile[] classPathFiles = this.getClassPathFiles();
                checker.addFiles(ResourceUtil.getFiles(manager.getAllCompilationUnits()));
                checker.addFiles(classPathFiles);
                refactoringStatus = result;
                Object var7_11 = null;
            }
            catch (OperationCanceledException e) {
                this.fWasCanceled = true;
                throw e;
            }
            catch (JavaModelException e) {
                throw e;
            }
            catch (CoreException e) {
                throw new JavaModelException(e);
            }
        }
        catch (Throwable throwable) {
            Object var7_12 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return refactoringStatus;
    }

    private void checkDirtyCompilationUnits(RefactoringStatus result) throws CoreException {
        if (this.fJavaElements == null || this.fJavaElements.length == 0) {
            return;
        }
        int je = 0;
        while (je < this.fJavaElements.length) {
            IJavaElement element = this.fJavaElements[je];
            if (element instanceof ICompilationUnit) {
                this.checkDirtyCompilationUnit(result, (ICompilationUnit)element);
            } else if (element instanceof IPackageFragment) {
                ICompilationUnit[] units = ((IPackageFragment)element).getCompilationUnits();
                int u = 0;
                while (u < units.length) {
                    this.checkDirtyCompilationUnit(result, units[u]);
                    ++u;
                }
            }
            ++je;
        }
    }

    private void checkDirtyCompilationUnit(RefactoringStatus result, ICompilationUnit cunit) {
        IResource resource = cunit.getResource();
        ITextFileBuffer buffer = RefactoringFileBuffers.getTextFileBuffer(cunit);
        if (buffer != null && buffer.isDirty() && resource != null && resource.exists()) {
            if (buffer.isStateValidated() && buffer.isSynchronized()) {
                result.addWarning(RefactoringCoreMessages.getFormattedString("JavaDeleteProcessor.unsaved_changes", resource.getFullPath().toString()));
            } else {
                result.addFatalError(RefactoringCoreMessages.getFormattedString("JavaDeleteProcessor.unsaved_changes", resource.getFullPath().toString()));
            }
        }
    }

    private void recalculateElementsToDelete() throws CoreException {
        this.fJavaElements = ReorgUtils.toWorkingCopies(this.fJavaElements);
        this.removeElementsWithParentsInSelection();
        this.removeUnconfirmedFoldersThatContainSourceFolders();
        this.removeUnconfirmedReferencedArchives();
        this.addEmptyCusToDelete();
        this.removeJavaElementsChildrenOfJavaElements();
        this.confirmDeletingReadOnly();
        if (this.fSuggestGetterSetterDeletion) {
            this.addGettersSetters();
        }
    }

    private void removeUnconfirmedReferencedArchives() throws JavaModelException {
        String queryTitle = RefactoringCoreMessages.getString("DeleteRefactoring.2");
        IConfirmQuery query = this.fDeleteQueries.createYesYesToAllNoNoToAllQuery(queryTitle, true, 3);
        this.removeUnconfirmedReferencedPackageFragmentRoots(query);
        this.removeUnconfirmedReferencedArchiveFiles(query);
    }

    private void removeUnconfirmedReferencedArchiveFiles(IConfirmQuery query) throws JavaModelException, OperationCanceledException {
        ArrayList<IResource> filesToSkip = new ArrayList<IResource>(0);
        int i = 0;
        while (i < this.fResources.length) {
            IPackageFragmentRoot root;
            IJavaProject project;
            IResource resource = this.fResources[i];
            if (resource instanceof IFile && (project = JavaCore.create((IProject)resource.getProject())) != null && project.exists() && (root = project.findPackageFragmentRoot(resource.getFullPath())) != null) {
                ArrayList<IJavaProject> referencingProjects = new ArrayList<IJavaProject>(1);
                referencingProjects.add(root.getJavaProject());
                referencingProjects.addAll(Arrays.asList(JavaElementUtil.getReferencingProjects(root)));
                if (JavaDeleteProcessor.skipDeletingReferencedRoot(query, root, referencingProjects)) {
                    filesToSkip.add(resource);
                }
            }
            ++i;
        }
        this.removeFromSetToDelete((IResource[])filesToSkip.toArray(new IFile[filesToSkip.size()]));
    }

    private void removeUnconfirmedReferencedPackageFragmentRoots(IConfirmQuery query) throws JavaModelException, OperationCanceledException {
        ArrayList<IPackageFragmentRoot> rootsToSkip = new ArrayList<IPackageFragmentRoot>(0);
        int i = 0;
        while (i < this.fJavaElements.length) {
            List<IJavaProject> referencingProjects;
            IPackageFragmentRoot root;
            IJavaElement element = this.fJavaElements[i];
            if (element instanceof IPackageFragmentRoot && JavaDeleteProcessor.skipDeletingReferencedRoot(query, root = (IPackageFragmentRoot)element, referencingProjects = Arrays.asList(JavaElementUtil.getReferencingProjects(root)))) {
                rootsToSkip.add(root);
            }
            ++i;
        }
        this.removeFromSetToDelete(rootsToSkip.toArray(new IJavaElement[rootsToSkip.size()]));
    }

    private static boolean skipDeletingReferencedRoot(IConfirmQuery query, IPackageFragmentRoot root, List referencingProjects) throws OperationCanceledException {
        if (referencingProjects.isEmpty() || root == null || !root.exists() || !root.isArchive()) {
            return false;
        }
        String question = RefactoringCoreMessages.getFormattedString("DeleteRefactoring.3", root.getElementName());
        return !query.confirm(question, referencingProjects.toArray());
    }

    private void removeUnconfirmedFoldersThatContainSourceFolders() throws CoreException {
        String queryTitle = RefactoringCoreMessages.getString("DeleteRefactoring.4");
        IConfirmQuery query = this.fDeleteQueries.createYesYesToAllNoNoToAllQuery(queryTitle, true, 4);
        ArrayList<IFolder> foldersToSkip = new ArrayList<IFolder>(0);
        int i = 0;
        while (i < this.fResources.length) {
            String question;
            IFolder folder;
            IResource resource = this.fResources[i];
            if (resource instanceof IFolder && JavaDeleteProcessor.containsSourceFolder(folder = (IFolder)resource) && !query.confirm(question = RefactoringCoreMessages.getFormattedString("DeleteRefactoring.5", folder.getName()))) {
                foldersToSkip.add(folder);
            }
            ++i;
        }
        this.removeFromSetToDelete(foldersToSkip.toArray(new IResource[foldersToSkip.size()]));
    }

    private static boolean containsSourceFolder(IFolder folder) throws CoreException {
        IResource[] subFolders = folder.members();
        int i = 0;
        while (i < subFolders.length) {
            if (subFolders[i] instanceof IFolder) {
                IJavaElement element = JavaCore.create((IFolder)folder);
                if (element instanceof IPackageFragmentRoot) {
                    return true;
                }
                if (!(element instanceof IPackageFragment) && JavaDeleteProcessor.containsSourceFolder((IFolder)subFolders[i])) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    private void removeElementsWithParentsInSelection() {
        ParentChecker parentUtil = new ParentChecker(this.fResources, this.fJavaElements);
        parentUtil.removeElementsWithAncestorsOnList(false);
        this.fJavaElements = parentUtil.getJavaElements();
        this.fResources = parentUtil.getResources();
    }

    private void removeJavaElementsChildrenOfJavaElements() {
        ParentChecker parentUtil = new ParentChecker(this.fResources, this.fJavaElements);
        parentUtil.removeElementsWithAncestorsOnList(true);
        this.fJavaElements = parentUtil.getJavaElements();
    }

    private IFile[] getClassPathFiles() {
        ArrayList<IFile> result = new ArrayList<IFile>();
        int i = 0;
        while (i < this.fJavaElements.length) {
            IProject project;
            IFile classPathFile;
            IJavaElement element = this.fJavaElements[i];
            if (element instanceof IPackageFragmentRoot && (classPathFile = (project = element.getJavaProject().getProject()).getFile(".classpath")).exists()) {
                result.add(classPathFile);
            }
            ++i;
        }
        return result.toArray(new IFile[result.size()]);
    }

    public Change createChange(IProgressMonitor pm) throws CoreException {
        pm.beginTask("", 1);
        pm.done();
        return this.fDeleteChange;
    }

    private void addToSetToDelete(IJavaElement[] newElements) {
        this.fJavaElements = ReorgUtils.union(this.fJavaElements, newElements);
    }

    private void removeFromSetToDelete(IResource[] resourcesToNotDelete) {
        this.fResources = ReorgUtils.setMinus(this.fResources, resourcesToNotDelete);
    }

    private void removeFromSetToDelete(IJavaElement[] elementsToNotDelete) {
        this.fJavaElements = ReorgUtils.setMinus(this.fJavaElements, elementsToNotDelete);
    }

    private void addGettersSetters() throws JavaModelException {
        IField[] fields = JavaDeleteProcessor.getFields(this.fJavaElements);
        if (fields.length == 0) {
            return;
        }
        Map getterSetterMapping = JavaDeleteProcessor.createGetterSetterMapping(fields);
        if (getterSetterMapping.isEmpty()) {
            return;
        }
        this.removeAlreadySelectedMethods(getterSetterMapping);
        if (getterSetterMapping.isEmpty()) {
            return;
        }
        List gettersSettersToAdd = this.getGettersSettersToDelete(getterSetterMapping);
        this.addToSetToDelete((IJavaElement[])gettersSettersToAdd.toArray(new IMethod[gettersSettersToAdd.size()]));
    }

    private List getGettersSettersToDelete(Map getterSetterMapping) {
        ArrayList<IMethod> gettersSettersToAdd = new ArrayList<IMethod>(getterSetterMapping.size());
        String queryTitle = RefactoringCoreMessages.getString("DeleteRefactoring.8");
        IConfirmQuery getterSetterQuery = this.fDeleteQueries.createYesYesToAllNoNoToAllQuery(queryTitle, true, 1);
        Iterator iter = getterSetterMapping.keySet().iterator();
        while (iter.hasNext()) {
            IField field = (IField)iter.next();
            Assert.isTrue(JavaDeleteProcessor.hasGetter(getterSetterMapping, field) || JavaDeleteProcessor.hasSetter(getterSetterMapping, field));
            String deleteGetterSetter = RefactoringCoreMessages.getFormattedString("DeleteRefactoring.9", JavaElementUtil.createFieldSignature(field));
            if (!getterSetterQuery.confirm(deleteGetterSetter)) continue;
            if (JavaDeleteProcessor.hasGetter(getterSetterMapping, field)) {
                gettersSettersToAdd.add(JavaDeleteProcessor.getGetter(getterSetterMapping, field));
            }
            if (!JavaDeleteProcessor.hasSetter(getterSetterMapping, field)) continue;
            gettersSettersToAdd.add(JavaDeleteProcessor.getSetter(getterSetterMapping, field));
        }
        return gettersSettersToAdd;
    }

    private void removeAlreadySelectedMethods(Map getterSetterMapping) {
        List<IJavaElement> elementsToDelete = Arrays.asList(this.fJavaElements);
        Iterator iter = getterSetterMapping.keySet().iterator();
        while (iter.hasNext()) {
            IMethod setter;
            IField field = (IField)iter.next();
            IMethod getter = JavaDeleteProcessor.getGetter(getterSetterMapping, field);
            if (getter != null && elementsToDelete.contains(getter)) {
                JavaDeleteProcessor.removeGetterFromMapping(getterSetterMapping, field);
            }
            if ((setter = JavaDeleteProcessor.getSetter(getterSetterMapping, field)) != null && elementsToDelete.contains(setter)) {
                JavaDeleteProcessor.removeSetterFromMapping(getterSetterMapping, field);
            }
            if (JavaDeleteProcessor.hasGetter(getterSetterMapping, field) || JavaDeleteProcessor.hasSetter(getterSetterMapping, field)) continue;
            iter.remove();
        }
    }

    private static Map createGetterSetterMapping(IField[] fields) throws JavaModelException {
        HashMap<IField, IMethod[]> result = new HashMap<IField, IMethod[]>();
        int i = 0;
        while (i < fields.length) {
            IField field = fields[i];
            IMethod[] getterSetter = JavaDeleteProcessor.getGetterSetter(field);
            if (getterSetter != null) {
                result.put(field, getterSetter);
            }
            ++i;
        }
        return result;
    }

    private static boolean hasSetter(Map getterSetterMapping, IField field) {
        return getterSetterMapping.containsKey(field) && JavaDeleteProcessor.getSetter(getterSetterMapping, field) != null;
    }

    private static boolean hasGetter(Map getterSetterMapping, IField field) {
        return getterSetterMapping.containsKey(field) && JavaDeleteProcessor.getGetter(getterSetterMapping, field) != null;
    }

    private static void removeGetterFromMapping(Map getterSetterMapping, IField field) {
        ((IMethod[])getterSetterMapping.get((Object)field))[0] = null;
    }

    private static void removeSetterFromMapping(Map getterSetterMapping, IField field) {
        ((IMethod[])getterSetterMapping.get((Object)field))[1] = null;
    }

    private static IMethod getGetter(Map getterSetterMapping, IField field) {
        return ((IMethod[])getterSetterMapping.get(field))[0];
    }

    private static IMethod getSetter(Map getterSetterMapping, IField field) {
        return ((IMethod[])getterSetterMapping.get(field))[1];
    }

    private static IField[] getFields(IJavaElement[] elements) {
        ArrayList<IJavaElement> fields = new ArrayList<IJavaElement>(3);
        int i = 0;
        while (i < elements.length) {
            if (elements[i] instanceof IField) {
                fields.add(elements[i]);
            }
            ++i;
        }
        return fields.toArray(new IField[fields.size()]);
    }

    private static IMethod[] getGetterSetter(IField field) throws JavaModelException {
        IMethod getter = GetterSetterUtil.getGetter(field);
        IMethod setter = GetterSetterUtil.getSetter(field);
        if (getter != null && getter.exists() || setter != null && setter.exists()) {
            return new IMethod[]{getter, setter};
        }
        return null;
    }

    private void confirmDeletingReadOnly() throws CoreException {
        if (!ReadOnlyResourceFinder.confirmDeleteOfReadOnlyElements(this.fJavaElements, this.fResources, this.fDeleteQueries)) {
            throw new OperationCanceledException();
        }
    }

    private void addEmptyCusToDelete() throws JavaModelException {
        Set cusToEmpty = this.getCusToEmpty();
        this.addToSetToDelete((IJavaElement[])cusToEmpty.toArray(new ICompilationUnit[cusToEmpty.size()]));
    }

    private Set getCusToEmpty() throws JavaModelException {
        HashSet<ICompilationUnit> result = new HashSet<ICompilationUnit>();
        int i = 0;
        while (i < this.fJavaElements.length) {
            IJavaElement element = this.fJavaElements[i];
            ICompilationUnit cu = ReorgUtils.getCompilationUnit(element);
            if (cu != null && !result.contains(cu) && this.willHaveAllTopLevelTypesDeleted(cu)) {
                result.add(cu);
            }
            ++i;
        }
        return result;
    }

    private boolean willHaveAllTopLevelTypesDeleted(ICompilationUnit cu) throws JavaModelException {
        HashSet<IJavaElement> elementSet = new HashSet<IJavaElement>(Arrays.asList(this.fJavaElements));
        IType[] topLevelTypes = cu.getTypes();
        int i = 0;
        while (i < topLevelTypes.length) {
            if (!elementSet.contains(topLevelTypes[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

