/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.nls;

import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;

public class SimpleLineReader {
    private IDocument fInput;
    private int fCurrLine;

    public SimpleLineReader(IDocument input) {
        this.fInput = input;
        this.fCurrLine = 0;
    }

    public String readLine() {
        int nLines = this.fInput.getNumberOfLines();
        if (this.fCurrLine >= nLines) {
            return null;
        }
        try {
            int end;
            IRegion region = this.fInput.getLineInformation(this.fCurrLine++);
            String content = this.fInput.get(region.getOffset(), region.getLength());
            int start = region.getOffset();
            boolean continuesOnNext = content.endsWith("\\") && !SimpleLineReader.isCommentOrWhiteSpace(content);
            while (continuesOnNext && this.fCurrLine < nLines) {
                boolean bl = continuesOnNext = (content = this.fInput.get((region = this.fInput.getLineInformation(this.fCurrLine++)).getOffset(), region.getLength())).endsWith("\\") && !SimpleLineReader.isCommentOrWhiteSpace(content);
            }
            if (this.fCurrLine < nLines) {
                end = this.fInput.getLineOffset(this.fCurrLine);
            } else {
                end = this.fInput.getLength();
                if (end == start) {
                    return null;
                }
            }
            return this.fInput.get(start, end - start);
        }
        catch (BadLocationException e) {
            JavaPlugin.log(e);
            return null;
        }
    }

    public static boolean isCommentOrWhiteSpace(String line) {
        return (line = line.trim()).length() == 0 || line.charAt(0) == '!' || line.charAt(0) == '#';
    }
}

