/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.codemanipulation;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationMessages;
import org.eclipse.jdt.internal.corext.codemanipulation.GetterSetterUtil;
import org.eclipse.jdt.internal.corext.codemanipulation.IRequestQuery;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;

public class AddGetterSetterOperation
implements IWorkspaceRunnable {
    private IJavaElement fInsertPosition;
    private int fFlags;
    private boolean fSort;
    private final String[] EMPTY = new String[0];
    private IField[] fGetterFields;
    private IField[] fSetterFields;
    private IField[] fGetterSetterFields;
    private List fCreatedAccessors;
    private IRequestQuery fSkipExistingQuery;
    private IRequestQuery fSkipFinalSettersQuery;
    private boolean fSkipAllFinalSetters;
    private boolean fSkipAllExisting;
    private boolean fCreateComments;

    public AddGetterSetterOperation(IField[] getterFields, IField[] setterFields, IField[] getterSetterFields, IRequestQuery skipFinalSettersQuery, IRequestQuery skipExistingQuery, IJavaElement elementPosition) {
        this.fGetterFields = getterFields;
        this.fSetterFields = setterFields;
        this.fGetterSetterFields = getterSetterFields;
        this.fSkipExistingQuery = skipExistingQuery;
        this.fSkipFinalSettersQuery = skipFinalSettersQuery;
        this.fCreatedAccessors = new ArrayList();
        this.fInsertPosition = elementPosition;
        this.fCreateComments = true;
        this.fFlags = 1;
        this.fSort = false;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            int i;
            monitor.setTaskName(CodeGenerationMessages.getString("AddGetterSetterOperation.description"));
            monitor.beginTask("", this.fGetterFields.length + this.fSetterFields.length);
            this.fSkipAllFinalSetters = this.fSkipFinalSettersQuery == null;
            boolean bl = this.fSkipAllExisting = this.fSkipExistingQuery == null;
            if (!this.fSort) {
                i = 0;
                while (i < this.fGetterSetterFields.length) {
                    this.generateGetter(this.fGetterSetterFields[i]);
                    this.generateSetter(this.fGetterSetterFields[i]);
                    monitor.worked(1);
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    ++i;
                }
            }
            i = 0;
            while (true) {
                if (i >= this.fGetterFields.length) {
                    i = 0;
                    break;
                }
                this.generateGetter(this.fGetterFields[i]);
                monitor.worked(1);
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                ++i;
            }
            while (i < this.fSetterFields.length) {
                this.generateSetter(this.fSetterFields[i]);
                monitor.worked(1);
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        monitor.done();
    }

    private boolean querySkipFinalSetters(IField field) throws OperationCanceledException {
        if (!this.fSkipAllFinalSetters) {
            switch (this.fSkipFinalSettersQuery.doQuery((IMember)field)) {
                case 0: {
                    throw new OperationCanceledException();
                }
                case 1: {
                    return false;
                }
                case 3: {
                    this.fSkipAllFinalSetters = true;
                }
            }
        }
        return true;
    }

    private boolean querySkipExistingMethods(IMethod method) throws OperationCanceledException {
        if (!this.fSkipAllExisting) {
            switch (this.fSkipExistingQuery.doQuery((IMember)method)) {
                case 0: {
                    throw new OperationCanceledException();
                }
                case 1: {
                    return false;
                }
                case 3: {
                    this.fSkipAllExisting = true;
                }
            }
        }
        return true;
    }

    private void generateGetter(IField field) throws CoreException, OperationCanceledException {
        boolean doCreateGetter;
        IType parentType = field.getDeclaringType();
        String getterName = GetterSetterUtil.getGetterName(field, null);
        IMethod existingGetter = JavaModelUtil.findMethod(getterName, this.EMPTY, false, parentType);
        boolean bl = doCreateGetter = existingGetter == null || !this.querySkipExistingMethods(existingGetter);
        if (doCreateGetter) {
            int flags = this.fFlags | field.getFlags() & 8;
            String stub = GetterSetterUtil.getGetterStub(field, getterName, this.fCreateComments, flags);
            IJavaElement sibling = null;
            if (existingGetter != null) {
                sibling = StubUtility.findNextSibling((IJavaElement)existingGetter);
                existingGetter.delete(false, null);
            } else {
                sibling = this.getInsertPosition();
            }
            String lineDelim = StubUtility.getLineDelimiterUsed((IJavaElement)parentType);
            int indent = StubUtility.getIndentUsed((IJavaElement)field);
            String formattedContent = String.valueOf(CodeFormatterUtil.format(4, stub, indent, null, lineDelim, field.getJavaProject())) + lineDelim;
            this.fCreatedAccessors.add(parentType.createMethod(formattedContent, sibling, true, null));
        }
    }

    private void generateSetter(IField field) throws CoreException, OperationCanceledException {
        boolean doCreateSetter;
        boolean isFinal = Flags.isFinal((int)field.getFlags());
        IType parentType = field.getDeclaringType();
        String setterName = GetterSetterUtil.getSetterName(field, null);
        String returnSig = field.getTypeSignature();
        String[] args = new String[]{returnSig};
        IMethod existingSetter = JavaModelUtil.findMethod(setterName, args, false, parentType);
        boolean bl = doCreateSetter = !(isFinal && this.querySkipFinalSetters(field) || existingSetter != null && !this.querySkipExistingMethods(existingSetter));
        if (doCreateSetter) {
            int flags = this.fFlags | field.getFlags() & 8;
            String stub = GetterSetterUtil.getSetterStub(field, setterName, this.fCreateComments, flags);
            IJavaElement sibling = null;
            if (existingSetter != null) {
                sibling = StubUtility.findNextSibling((IJavaElement)existingSetter);
                existingSetter.delete(false, null);
            } else {
                sibling = this.getInsertPosition();
            }
            String lineDelim = StubUtility.getLineDelimiterUsed((IJavaElement)parentType);
            int indent = StubUtility.getIndentUsed((IJavaElement)field);
            String formattedContent = String.valueOf(CodeFormatterUtil.format(4, stub, indent, null, lineDelim, field.getJavaProject())) + lineDelim;
            this.fCreatedAccessors.add(parentType.createMethod(formattedContent, sibling, true, null));
        }
    }

    public IMethod[] getCreatedAccessors() {
        return this.fCreatedAccessors.toArray(new IMethod[this.fCreatedAccessors.size()]);
    }

    public void setSort(boolean sort) {
        this.fSort = sort;
    }

    public void setFlags(int flags) {
        this.fFlags = flags;
    }

    public void setCreateComments(boolean createComments) {
        this.fCreateComments = createComments;
    }

    public IJavaElement getInsertPosition() {
        return this.fInsertPosition;
    }

    public ISchedulingRule getScheduleRule() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }
}

