/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.codemanipulation;

import java.util.ArrayList;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.NamingConventions;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.IScanner;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationMessages;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.IImportsStructure;
import org.eclipse.jdt.internal.corext.codemanipulation.ImportsStructure;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.TokenScanner;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.JdtFlags;

public class AddCustomConstructorOperation
implements IWorkspaceRunnable {
    private IJavaElement fInsertPosition;
    private IField[] fSelected;
    private IType fType;
    private IMethod fConstructorCreated;
    private boolean fDoSave;
    private CodeGenerationSettings fSettings;
    private IMethod fSuperConstructor;
    private boolean fOmitSuper;
    private int fVisibility;

    public AddCustomConstructorOperation(IType type, CodeGenerationSettings settings, IField[] selected, boolean save, IJavaElement insertPosition, IMethod superConstructor) {
        this.fType = type;
        this.fDoSave = save;
        this.fConstructorCreated = null;
        this.fSettings = settings;
        this.fSelected = selected;
        this.fInsertPosition = insertPosition;
        this.fSuperConstructor = superConstructor;
        this.fVisibility = 0;
        this.fOmitSuper = false;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        try {
            StringBuffer buf;
            ImportsStructure imports;
            block18: {
                String lineDelimiter;
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                monitor.setTaskName(CodeGenerationMessages.getString("AddCustomConstructorOperation.description"));
                monitor.beginTask("", 7);
                monitor.worked(1);
                imports = new ImportsStructure(this.fType.getCompilationUnit(), this.fSettings.importOrder, this.fSettings.importThreshold, true);
                ITypeHierarchy hierarchy = this.fType.newSupertypeHierarchy((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                IJavaProject project = this.fType.getJavaProject();
                String[] superConstructorParamNames = StubUtility.suggestArgumentNames(project, this.fSuperConstructor.getParameterNames());
                String defaultConstructor = this.genOverrideConstructorStub(this.fSuperConstructor, superConstructorParamNames, this.fType, hierarchy, this.fSettings, imports, this.fOmitSuper);
                int closingBraceIndex = defaultConstructor.lastIndexOf(125);
                IScanner scanner = ToolFactory.createScanner((boolean)true, (boolean)false, (boolean)false, (boolean)false);
                scanner.setSource(defaultConstructor.toCharArray());
                TokenScanner tokenScanner = new TokenScanner(scanner);
                int closingParenIndex = tokenScanner.getTokenStartOffset(86, 0);
                monitor.worked(1);
                String[] params = new String[this.fSelected.length];
                String[] excludedNames = new String[superConstructorParamNames.length + params.length];
                int i = 0;
                while (true) {
                    if (i >= excludedNames.length) break;
                    excludedNames[i] = "";
                    ++i;
                }
                ArrayList<String> superNames = new ArrayList<String>(superConstructorParamNames.length);
                int i2 = 0;
                while (true) {
                    if (i2 >= superConstructorParamNames.length) break;
                    superNames.add(superConstructorParamNames[i2]);
                    excludedNames[i2] = superConstructorParamNames[i2];
                    ++i2;
                }
                buf = new StringBuffer(defaultConstructor.substring(0, closingParenIndex));
                monitor.worked(1);
                int i3 = 0;
                int k = superConstructorParamNames.length;
                while (true) {
                    if (i3 >= this.fSelected.length) break;
                    if (k > 0) {
                        buf.append(", ");
                    }
                    if (Flags.isFinal((int)this.fSelected[i3].getFlags())) {
                        buf.append("final ");
                    }
                    buf.append(Signature.toString((String)this.fSelected[i3].getTypeSignature()));
                    buf.append(' ');
                    String accessName = NamingConventions.removePrefixAndSuffixForFieldName((IJavaProject)project, (String)this.fSelected[i3].getElementName(), (int)this.fSelected[i3].getFlags());
                    String paramName = StubUtility.suggestArgumentName(project, accessName, excludedNames);
                    excludedNames[k] = new String(paramName);
                    params[i3] = paramName;
                    buf.append(paramName);
                    ++i3;
                    ++k;
                }
                monitor.worked(1);
                buf.append(defaultConstructor.substring(closingParenIndex, closingBraceIndex));
                i3 = 0;
                while (true) {
                    if (i3 >= this.fSelected.length) {
                        buf.append("}");
                        monitor.worked(1);
                        if (this.fSettings.createComments) {
                            break;
                        }
                        break block18;
                    }
                    String fieldName = this.fSelected[i3].getElementName();
                    boolean isStatic = Flags.isStatic((int)this.fSelected[i3].getFlags());
                    if (isStatic) {
                        buf.append(this.fSelected[i3].getParent().getElementName());
                        buf.append(".");
                    } else if (this.fSettings.useKeywordThis || params[i3].equals(fieldName) || superNames.contains(fieldName)) {
                        buf.append("this.");
                    }
                    buf.append(fieldName);
                    buf.append(" = ");
                    buf.append(params[i3]);
                    buf.append(";\n");
                    ++i3;
                }
                String[] javadocParams = new String[superConstructorParamNames.length + params.length];
                int count = 0;
                int i4 = 0;
                while (true) {
                    if (i4 >= this.fSuperConstructor.getNumberOfParameters()) break;
                    javadocParams[count++] = superConstructorParamNames[i4];
                    ++i4;
                }
                i4 = 0;
                while (true) {
                    if (i4 >= params.length) {
                        lineDelimiter = String.valueOf('\n');
                        String comment = StubUtility.getMethodComment(this.fType.getCompilationUnit(), this.fType.getElementName(), this.fSuperConstructor.getElementName(), javadocParams, this.fSuperConstructor.getExceptionTypes(), null, null, lineDelimiter);
                        if (comment == null) break;
                        buf.insert(0, comment);
                        break block18;
                    }
                    javadocParams[count++] = params[i4];
                    ++i4;
                }
                buf.append("/**").append(lineDelimiter);
                buf.append(" *").append(lineDelimiter);
                buf.append(" */").append(lineDelimiter);
            }
            String lineDelim = StubUtility.getLineDelimiterUsed((IJavaElement)this.fType);
            int indent = StubUtility.getIndentUsed((IJavaElement)this.fType) + 1;
            String formattedContent = String.valueOf(CodeFormatterUtil.format(4, buf.toString(), indent, null, lineDelim, this.fType.getJavaProject())) + lineDelim;
            this.fConstructorCreated = this.fType.createMethod(formattedContent, this.fInsertPosition, true, null);
            monitor.worked(1);
            imports.create(this.fDoSave, null);
            monitor.worked(1);
        }
        catch (Throwable throwable) {
            Object var19_29 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var19_30 = null;
        }
        monitor.done();
    }

    private String genOverrideConstructorStub(IMethod constructorToImplement, String[] constructorParamNames, IType type, ITypeHierarchy hierarchy, CodeGenerationSettings settings, IImportsStructure imports, boolean omitSuper) throws CoreException {
        IMethod desc;
        StubUtility.GenStubSettings genStubSettings = new StubUtility.GenStubSettings(settings);
        genStubSettings.methodOverwrites = true;
        genStubSettings.methodModifiers = this.fVisibility | JdtFlags.clearAccessModifiers(constructorToImplement.getFlags());
        genStubSettings.callSuper = !omitSuper;
        IMethod overrides = JavaModelUtil.findMethodImplementationInHierarchy(hierarchy, type, constructorToImplement.getElementName(), constructorToImplement.getParameterTypes(), constructorToImplement.isConstructor());
        if (overrides != null) {
            constructorToImplement = overrides;
        }
        if ((desc = JavaModelUtil.findMethodDeclarationInHierarchy(hierarchy, type, constructorToImplement.getElementName(), constructorToImplement.getParameterTypes(), constructorToImplement.isConstructor())) == null) {
            desc = constructorToImplement;
        }
        String methName = constructorToImplement.getElementName();
        String bodyStatement = StubUtility.getDefaultMethodBodyStatement(methName, constructorParamNames, null, genStubSettings.callSuper);
        StringBuffer buf = new StringBuffer();
        StubUtility.genMethodDeclaration(type.getElementName(), constructorToImplement, genStubSettings.methodModifiers, bodyStatement, imports, buf);
        return buf.toString();
    }

    public IMethod getCreatedConstructor() {
        return this.fConstructorCreated;
    }

    public void setOmitSuper(boolean callSuper) {
        this.fOmitSuper = callSuper;
    }

    public int getVisbility() {
        return this.fVisibility;
    }

    public void setVisbility(int visbility) {
        this.fVisibility = visbility;
    }

    public ISchedulingRule getScheduleRule() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }
}

