/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.schema;

import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.ischema.IPluginLocationProvider;
import org.eclipse.pde.internal.core.ischema.ISchema;
import org.eclipse.pde.internal.core.ischema.ISchemaDescriptor;
import org.eclipse.pde.internal.core.ischema.ISchemaInclude;
import org.eclipse.pde.internal.core.ischema.ISchemaObject;
import org.eclipse.pde.internal.core.schema.IncludedSchemaDescriptor;
import org.eclipse.pde.internal.core.schema.Schema;
import org.eclipse.pde.internal.core.schema.SchemaObject;

public class SchemaInclude
extends SchemaObject
implements ISchemaInclude {
    private String location;
    private ISchema includedSchema;
    private boolean internal;

    public SchemaInclude(ISchemaObject parent, String location) {
        super(parent, location);
        this.location = location;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) throws CoreException {
        String oldValue = this.location;
        this.location = location;
        this.includedSchema = null;
        this.getSchema().fireModelObjectChanged(this, "location", oldValue, location);
    }

    public void write(String indent, PrintWriter writer) {
        writer.print(indent);
        writer.println("<include schemaLocation=\"" + this.location + "\"/>");
    }

    public ISchema getIncludedSchema() {
        if (this.includedSchema != null && this.includedSchema.isDisposed()) {
            this.includedSchema = null;
        }
        if (this.includedSchema == null) {
            ISchemaDescriptor descriptor = this.getSchema().getSchemaDescriptor();
            if (descriptor != null && !descriptor.isStandalone()) {
                this.includedSchema = PDECore.getDefault().getSchemaRegistry().getIncludedSchema(descriptor, this.location);
                this.internal = false;
            } else {
                URL url = this.getSchema().getURL();
                if (url != null) {
                    this.includedSchema = this.createInternalSchema(descriptor, url, this.location);
                    if (this.includedSchema != null) {
                        this.internal = true;
                    }
                }
            }
        }
        return this.includedSchema;
    }

    private ISchema createInternalSchema(IPluginLocationProvider locationProvider, URL parentURL, String location) {
        try {
            URL schemaURL = IncludedSchemaDescriptor.computeURL(locationProvider, parentURL, location);
            Schema ischema = new Schema(null, schemaURL);
            ischema.load();
            return ischema;
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public void dispose() {
        if (this.internal && this.includedSchema != null && !this.includedSchema.isDisposed()) {
            this.includedSchema.dispose();
            this.includedSchema = null;
            this.internal = false;
        }
    }
}

