/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.model;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.util.FileUtils;
import org.eclipse.ant.core.AntCorePlugin;
import org.eclipse.ant.core.AntCorePreferences;
import org.eclipse.ant.core.AntRunner;
import org.eclipse.ant.core.TargetInfo;
import org.eclipse.ant.internal.core.AntClasspathEntry;
import org.eclipse.ant.internal.ui.launchConfigurations.AntHomeClasspathEntry;
import org.eclipse.ant.internal.ui.model.AntUIModelMessages;
import org.eclipse.ant.internal.ui.model.AntUIPlugin;
import org.eclipse.ant.internal.ui.views.AntView;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.console.FileLink;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry2;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public final class AntUtil {
    public static final String ATTRIBUTE_SEPARATOR = ",";
    public static final char ANT_CLASSPATH_DELIMITER = '*';
    public static final String ANT_HOME_CLASSPATH_PLACEHOLDER = "G";
    public static final String ANT_GLOBAL_USER_CLASSPATH_PLACEHOLDER = "UG";

    private AntUtil() {
    }

    public static String combineStrings(String[] strings) {
        if (strings.length == 0) {
            return null;
        }
        if (strings.length == 1) {
            return strings[0];
        }
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < strings.length - 1) {
            buf.append(strings[i]);
            buf.append(ATTRIBUTE_SEPARATOR);
            ++i;
        }
        buf.append(strings[strings.length - 1]);
        return buf.toString();
    }

    public static String[] getTargetsFromConfig(ILaunchConfiguration configuration) throws CoreException {
        String attribute = configuration.getAttribute("org.eclipse.ui.externaltools.ATTR_ANT_TARGETS", null);
        if (attribute == null) {
            return null;
        }
        return AntUtil.parseRunTargets(attribute);
    }

    public static Map getProperties(ILaunchConfiguration configuration) throws CoreException {
        Map map = configuration.getAttribute("org.eclipse.ui.externaltools.ATTR_ANT_PROPERTIES", null);
        return map;
    }

    public static String getAntHome(ILaunchConfiguration configuration) throws CoreException {
        IRuntimeClasspathEntry[] entries = JavaRuntime.computeUnresolvedRuntimeClasspath((ILaunchConfiguration)configuration);
        int i = 0;
        while (i < entries.length) {
            IRuntimeClasspathEntry2 entry2;
            IRuntimeClasspathEntry entry = entries[i];
            if (entry.getType() == 5 && (entry2 = (IRuntimeClasspathEntry2)entry).getTypeId().equals("org.eclipse.ant.ui.classpathentry.antHome")) {
                return ((AntHomeClasspathEntry)entry2).getAntHome();
            }
            ++i;
        }
        return null;
    }

    public static String[] getPropertyFiles(ILaunchConfiguration configuration) throws CoreException {
        String attribute = configuration.getAttribute("org.eclipse.ui.externaltools.ATTR_ANT_PROPERTY_FILES", null);
        if (attribute == null) {
            return null;
        }
        String[] propertyFiles = AntUtil.parseString(attribute, ATTRIBUTE_SEPARATOR);
        int i = 0;
        while (i < propertyFiles.length) {
            String propertyFile = propertyFiles[i];
            propertyFiles[i] = propertyFile = AntUtil.expandVariableString(propertyFile, AntUIModelMessages.getString("AntUtil.6"));
            ++i;
        }
        return propertyFiles;
    }

    public static TargetInfo[] getTargets(String path) throws CoreException {
        AntRunner runner = new AntRunner();
        runner.setBuildFileLocation(path);
        return runner.getAvailableTargets();
    }

    public static TargetInfo[] getTargets(String path, String[] arguments, ILaunchConfiguration config) throws CoreException {
        Map properties = AntUtil.getProperties(config);
        String[] propertyFiles = AntUtil.getPropertyFiles(config);
        AntRunner runner = new AntRunner();
        runner.setBuildFileLocation(path);
        if (properties != null) {
            runner.addUserProperties(properties);
        }
        if (propertyFiles != null && propertyFiles.length > 0) {
            runner.setPropertyFiles(propertyFiles);
        }
        if (arguments != null && arguments.length > 0) {
            runner.setArguments(arguments);
        }
        runner.setCustomClasspath(AntUtil.getCustomClasspath(config));
        String antHome = AntUtil.getAntHome(config);
        if (antHome != null) {
            runner.setAntHome(antHome);
        }
        return runner.getAvailableTargets();
    }

    public static URL[] getCustomClasspath(ILaunchConfiguration config) throws CoreException {
        boolean useDefault = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, true);
        if (useDefault) {
            return null;
        }
        IRuntimeClasspathEntry[] unresolved = JavaRuntime.computeUnresolvedRuntimeClasspath((ILaunchConfiguration)config);
        ArrayList<IRuntimeClasspathEntry> userEntries = new ArrayList<IRuntimeClasspathEntry>(unresolved.length);
        int i = 0;
        while (i < unresolved.length) {
            IRuntimeClasspathEntry entry = unresolved[i];
            if (entry.getClasspathProperty() == 3) {
                userEntries.add(entry);
            }
            ++i;
        }
        IRuntimeClasspathEntry[] entries = JavaRuntime.resolveRuntimeClasspath((IRuntimeClasspathEntry[])userEntries.toArray(new IRuntimeClasspathEntry[userEntries.size()]), (ILaunchConfiguration)config);
        URL[] urls = new URL[entries.length];
        int i2 = 0;
        while (i2 < entries.length) {
            IRuntimeClasspathEntry entry = entries[i2];
            try {
                urls[i2] = new URL("file:" + entry.getLocation());
            }
            catch (MalformedURLException e) {
                throw new CoreException((IStatus)new Status(4, AntUIPlugin.getUniqueIdentifier(), 120, AntUIModelMessages.getString("AntUtil.7"), (Throwable)e));
            }
            ++i2;
        }
        return urls;
    }

    public static void getCustomClasspaths(ILaunchConfiguration config, List antHomeEntries, List additionalEntries) {
        String classpathString = null;
        try {
            classpathString = config.getAttribute("org.eclipse.ui.externaltools.ATTR_ANT_CUSTOM_CLASSPATH", null);
        }
        catch (CoreException coreException) {}
        if (classpathString == null) {
            return;
        }
        String antString = null;
        String userString = null;
        int delim = classpathString.indexOf(42);
        if (delim == -1) {
            antString = classpathString;
        } else {
            antString = classpathString.substring(0, delim);
            userString = classpathString.substring(delim + 1);
        }
        AntUtil.getEntries(antHomeEntries, antString);
        if (userString != null) {
            AntUtil.getEntries(additionalEntries, userString);
        }
    }

    private static void getEntries(List entries, String urlString) {
        String[] entryStrings = AntUtil.parseString(urlString, ATTRIBUTE_SEPARATOR);
        AntCorePreferences prefs = AntCorePlugin.getPlugin().getPreferences();
        int i = 0;
        while (i < entryStrings.length) {
            String string = entryStrings[i];
            if (string.equals(ANT_HOME_CLASSPATH_PLACEHOLDER)) {
                entries.addAll(Arrays.asList(prefs.getAntHomeClasspathEntries()));
            } else if (string.equals(ANT_GLOBAL_USER_CLASSPATH_PLACEHOLDER)) {
                entries.addAll(Arrays.asList(prefs.getAdditionalClasspathEntries()));
            } else {
                if (string.charAt(0) == '?') {
                    string = string.substring(1);
                }
                entries.add(new AntClasspathEntry(string));
            }
            ++i;
        }
    }

    private static String expandVariableString(String variableString, String invalidMessage) throws CoreException {
        String expandedString = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(variableString);
        if (expandedString == null || expandedString.length() == 0) {
            String msg = MessageFormat.format(invalidMessage, variableString);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.ant.ui", 0, msg, null));
        }
        return expandedString;
    }

    public static AntView getAntView() {
        IWorkbenchPage page;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null) {
            return (AntView)page.findView("org.eclipse.ant.ui.AntView");
        }
        return null;
    }

    public static String[] parseRunTargets(String extraAttibuteValue) {
        return AntUtil.parseString(extraAttibuteValue, ATTRIBUTE_SEPARATOR);
    }

    public static String[] parseString(String delimString, String delim) {
        if (delimString == null) {
            return new String[0];
        }
        StringTokenizer tokenizer = new StringTokenizer(delimString, delim);
        String[] results = new String[tokenizer.countTokens()];
        int i = 0;
        while (i < results.length) {
            results[i] = tokenizer.nextToken();
            ++i;
        }
        return results;
    }

    public static IFile getFile(String fullPath) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        return root.getFile((IPath)new Path(fullPath));
    }

    public static FileLink getTaskLink(String path, File buildFileParent) {
        String fileName;
        IFile file;
        int index;
        if ((path = path.trim()).length() == 0) {
            return null;
        }
        if (path.startsWith("file:")) {
            path = path.substring(5, path.length());
        }
        if ((index = path.lastIndexOf(58)) == path.length() - 1) {
            path = path.substring(0, index);
            index = path.lastIndexOf(58);
        }
        if ((file = AntUtil.getFileForLocation(fileName = path.substring(0, index), buildFileParent)) != null) {
            try {
                String lineNumber = path.substring(index + 1);
                int line = Integer.parseInt(lineNumber);
                return new FileLink(file, null, -1, -1, line);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return null;
    }

    public static IFile getFileForLocation(String path, File buildFileParent) {
        Path filePath = new Path(path);
        IFile file = null;
        IFile[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation((IPath)filePath);
        if (files.length > 0) {
            file = files[0];
        }
        if (file == null) {
            File relativeFile = null;
            try {
                relativeFile = FileUtils.newFileUtils().resolveFile(buildFileParent, path);
                filePath = new Path(relativeFile.getAbsolutePath());
                files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation((IPath)filePath);
                if (files.length <= 0) {
                    return null;
                }
                file = files[0];
            }
            catch (BuildException buildException) {
                return null;
            }
        }
        if (file.exists()) {
            return file;
        }
        File ioFile = file.getLocation().toFile();
        if (ioFile.exists()) {
            try {
                files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation((IPath)new Path(ioFile.getCanonicalPath()));
                if (files.length > 0) {
                    return files[0];
                }
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    public static void migrateToNewClasspathFormat(ILaunchConfiguration configuration) throws CoreException {
        String oldClasspath = configuration.getAttribute("org.eclipse.ui.externaltools.ATTR_ANT_CUSTOM_CLASSPATH", null);
        String oldAntHome = configuration.getAttribute("org.eclipse.ui.externaltools.ATTR_ANT_HOME", null);
        String provider = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH_PROVIDER, null);
        if (oldClasspath != null || oldAntHome != null || provider == null) {
            ILaunchConfigurationWorkingCopy workingCopy = null;
            workingCopy = configuration.isWorkingCopy() ? (ILaunchConfigurationWorkingCopy)configuration : configuration.getWorkingCopy();
            workingCopy.setAttribute("org.eclipse.ui.externaltools.ATTR_ANT_CUSTOM_CLASSPATH", null);
            workingCopy.setAttribute("org.eclipse.ui.externaltools.ATTR_ANT_HOME", null);
            workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH_PROVIDER, "org.eclipse.ant.ui.AntClasspathProvider");
            workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, true);
            if (oldAntHome != null) {
                IRuntimeClasspathEntry[] entries = JavaRuntime.computeUnresolvedRuntimeClasspath((ILaunchConfiguration)workingCopy);
                ArrayList<String> mementos = new ArrayList<String>(entries.length);
                int i = 0;
                while (i < entries.length) {
                    IRuntimeClasspathEntry2 entry2;
                    IRuntimeClasspathEntry entry = entries[i];
                    if (entry.getType() == 5 && (entry2 = (IRuntimeClasspathEntry2)entry).getTypeId().equals("org.eclipse.ant.ui.classpathentry.antHome")) {
                        AntHomeClasspathEntry homeEntry = new AntHomeClasspathEntry(oldAntHome);
                        mementos.add(homeEntry.getMemento());
                    } else {
                        mementos.add(entry.getMemento());
                    }
                    ++i;
                }
                workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, false);
                workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH, mementos);
            }
            workingCopy.doSave();
        }
    }
}

