/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.editor.templates;

import org.eclipse.ant.internal.ui.editor.formatter.FormattingPreferences;
import org.eclipse.ant.internal.ui.editor.formatter.XmlFormatter;
import org.eclipse.ant.internal.ui.editor.templates.AntTemplateAccess;
import org.eclipse.ant.internal.ui.editor.templates.AntTemplateViewerConfiguration;
import org.eclipse.ant.internal.ui.editor.text.AntDocumentSetupParticipant;
import org.eclipse.ant.internal.ui.model.AntUIPlugin;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.persistence.TemplatePersistenceData;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.texteditor.templates.TemplatePreferencePage;

public class AntTemplatePreferencePage
extends TemplatePreferencePage {
    private FormattingPreferences fFormattingPreferences = new FormattingPreferences();

    public AntTemplatePreferencePage() {
        this.setPreferenceStore(AntUIPlugin.getDefault().getPreferenceStore());
        this.setTemplateStore(AntTemplateAccess.getDefault().getTemplateStore());
        this.setContextTypeRegistry(AntTemplateAccess.getDefault().getContextTypeRegistry());
    }

    public boolean performOk() {
        boolean ok = super.performOk();
        AntUIPlugin.getDefault().savePluginPreferences();
        return ok;
    }

    protected SourceViewer createViewer(Composite parent) {
        SourceViewer viewer = new SourceViewer(parent, null, null, false, 2816);
        AntTemplateViewerConfiguration configuration = new AntTemplateViewerConfiguration();
        Document document = new Document();
        new AntDocumentSetupParticipant().setup((IDocument)document);
        viewer.configure((SourceViewerConfiguration)configuration);
        viewer.setDocument((IDocument)document);
        viewer.setEditable(false);
        Font font = JFaceResources.getFont((String)"org.eclipse.jface.textfont");
        viewer.getTextWidget().setFont(font);
        return viewer;
    }

    protected String getFormatterPreferenceKey() {
        return "templates_use_codeformatter";
    }

    protected void updateViewerInput() {
        IStructuredSelection selection = (IStructuredSelection)this.getTableViewer().getSelection();
        SourceViewer viewer = this.getViewer();
        if (selection.size() == 1 && selection.getFirstElement() instanceof TemplatePersistenceData) {
            TemplatePersistenceData data = (TemplatePersistenceData)selection.getFirstElement();
            Template template = data.getTemplate();
            if (AntUIPlugin.getDefault().getPreferenceStore().getBoolean(this.getFormatterPreferenceKey())) {
                String formatted = XmlFormatter.format(template.getPattern(), this.fFormattingPreferences);
                viewer.getDocument().set(formatted);
            } else {
                viewer.getDocument().set(template.getPattern());
            }
        } else {
            viewer.getDocument().set("");
        }
    }

    protected boolean isShowFormatterSetting() {
        return false;
    }
}

