/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.monitors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.debug.core.IJavaObject;
import org.eclipse.jdt.debug.core.IJavaThread;
import org.eclipse.jdt.internal.debug.ui.monitors.MonitorManager;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class DeadLocksViewContentProvider
implements ITreeContentProvider {
    Object[] fRoots = null;

    public Object[] getChildren(Object parentElement) {
        Object object = null;
        if (parentElement instanceof ContentThreadWrapper) {
            object = ((ContentThreadWrapper)parentElement).fChild;
        } else if (parentElement instanceof ContentMonitorWrapper) {
            object = ((ContentMonitorWrapper)parentElement).fChild;
        }
        if (object != null) {
            return new Object[]{object};
        }
        return null;
    }

    public Object getParent(Object element) {
        if (element instanceof ContentThreadWrapper) {
            return ((ContentThreadWrapper)element).fParent;
        }
        if (element instanceof ContentMonitorWrapper) {
            return ((ContentMonitorWrapper)element).fParent;
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof ContentThreadWrapper) {
            return ((ContentThreadWrapper)element).fChild != null;
        }
        if (element instanceof ContentMonitorWrapper) {
            return ((ContentMonitorWrapper)element).fChild != null;
        }
        return false;
    }

    public Object[] getElements(Object inputElement) {
        if (this.fRoots == null) {
            MonitorManager manager = (MonitorManager)inputElement;
            int numDeadLocks = manager.getNumberOfDeadlocks();
            this.fRoots = new Object[numDeadLocks];
            int i = 0;
            while (i < numDeadLocks) {
                ContentThreadWrapper rootWrapper = new ContentThreadWrapper(manager.getStartThread(i), null);
                List deadlockList = manager.getDeadlockList(i);
                HashMap<ContentThreadWrapper, ContentThreadWrapper> tree = new HashMap<ContentThreadWrapper, ContentThreadWrapper>(deadlockList.size());
                tree.put(rootWrapper, rootWrapper);
                this.buildDeadlockTree(rootWrapper, tree, rootWrapper, deadlockList);
                this.fRoots[i] = rootWrapper;
                ++i;
            }
        }
        return this.fRoots;
    }

    protected void buildDeadlockTree(ContentThreadWrapper ctw, Map tree, Object parent, List deadlockList) {
        ArrayList<Object> childFinder = new ArrayList<Object>(deadlockList.size());
        int j = 1;
        while (j < deadlockList.size()) {
            Object inTree;
            Object next = deadlockList.get(j);
            Object object = next instanceof IJavaObject ? new ContentMonitorWrapper((IJavaObject)next, parent) : new ContentThreadWrapper((IJavaThread)next, parent);
            if (j == 1) {
                ctw.fChild = object;
            }
            if ((inTree = tree.get(object)) instanceof ContentThreadWrapper) {
                ((ContentThreadWrapper)inTree).caughtInADeadLock = true;
                ((ContentThreadWrapper)object).caughtInADeadLock = true;
            } else if (inTree == null) {
                tree.put(object, object);
            }
            parent = object;
            childFinder.add(object);
            ++j;
        }
        j = 0;
        while (j < childFinder.size() - 1) {
            Object element = childFinder.get(j);
            if (element instanceof ContentMonitorWrapper) {
                ((ContentMonitorWrapper)element).fChild = childFinder.get(j + 1);
            } else {
                ((ContentThreadWrapper)element).fChild = childFinder.get(j + 1);
            }
            ++j;
        }
    }

    public void dispose() {
        MonitorManager.getDefault().removeDeadlockUpdateListener();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        MonitorManager.getDefault().addDeadlockUpdateListener(this);
    }

    protected void clearDeadlockInformation() {
        this.fRoots = null;
    }

    public class ContentThreadWrapper {
        public IJavaThread fThread;
        public Object fParent = null;
        public boolean caughtInADeadLock;
        public Object fChild = null;

        protected ContentThreadWrapper(IJavaThread thread, Object parent) {
            this.fThread = thread;
            this.fParent = parent;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ContentThreadWrapper)) {
                return false;
            }
            ContentThreadWrapper other = (ContentThreadWrapper)obj;
            return other.fThread.equals(this.fThread);
        }

        public int hashCode() {
            return this.fThread.hashCode();
        }
    }

    public class ContentMonitorWrapper {
        public IJavaObject fMonitor;
        public Object fParent = null;
        public Object fChild = null;

        protected ContentMonitorWrapper(IJavaObject monitor, Object parent) {
            this.fMonitor = monitor;
            this.fParent = parent;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ContentMonitorWrapper)) {
                return false;
            }
            ContentMonitorWrapper other = (ContentMonitorWrapper)obj;
            return other.fMonitor.equals(this.fMonitor);
        }

        public int hashCode() {
            return this.fMonitor.hashCode();
        }
    }
}

