/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.launcher;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NameValuePairDialog
extends Dialog {
    private String fName;
    private String fValue;
    private String fTitle;
    private String[] fFieldLabels;
    private String[] fInitialValues;
    private Label fNameLabel;
    private Text fNameText;
    private Label fValueLabel;
    private Text fValueText;

    public NameValuePairDialog(Shell shell, String title, String[] fieldLabels, String[] initialValues) {
        super(shell);
        this.fTitle = title;
        this.fFieldLabels = fieldLabels;
        this.fInitialValues = initialValues;
    }

    protected Control createDialogArea(Composite parent) {
        Font font = parent.getFont();
        Composite comp = new Composite(parent, 0);
        GridLayout topLayout = new GridLayout();
        topLayout.numColumns = 2;
        topLayout.marginHeight = this.convertVerticalDLUsToPixels(7);
        topLayout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        topLayout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        topLayout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        comp.setLayout((Layout)topLayout);
        comp.setFont(font);
        this.fNameLabel = new Label(comp, 0);
        this.fNameLabel.setText(this.fFieldLabels[0]);
        this.fNameLabel.setFont(font);
        ModifyListener listener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NameValuePairDialog.this.updateButtons();
            }
        };
        this.fNameText = new Text(comp, 2052);
        this.fNameText.setText(this.fInitialValues[0]);
        GridData gd = new GridData(768);
        gd.widthHint = 300;
        this.fNameText.setLayoutData((Object)gd);
        this.fNameText.setFont(font);
        this.fNameText.addModifyListener(listener);
        this.fValueLabel = new Label(comp, 0);
        this.fValueLabel.setText(this.fFieldLabels[1]);
        this.fValueLabel.setFont(font);
        this.fValueText = new Text(comp, 2052);
        this.fValueText.setText(this.fInitialValues[1]);
        gd = new GridData(768);
        gd.widthHint = 300;
        this.fValueText.setLayoutData((Object)gd);
        this.fValueText.setFont(font);
        this.fValueText.addModifyListener(listener);
        Dialog.applyDialogFont((Control)comp);
        return comp;
    }

    public String[] getNameValuePair() {
        return new String[]{this.fName, this.fValue};
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.fName = this.fNameText.getText();
            this.fValue = this.fValueText.getText();
        } else {
            this.fName = null;
            this.fValue = null;
        }
        super.buttonPressed(buttonId);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.fTitle != null) {
            shell.setText(this.fTitle);
        }
    }

    protected void updateButtons() {
        String name = this.fNameText.getText().trim();
        String value = this.fValueText.getText().trim();
        this.getButton(0).setEnabled(name.length() > 0 && value.length() > 0);
    }

    public void create() {
        super.create();
        this.updateButtons();
    }
}

