/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.configurator;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IBundleGroup;
import org.eclipse.core.runtime.IBundleGroupProvider;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.update.configurator.IPlatformConfiguration;
import org.eclipse.update.internal.configurator.FeatureEntry;
import org.eclipse.update.internal.configurator.IConfigurationConstants;
import org.eclipse.update.internal.configurator.Messages;
import org.eclipse.update.internal.configurator.PlatformConfiguration;
import org.eclipse.update.internal.configurator.Utils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.startlevel.StartLevel;
import org.osgi.util.tracker.ServiceTracker;

public class ConfigurationActivator
implements BundleActivator,
IBundleGroupProvider,
IConfigurationConstants {
    public static String PI_CONFIGURATOR = "org.eclipse.update.configurator";
    public static final String INSTALL_LOCATION = "osgi.installLocation";
    public static final String LAST_CONFIG_STAMP = "last.config.stamp";
    public static final String NAME_SPACE = "org.eclipse.update";
    public static final String UPDATE_PREFIX = "update@";
    private static final String INITIAL_PREFIX = "initial@";
    public static String OPTION_DEBUG = String.valueOf(PI_CONFIGURATOR) + "/debug";
    public static boolean DEBUG = false;
    private static boolean isWindows = System.getProperty("os.name").startsWith("Win");
    private static BundleContext context;
    private ServiceTracker platformTracker;
    private ServiceRegistration configurationFactorySR;
    private PlatformConfiguration configuration;
    private static URL installURL;
    private Location configLocation;
    private long lastTimeStamp;
    private long lastStateTimeStamp;
    private static ConfigurationActivator configurator;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    public ConfigurationActivator() {
        configurator = this;
    }

    public void start(BundleContext ctx) throws Exception {
        context = ctx;
        this.loadOptions();
        this.acquireFrameworkLogService();
        this.initialize();
        if (this.canRunWithCachedData()) {
            Utils.debug("Running with cached data");
            Platform.registerBundleGroupProvider((IBundleGroupProvider)this);
            return;
        }
        Utils.debug("Starting update configurator...");
        this.installBundles();
        Platform.registerBundleGroupProvider((IBundleGroupProvider)this);
    }

    /*
     * Exception decompiling
     */
    private void initialize() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 5[TRYBLOCK] [4 : 288->292)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void stop(BundleContext ctx) throws Exception {
        try {
            PlatformConfiguration.shutdown();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.configurationFactorySR.unregister();
    }

    public boolean installBundles() {
        Utils.debug("Installing bundles...");
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.osgi.service.startlevel.StartLevel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ServiceReference reference = context.getServiceReference(clazz.getName());
        int startLevel = 4;
        String defaultStartLevel = System.getProperty("osgi.bundles.defaultStartLevel");
        if (defaultStartLevel != null) {
            try {
                startLevel = Integer.parseInt(defaultStartLevel);
            }
            catch (NumberFormatException numberFormatException) {
                startLevel = 4;
            }
        }
        if (startLevel < 1) {
            startLevel = 4;
        }
        StartLevel start = null;
        if (reference != null) {
            start = (StartLevel)context.getService(reference);
        }
        try {
            Bundle[] cachedBundles = context.getBundles();
            URL[] plugins = this.configuration.getPluginPath();
            Bundle[] bundlesToUninstall = this.getBundlesToUninstall(cachedBundles, plugins);
            int i = 0;
            while (i < bundlesToUninstall.length) {
                try {
                    if (DEBUG) {
                        Utils.debug("Uninstalling " + bundlesToUninstall[i].getLocation());
                    }
                    bundlesToUninstall[i].uninstall();
                }
                catch (Exception exception) {
                    Utils.log(Messages.getString("ConfigurationActivator.uninstallBundle", bundlesToUninstall[i].getLocation()));
                }
                ++i;
            }
            List toRefresh = this.getUnresolvedBundles();
            String[] bundlesToInstall = this.getBundlesToInstall(cachedBundles, plugins);
            int i2 = 0;
            while (i2 < bundlesToInstall.length) {
                block20: {
                    try {
                        if (DEBUG) {
                            Utils.debug("Installing " + bundlesToInstall[i2]);
                        }
                        URL bundleURL = new URL("reference:file:" + bundlesToInstall[i2]);
                        Bundle target = context.installBundle(UPDATE_PREFIX + bundlesToInstall[i2], bundleURL.openStream());
                        toRefresh.add(target);
                        if (start != null) {
                            start.setBundleStartLevel(target, startLevel);
                        }
                    }
                    catch (Exception e) {
                        if (Utils.isAutomaticallyStartedBundle(bundlesToInstall[i2])) break block20;
                        Utils.log(String.valueOf(Messages.getString("ConfigurationActivator.installBundle", bundlesToInstall[i2])) + "   " + e.getMessage());
                    }
                }
                ++i2;
            }
            context.ungetService(reference);
            this.removeInitialBundles(toRefresh, cachedBundles);
            this.refreshPackages(toRefresh.toArray(new Bundle[toRefresh.size()]));
            this.writePlatformConfigurationTimeStamp();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void removeInitialBundles(List bundles, Bundle[] cachedBundles) {
        String[] initialSymbolicNames = this.getInitialSymbolicNames(cachedBundles);
        Iterator iter = bundles.iterator();
        block0: while (iter.hasNext()) {
            Bundle bundle = (Bundle)iter.next();
            String symbolicName = bundle.getSymbolicName();
            int i = 0;
            while (i < initialSymbolicNames.length) {
                if (initialSymbolicNames[i].equals(symbolicName)) {
                    iter.remove();
                    continue block0;
                }
                ++i;
            }
        }
    }

    private String[] getInitialSymbolicNames(Bundle[] cachedBundles) {
        ArrayList<String> initial = new ArrayList<String>();
        int i = 0;
        while (i < cachedBundles.length) {
            String symbolicName;
            Bundle bundle = cachedBundles[i];
            if (bundle.getLocation().startsWith(INITIAL_PREFIX) && (symbolicName = bundle.getSymbolicName()) != null) {
                initial.add(symbolicName);
            }
            ++i;
        }
        return initial.toArray(new String[initial.size()]);
    }

    private List getUnresolvedBundles() {
        Bundle[] allBundles = context.getBundles();
        ArrayList<Bundle> unresolved = new ArrayList<Bundle>();
        int i = 0;
        while (i < allBundles.length) {
            if (allBundles[i].getState() == 2) {
                unresolved.add(allBundles[i]);
            }
            ++i;
        }
        return unresolved;
    }

    private String[] getBundlesToInstall(Bundle[] cachedBundles, URL[] newPlugins) {
        HashSet<String> cachedBundlesSet = new HashSet<String>(cachedBundles.length);
        int offset = UPDATE_PREFIX.length();
        int i = 0;
        while (i < cachedBundles.length) {
            String bundleLocation;
            if (cachedBundles[i].getBundleId() != 0L && (bundleLocation = cachedBundles[i].getLocation()).startsWith(UPDATE_PREFIX)) {
                bundleLocation = bundleLocation.substring(offset);
                cachedBundlesSet.add(bundleLocation);
                if (isWindows) {
                    cachedBundlesSet.add(bundleLocation.toLowerCase());
                }
            }
            ++i;
        }
        ArrayList<String> bundlesToInstall = new ArrayList<String>(newPlugins.length);
        int i2 = 0;
        while (i2 < newPlugins.length) {
            String location = newPlugins[i2].getFile();
            if (!(cachedBundlesSet.contains(location) || isWindows && cachedBundlesSet.contains(location.toLowerCase()))) {
                bundlesToInstall.add(location);
            }
            ++i2;
        }
        return bundlesToInstall.toArray(new String[bundlesToInstall.size()]);
    }

    private Bundle[] getBundlesToUninstall(Bundle[] cachedBundles, URL[] newPlugins) {
        HashSet<String> newPluginsSet = new HashSet<String>(newPlugins.length);
        int i = 0;
        while (i < newPlugins.length) {
            String pluginLocation = newPlugins[i].getFile();
            newPluginsSet.add(pluginLocation);
            if (isWindows) {
                newPluginsSet.add(pluginLocation.toLowerCase());
            }
            ++i;
        }
        ArrayList<Bundle> bundlesToUninstall = new ArrayList<Bundle>();
        int offset = UPDATE_PREFIX.length();
        int i2 = 0;
        while (i2 < cachedBundles.length) {
            String cachedBundleLocation;
            if (!(cachedBundles[i2].getBundleId() == 0L || !(cachedBundleLocation = cachedBundles[i2].getLocation()).startsWith(UPDATE_PREFIX) || newPluginsSet.contains(cachedBundleLocation = cachedBundleLocation.substring(offset)) || isWindows && newPluginsSet.contains(cachedBundleLocation.toLowerCase()))) {
                bundlesToUninstall.add(cachedBundles[i2]);
            }
            ++i2;
        }
        return bundlesToUninstall.toArray(new Bundle[bundlesToUninstall.size()]);
    }

    private PlatformConfiguration getPlatformConfiguration(URL installURL, Location configLocation) {
        block3: {
            try {
                PlatformConfiguration.startup(installURL, configLocation);
            }
            catch (Exception e) {
                if (this.platformTracker == null) break block3;
                String message = e.getMessage();
                if (message == null) {
                    message = "";
                }
                Utils.log(Utils.newStatus(message, e));
            }
        }
        return PlatformConfiguration.getCurrent();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void refreshPackages(Bundle[] bundles) {
        if (bundles.length == 0) {
            return;
        }
        Class<?> clazz = class$2;
        if (clazz == null) {
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("org.osgi.service.packageadmin.PackageAdmin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            clazz = class$2 = clazz2;
        }
        ServiceReference packageAdminRef = context.getServiceReference(clazz.getName());
        PackageAdmin packageAdmin = null;
        if (packageAdminRef != null && (packageAdmin = (PackageAdmin)context.getService(packageAdminRef)) == null) {
            return;
        }
        final boolean[] flag = new boolean[1];
        FrameworkListener listener = new FrameworkListener(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void frameworkEvent(FrameworkEvent event) {
                if (event.getType() != 4) return;
                boolean[] blArray = flag;
                synchronized (flag) {
                    flag[0] = true;
                    flag.notifyAll();
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }
        };
        context.addFrameworkListener(listener);
        packageAdmin.refreshPackages(bundles);
        boolean[] blArray = flag;
        synchronized (flag) {
            while (true) {
                if (flag[0]) {
                    // ** MonitorExit[var6_6] (shouldn't be in output)
                    break;
                }
                try {
                    flag.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            context.removeFrameworkListener(listener);
            context.ungetService(packageAdminRef);
            return;
        }
    }

    /*
     * Exception decompiling
     */
    private void writePlatformConfigurationTimeStamp() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [3 : 173->177)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadOptions() {
        ServiceReference reference;
        DebugOptions service = null;
        Class<?> clazz = class$3;
        if (clazz == null) {
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("org.eclipse.osgi.service.debug.DebugOptions");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            clazz = class$3 = clazz2;
        }
        if ((reference = context.getServiceReference(clazz.getName())) != null) {
            service = (DebugOptions)context.getService(reference);
        }
        if (service == null) {
            return;
        }
        try {
            DEBUG = service.getBooleanOption(OPTION_DEBUG, false);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            context.ungetService(reference);
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        context.ungetService(reference);
    }

    private boolean canRunWithCachedData() {
        return !"true".equals(System.getProperty("osgi.checkConfiguration")) && this.lastTimeStamp == this.configuration.getChangeStamp() && this.lastStateTimeStamp == Platform.getPlatformAdmin().getState(false).getTimeStamp();
    }

    public static BundleContext getBundleContext() {
        return context;
    }

    public static URL getInstallURL() {
        if (installURL == null) {
            installURL = Platform.getInstallLocation().getURL();
        }
        return installURL;
    }

    public String getName() {
        return Messages.getString("BundleGroupProvider");
    }

    public IBundleGroup[] getBundleGroups() {
        if (this.configuration == null) {
            return new IBundleGroup[0];
        }
        IPlatformConfiguration.IFeatureEntry[] features = this.configuration.getConfiguredFeatureEntries();
        ArrayList<IPlatformConfiguration.IFeatureEntry> bundleGroups = new ArrayList<IPlatformConfiguration.IFeatureEntry>(features.length);
        int i = 0;
        while (i < features.length) {
            if (features[i] instanceof FeatureEntry && ((FeatureEntry)features[i]).hasBranding()) {
                bundleGroups.add(features[i]);
            }
            ++i;
        }
        return bundleGroups.toArray(new IBundleGroup[bundleGroups.size()]);
    }

    public static void setConfigurator(ConfigurationActivator configurator) {
        ConfigurationActivator.configurator = configurator;
    }

    public static ConfigurationActivator getConfigurator() {
        return configurator;
    }

    private void acquireFrameworkLogService() throws Exception {
        ServiceReference logServiceReference;
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("org.eclipse.osgi.framework.log.FrameworkLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((logServiceReference = context.getServiceReference(clazz.getName())) == null) {
            return;
        }
        Utils.log = (FrameworkLog)context.getService(logServiceReference);
    }
}

