/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.client;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.ResponseHandler;
import org.eclipse.team.internal.ccvs.core.client.Session;
import org.eclipse.team.internal.ccvs.core.client.Update;
import org.eclipse.team.internal.ccvs.core.client.UpdatedHandler;
import org.eclipse.team.internal.ccvs.core.client.listeners.ICommandOutputListener;
import org.eclipse.team.internal.ccvs.core.client.listeners.IMessagePatterns;
import org.eclipse.team.internal.ccvs.core.client.listeners.IUpdateMessageListener;
import org.eclipse.team.internal.ccvs.core.client.listeners.ServerMessageLineMatcher;
import org.eclipse.team.internal.ccvs.core.client.listeners.UpdateListener;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;

public class UpdateMergableOnly
extends Update {
    private static final String LOCAL_FILE_PATH_VARIABLE_NAME = "localFilePath";
    private static ServerMessageLineMatcher MERGE_UPDATE_CONFLICTING_ADDITION_MATCHER;
    List skippedFiles = new ArrayList();

    static {
        UpdateMergableOnly.initializePatterns();
    }

    public static void initializePatterns() {
        try {
            MERGE_UPDATE_CONFLICTING_ADDITION_MATCHER = new ServerMessageLineMatcher(IMessagePatterns.MERGE_UPDATE_CONFLICTING_ADDITION, new String[]{LOCAL_FILE_PATH_VARIABLE_NAME});
        }
        catch (CVSException e) {
            CVSProviderPlugin.log((CoreException)((Object)e));
        }
    }

    protected IStatus doExecute(Session session, Command.GlobalOption[] globalOptions, Command.LocalOption[] localOptions, String[] arguments, ICommandOutputListener listener, IProgressMonitor monitor) throws CVSException {
        MergableOnlyUpdatedHandler newHandler = new MergableOnlyUpdatedHandler();
        ResponseHandler oldHandler = session.getResponseHandler(newHandler.getResponseID());
        this.skippedFiles.clear();
        try {
            session.registerResponseHandler(newHandler);
            session.setCreateBackups(false);
            IStatus iStatus = super.doExecute(session, globalOptions, localOptions, arguments, new MergeUpdateListener(null), monitor);
            Object var9_10 = null;
            session.registerResponseHandler(oldHandler);
            session.setCreateBackups(true);
            return iStatus;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            session.registerResponseHandler(oldHandler);
            session.setCreateBackups(true);
            throw throwable;
        }
    }

    public IFile[] getSkippedFiles() {
        return this.skippedFiles.toArray(new IFile[this.skippedFiles.size()]);
    }

    public class MergableOnlyUpdatedHandler
    extends UpdatedHandler {
        public MergableOnlyUpdatedHandler() {
            super(2);
        }

        protected ICVSFile getTargetFile(ICVSFolder mParent, String fileName, byte[] entryBytes) throws CVSException {
            String adjustedFileName = fileName;
            if (ResourceSyncInfo.isMergedWithConflicts(entryBytes)) {
                adjustedFileName = ".##" + adjustedFileName + " " + ResourceSyncInfo.getRevision(entryBytes);
                UpdateMergableOnly.this.skippedFiles.add(((IContainer)mParent.getIResource()).getFile((IPath)new Path(fileName)));
            }
            return super.getTargetFile(mParent, adjustedFileName, entryBytes);
        }

        protected void receiveTargetFile(Session session, ICVSFile mFile, String entryLine, Date modTime, boolean binary, boolean readOnly, IProgressMonitor monitor) throws CVSException {
            if (ResourceSyncInfo.isMergedWithConflicts(entryLine.getBytes())) {
                session.receiveFile(mFile, binary, 1, monitor);
                mFile.delete();
            } else {
                super.receiveTargetFile(session, mFile, entryLine, modTime, binary, readOnly, monitor);
            }
        }
    }

    public class MergeUpdateListener
    extends UpdateListener {
        public MergeUpdateListener(IUpdateMessageListener updateMessageListener) {
            super(updateMessageListener);
        }

        public IStatus errorLine(String line, ICVSRepositoryLocation location, ICVSFolder commandRoot, IProgressMonitor monitor) {
            Map variables = MERGE_UPDATE_CONFLICTING_ADDITION_MATCHER.processServerMessage(line);
            if (variables != null) {
                String filePath = (String)variables.get(UpdateMergableOnly.LOCAL_FILE_PATH_VARIABLE_NAME);
                try {
                    ICVSResource cvsResource = commandRoot.getChild(filePath);
                    IResource resource = cvsResource.getIResource();
                    if (resource != null && resource.getType() == 1) {
                        UpdateMergableOnly.this.skippedFiles.add(resource);
                        return ICommandOutputListener.OK;
                    }
                }
                catch (CVSException e) {
                    CVSProviderPlugin.log((CoreException)((Object)e));
                }
            }
            return super.errorLine(line, location, commandRoot, monitor);
        }
    }
}

