/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.client;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.client.ResponseHandler;
import org.eclipse.team.internal.ccvs.core.client.Session;
import org.eclipse.team.internal.ccvs.core.syncinfo.FolderSyncInfo;
import org.eclipse.team.internal.ccvs.core.util.Assert;

class StaticHandler
extends ResponseHandler {
    private final boolean setStaticDirectory;

    public StaticHandler(boolean setStaticDirectory) {
        this.setStaticDirectory = setStaticDirectory;
    }

    public String getResponseID() {
        if (this.setStaticDirectory) {
            return "Set-static-directory";
        }
        return "Clear-static-directory";
    }

    public void handle(Session session, String localDir, IProgressMonitor monitor) throws CVSException {
        String repositoryDir = session.readLine();
        Assert.isTrue(repositoryDir.endsWith("/"));
        repositoryDir = repositoryDir.substring(0, repositoryDir.length() - 1);
        ICVSFolder folder = ResponseHandler.createFolder(session, localDir, repositoryDir);
        FolderSyncInfo syncInfo = folder.getFolderSyncInfo();
        if (syncInfo == null) {
            return;
        }
        FolderSyncInfo newInfo = new FolderSyncInfo(syncInfo.getRepository(), syncInfo.getRoot(), syncInfo.getTag(), this.setStaticDirectory);
        if (!syncInfo.equals(newInfo)) {
            folder.setFolderSyncInfo(newInfo);
        }
    }
}

