/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.refactoring;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

class LaunchConfigProjectChange
extends Change {
    private ILaunchConfiguration fConfig;
    private String fNewName;

    public LaunchConfigProjectChange(ILaunchConfiguration config, String newName) {
        this.fConfig = config;
        this.fNewName = newName;
    }

    public String getName() {
        return this.fConfig.getName();
    }

    public void initializeValidationData(IProgressMonitor pm) {
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException {
        return new RefactoringStatus();
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        pm.beginTask("", 1);
        String oldProjectName = this.fConfig.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, null);
        ILaunchConfigurationWorkingCopy copy = this.fConfig.getWorkingCopy();
        copy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, this.fNewName);
        copy.doSave();
        pm.worked(1);
        return new LaunchConfigProjectChange(this.fConfig, oldProjectName);
    }

    public Object getModifiedElement() {
        return this.fConfig;
    }
}

