/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.util.Arrays;
import java.util.HashMap;
import org.eclipse.core.internal.events.BuildCommand;
import org.eclipse.core.internal.resources.LinkDescription;
import org.eclipse.core.internal.resources.ModelObject;
import org.eclipse.core.internal.utils.Assert;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.IPath;

public class ProjectDescription
extends ModelObject
implements IProjectDescription {
    private static final ICommand[] EMPTY_COMMAND_ARRAY = new ICommand[0];
    private static final IProject[] EMPTY_PROJECT_ARRAY = new IProject[0];
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    protected static boolean isReading = false;
    protected static boolean isWriting = false;
    protected ICommand[] buildSpec = EMPTY_COMMAND_ARRAY;
    protected IProject[] cachedRefs = null;
    protected String comment = "";
    protected IProject[] dynamicRefs = EMPTY_PROJECT_ARRAY;
    protected HashMap linkDescriptions = null;
    protected IPath location = null;
    protected String[] natures = EMPTY_STRING_ARRAY;
    protected IProject[] staticRefs = EMPTY_PROJECT_ARRAY;

    public Object clone() {
        ProjectDescription clone = (ProjectDescription)super.clone();
        clone.linkDescriptions = null;
        return clone;
    }

    private IProject[] copyAndRemoveDuplicates(IProject[] projects) {
        IProject[] result = new IProject[projects.length];
        int count = 0;
        int i = 0;
        while (i < projects.length) {
            IProject project = projects[i];
            boolean found = false;
            int j = 0;
            while (j < count) {
                if (project.equals(result[j])) {
                    found = true;
                }
                ++j;
            }
            if (!found) {
                result[count++] = project;
            }
            ++i;
        }
        if (count < projects.length) {
            IProject[] reduced = new IProject[count];
            System.arraycopy(result, 0, reduced, 0, count);
            return reduced;
        }
        return result;
    }

    public IProject[] getAllReferences(boolean makeCopy) {
        if (this.cachedRefs == null) {
            IProject[] statik = this.getReferencedProjects(false);
            IProject[] dynamic = this.getDynamicReferences(false);
            if (dynamic.length == 0) {
                this.cachedRefs = statik;
            } else if (statik.length == 0) {
                this.cachedRefs = dynamic;
            } else {
                IProject[] result = new IProject[dynamic.length + statik.length];
                System.arraycopy(statik, 0, result, 0, statik.length);
                System.arraycopy(dynamic, 0, result, statik.length, dynamic.length);
                this.cachedRefs = this.copyAndRemoveDuplicates(result);
            }
        }
        return makeCopy ? (IProject[])this.cachedRefs.clone() : this.cachedRefs;
    }

    public ICommand[] getBuildSpec() {
        return this.getBuildSpec(true);
    }

    public ICommand[] getBuildSpec(boolean makeCopy) {
        ICommand[] oldCommands = this.buildSpec;
        if (oldCommands == null) {
            return EMPTY_COMMAND_ARRAY;
        }
        if (!makeCopy) {
            return oldCommands;
        }
        ICommand[] result = new ICommand[oldCommands.length];
        int i = 0;
        while (i < result.length) {
            result[i] = (ICommand)((BuildCommand)oldCommands[i]).clone();
            ++i;
        }
        return result;
    }

    public String getComment() {
        return this.comment;
    }

    public IProject[] getDynamicReferences() {
        return this.getDynamicReferences(true);
    }

    public IProject[] getDynamicReferences(boolean makeCopy) {
        if (this.dynamicRefs == null) {
            return EMPTY_PROJECT_ARRAY;
        }
        return makeCopy ? (IProject[])this.dynamicRefs.clone() : this.dynamicRefs;
    }

    public IPath getLinkLocation(String name) {
        if (this.linkDescriptions == null) {
            return null;
        }
        LinkDescription desc = (LinkDescription)this.linkDescriptions.get(name);
        return desc == null ? null : desc.getLocation();
    }

    public HashMap getLinks() {
        return this.linkDescriptions;
    }

    public IPath getLocation() {
        return this.location;
    }

    public String[] getNatureIds() {
        return this.getNatureIds(true);
    }

    public String[] getNatureIds(boolean makeCopy) {
        if (this.natures == null) {
            return EMPTY_STRING_ARRAY;
        }
        return makeCopy ? (String[])this.natures.clone() : this.natures;
    }

    public IProject[] getReferencedProjects() {
        return this.getReferencedProjects(true);
    }

    public IProject[] getReferencedProjects(boolean makeCopy) {
        if (this.staticRefs == null) {
            return EMPTY_PROJECT_ARRAY;
        }
        return makeCopy ? (IProject[])this.staticRefs.clone() : this.staticRefs;
    }

    public boolean hasNature(String natureID) {
        String[] natureIDs = this.getNatureIds(false);
        int i = 0;
        while (i < natureIDs.length) {
            if (natureIDs[i].equals(natureID)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean hasPrivateChanges(ProjectDescription description) {
        if (!Arrays.equals(this.dynamicRefs, description.getDynamicReferences(false))) {
            return true;
        }
        IPath otherLocation = description.getLocation();
        if (this.location == null) {
            return otherLocation != null;
        }
        return !this.location.equals((Object)otherLocation);
    }

    public boolean hasPublicChanges(ProjectDescription description) {
        if (!this.getName().equals(description.getName())) {
            return true;
        }
        if (!this.comment.equals(description.getComment())) {
            return true;
        }
        if (!Arrays.equals(this.buildSpec, description.getBuildSpec(false))) {
            return true;
        }
        if (!Arrays.equals(this.staticRefs, description.getReferencedProjects(false))) {
            return true;
        }
        if (!Arrays.equals(this.natures, description.getNatureIds(false))) {
            return true;
        }
        HashMap otherLinks = description.getLinks();
        if (this.linkDescriptions == null) {
            return otherLinks != null;
        }
        return !this.linkDescriptions.equals(otherLinks);
    }

    public ICommand newCommand() {
        return new BuildCommand();
    }

    public void setBuildSpec(ICommand[] value) {
        Assert.isLegal(value != null);
        ICommand[] result = new ICommand[value.length];
        int i = 0;
        while (i < result.length) {
            result[i] = (ICommand)((BuildCommand)value[i]).clone();
            ++i;
        }
        this.buildSpec = result;
    }

    public void setComment(String value) {
        this.comment = value;
    }

    public void setDynamicReferences(IProject[] value) {
        Assert.isLegal(value != null);
        this.dynamicRefs = this.copyAndRemoveDuplicates(value);
        this.cachedRefs = null;
    }

    public void setLinkDescriptions(HashMap linkDescriptions) {
        this.linkDescriptions = linkDescriptions;
    }

    public void setLinkLocation(String name, LinkDescription description) {
        if (description != null) {
            if (this.linkDescriptions == null) {
                this.linkDescriptions = new HashMap(10);
            }
            this.linkDescriptions.put(name, description);
        } else if (this.linkDescriptions != null) {
            this.linkDescriptions.remove(name);
            if (this.linkDescriptions.size() == 0) {
                this.linkDescriptions = null;
            }
        }
    }

    public void setLocation(IPath location) {
        this.location = location;
    }

    public void setName(String value) {
        super.setName(value);
    }

    public void setNatureIds(String[] value) {
        this.natures = (String[])value.clone();
    }

    public void setReferencedProjects(IProject[] value) {
        Assert.isLegal(value != null);
        this.staticRefs = this.copyAndRemoveDuplicates(value);
        this.cachedRefs = null;
    }
}

