/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.core.hcr;

import java.util.ArrayList;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.InvalidInputException;

class JavaNode {
    public static final int CU = 0;
    public static final int PACKAGE = 1;
    public static final int IMPORT_CONTAINER = 2;
    public static final int IMPORT = 3;
    public static final int INTERFACE = 4;
    public static final int CLASS = 5;
    public static final int FIELD = 6;
    public static final int INIT = 7;
    public static final int CONSTRUCTOR = 8;
    public static final int METHOD = 9;
    private String fID;
    private int fTypeCode;
    private char[] fBuffer;
    private int fStart;
    private int fLength;
    private ArrayList fChildren;
    private int fInitializerCount = 1;

    JavaNode(int typeCode, String id, char[] buffer, int start, int length) {
        this.fTypeCode = typeCode;
        this.fID = id;
        this.fBuffer = buffer;
        this.fStart = start;
        this.fLength = length;
    }

    JavaNode(JavaNode parent, int type, String name, int start, int length) {
        this(type, JavaNode.buildID(type, name), parent.fBuffer, start, length);
        if (parent != null) {
            parent.addChild(this);
        }
    }

    JavaNode(char[] buffer) {
        this(0, JavaNode.buildID(0, "root"), buffer, 0, buffer.length);
    }

    private static String buildID(int type, String name) {
        StringBuffer sb = new StringBuffer();
        switch (type) {
            case 0: {
                sb.append('{');
                break;
            }
            case 4: 
            case 5: {
                sb.append('[');
                sb.append(name);
                break;
            }
            case 6: {
                sb.append('^');
                sb.append(name);
                break;
            }
            case 8: 
            case 9: {
                sb.append('~');
                sb.append(name);
                break;
            }
            case 7: {
                sb.append('|');
                sb.append(name);
                break;
            }
            case 1: {
                sb.append('%');
                break;
            }
            case 3: {
                sb.append('#');
                sb.append(name);
                break;
            }
            case 2: {
                sb.append('<');
                break;
            }
        }
        return sb.toString();
    }

    public String getInitializerCount() {
        return Integer.toString(this.fInitializerCount++);
    }

    public int getStart() {
        return this.fStart;
    }

    public int getTypeCode() {
        return this.fTypeCode;
    }

    public String getId() {
        return this.fID;
    }

    public void setId(String id) {
        this.fID = id;
    }

    public void addChild(JavaNode node) {
        if (this.fChildren == null) {
            this.fChildren = new ArrayList();
        }
        this.fChildren.add(node);
    }

    public Object[] getChildren() {
        if (this.fChildren != null) {
            return this.fChildren.toArray();
        }
        return null;
    }

    public void setLength(int length) {
        this.fLength = length;
    }

    public boolean equals(Object other) {
        if (other != null && other.getClass() == this.getClass()) {
            JavaNode tn = (JavaNode)other;
            return this.fTypeCode == tn.fTypeCode && this.fID.equals(tn.fID);
        }
        return super.equals(other);
    }

    public int hashCode() {
        return this.fID.hashCode();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getContents() {
        b = new char[this.fLength];
        System.arraycopy(this.fBuffer, this.fStart, b, 0, this.fLength);
        ignoreWhiteSpace = true;
        if (ignoreWhiteSpace) {
            buf = new StringBuffer();
            scanner = ToolFactory.createScanner((boolean)true, (boolean)true, (boolean)false, (boolean)false);
            scanner.setSource(b);
            try {
                block5: while (true) lbl-1000:
                // 4 sources

                {
                    if ((token = scanner.getNextToken()) == 158) {
                        return buf.toString();
                    }
                    switch (token) {
                        case 1000: 
                        case 1001: 
                        case 1002: 
                        case 1003: {
                            l = buf.length();
                            if (l <= 0 || buf.charAt(l - 1) == ' ') continue block5;
                            buf.append(' ');
                            ** break;
                        }
                    }
                    buf.append(b, scanner.getCurrentTokenStartPosition(), scanner.getCurrentTokenEndPosition() + 1 - scanner.getCurrentTokenStartPosition());
                    buf.append(' ');
                }
            }
            catch (InvalidInputException v0) {}
        }
        return new String(b);
    }
}

