/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdi.internal.connect;

import com.sun.jdi.VMDisconnectedException;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.LinkedList;
import org.eclipse.jdi.internal.connect.ConnectMessages;
import org.eclipse.jdi.internal.connect.ConnectorImpl;
import org.eclipse.jdi.internal.connect.PacketManager;
import org.eclipse.jdi.internal.jdwp.JdwpPacket;

public class PacketSendManager
extends PacketManager {
    private OutputStream fOutStream;
    private LinkedList fOutgoingPackets;

    public PacketSendManager(ConnectorImpl connector) {
        super(connector);
        try {
            this.fOutStream = connector.getOutputStream();
            this.fOutgoingPackets = new LinkedList();
        }
        catch (IOException e) {
            this.disconnectVM(e);
        }
    }

    public void run() {
        while (!this.VMIsDisconnected()) {
            try {
                this.sendAvailablePackets();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InterruptedIOException interruptedIOException) {
            }
            catch (IOException e) {
                this.disconnectVM(e);
            }
        }
    }

    public synchronized void sendPacket(JdwpPacket packet) {
        if (this.VMIsDisconnected()) {
            String exMessage;
            String message = this.getDisconnectException() == null ? ConnectMessages.getString("PacketSendManager.Got_IOException_from_Virtual_Machine_1") : ((exMessage = this.getDisconnectException().getMessage()) == null ? MessageFormat.format(ConnectMessages.getString("PacketSendManager.Got_{0}_from_Virtual_Machine_1"), this.getDisconnectException().getClass().getName()) : MessageFormat.format(ConnectMessages.getString("PacketSendManager.Got_{0}_from_Virtual_Machine__{1}_1"), this.getDisconnectException().getClass().getName(), exMessage));
            throw new VMDisconnectedException(message);
        }
        this.fOutgoingPackets.add(packet);
        this.notifyAll();
    }

    private synchronized void sendAvailablePackets() throws InterruptedException, IOException {
        while (this.fOutgoingPackets.size() == 0) {
            this.wait();
        }
        while (this.fOutgoingPackets.size() > 0) {
            JdwpPacket packet = (JdwpPacket)this.fOutgoingPackets.removeFirst();
            BufferedOutputStream bufferOutStream = new BufferedOutputStream(this.fOutStream, packet.getLength());
            packet.write(bufferOutStream);
            bufferOutStream.flush();
        }
    }
}

