/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.core.subscribers;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.ITeamStatus;
import org.eclipse.team.core.synchronize.ISyncInfoSetChangeEvent;
import org.eclipse.team.core.synchronize.ISyncInfoSetChangeListener;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.synchronize.SyncInfoSet;
import org.eclipse.team.internal.core.Policy;
import org.eclipse.team.internal.core.subscribers.SubscriberEventHandler;
import org.eclipse.team.internal.core.subscribers.SubscriberSyncInfoSet;
import org.eclipse.team.internal.core.subscribers.SyncSetInput;

public class SyncSetInputFromSyncSet
extends SyncSetInput
implements ISyncInfoSetChangeListener {
    SubscriberSyncInfoSet inputSyncSet;

    public SyncSetInputFromSyncSet(SubscriberSyncInfoSet set, SubscriberEventHandler handler) {
        super(handler);
        this.inputSyncSet = set;
        this.inputSyncSet.addSyncSetChangedListener(this);
    }

    public SyncInfoSet getInputSyncSet() {
        return this.inputSyncSet;
    }

    public void disconnect() {
        if (this.inputSyncSet == null) {
            return;
        }
        this.inputSyncSet.removeSyncSetChangedListener(this);
        this.inputSyncSet = null;
    }

    protected void fetchInput(IProgressMonitor monitor) {
        if (this.inputSyncSet == null) {
            return;
        }
        SyncInfo[] infos = this.inputSyncSet.getSyncInfos();
        int i = 0;
        while (i < infos.length) {
            this.collect(infos[i], monitor);
            ++i;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void syncInfoChanged(ISyncInfoSetChangeEvent event, IProgressMonitor monitor) {
        SubscriberSyncInfoSet syncSet = this.getSyncSet();
        try {
            syncSet.beginInput();
            monitor.beginTask(null, 105);
            this.syncSetChanged(event.getChangedResources(), Policy.subMonitorFor(monitor, 50));
            this.syncSetChanged(event.getAddedResources(), Policy.subMonitorFor(monitor, 50));
            this.remove(event.getRemovedResources());
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            syncSet.endInput(Policy.subMonitorFor(monitor, 5));
            throw throwable;
        }
        {
            Object var4_6 = null;
            syncSet.endInput(Policy.subMonitorFor(monitor, 5));
            return;
        }
    }

    private void syncSetChanged(SyncInfo[] infos, IProgressMonitor monitor) {
        int i = 0;
        while (i < infos.length) {
            this.collect(infos[i], monitor);
            ++i;
        }
    }

    private void remove(IResource[] resources) {
        int i = 0;
        while (i < resources.length) {
            this.remove(resources[i]);
            ++i;
        }
    }

    public void reset() {
        this.inputSyncSet.connect(this);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void syncInfoSetReset(SyncInfoSet set, IProgressMonitor monitor) {
        if (this.inputSyncSet == null) {
            set.removeSyncSetChangedListener(this);
            return;
        }
        SubscriberSyncInfoSet syncSet = this.getSyncSet();
        try {
            syncSet.beginInput();
            monitor.beginTask(null, 100);
            ((SyncInfoSet)syncSet).clear();
            this.fetchInput(Policy.subMonitorFor(monitor, 95));
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            syncSet.endInput(Policy.subMonitorFor(monitor, 5));
            monitor.done();
            throw throwable;
        }
        {
            Object var4_6 = null;
            syncSet.endInput(Policy.subMonitorFor(monitor, 5));
        }
        monitor.done();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void syncInfoSetErrors(SyncInfoSet set, ITeamStatus[] errors, IProgressMonitor monitor) {
        SubscriberSyncInfoSet syncSet = this.getSyncSet();
        try {
            syncSet.beginInput();
            int i = 0;
            while (i < errors.length) {
                ITeamStatus status = errors[i];
                syncSet.addError(status);
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            syncSet.endInput(monitor);
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        syncSet.endInput(monitor);
    }
}

