/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.texteditor;

import java.util.Iterator;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationRulerColumn;
import org.eclipse.jface.text.source.ChangeRulerColumn;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.jface.text.source.IChangeRulerColumn;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.ISourceViewerExtension;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.LineChangeHover;
import org.eclipse.jface.text.source.LineNumberChangeRulerColumn;
import org.eclipse.jface.text.source.LineNumberRulerColumn;
import org.eclipse.jface.text.source.OverviewRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.editors.text.ForwardingDocumentProvider;
import org.eclipse.ui.editors.text.ITextEditorHelpContextIds;
import org.eclipse.ui.ide.IDEActionFactory;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.internal.texteditor.TextChangeHover;
import org.eclipse.ui.internal.texteditor.quickdiff.DocumentLineDiffer;
import org.eclipse.ui.texteditor.AbstractMarkerAnnotationModel;
import org.eclipse.ui.texteditor.AddMarkerAction;
import org.eclipse.ui.texteditor.AddTaskAction;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.AnnotationPreferenceLookup;
import org.eclipse.ui.texteditor.DefaultMarkerAnnotationAccess;
import org.eclipse.ui.texteditor.DefaultRangeIndicator;
import org.eclipse.ui.texteditor.DocumentProviderRegistry;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.MarkerAnnotationPreferences;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;
import org.eclipse.ui.texteditor.StatusTextEditor;
import org.eclipse.ui.texteditor.TextEditorMessages;
import org.eclipse.ui.texteditor.quickdiff.QuickDiff;

public abstract class AbstractDecoratedTextEditor
extends StatusTextEditor {
    private static final String LINE_NUMBER_RULER = "lineNumberRuler";
    private static final String LINE_NUMBER_COLOR = "lineNumberColor";
    private static final String OVERVIEW_RULER = "overviewRuler";
    private static final String CURRENT_LINE = "currentLine";
    private static final String CURRENT_LINE_COLOR = "currentLineColor";
    private static final String PRINT_MARGIN = "printMargin";
    private static final String PRINT_MARGIN_COLOR = "printMarginColor";
    private static final String PRINT_MARGIN_COLUMN = "printMarginColumn";
    private MarkerAnnotationPreferences fAnnotationPreferences;
    protected IOverviewRuler fOverviewRuler;
    protected IAnnotationAccess fAnnotationAccess;
    protected SourceViewerDecorationSupport fSourceViewerDecorationSupport;
    protected LineNumberRulerColumn fLineNumberRulerColumn;
    private IChangeRulerColumn fChangeRulerColumn;
    private boolean fIsChangeInformationShown;
    private AnnotationRulerColumn fAnnotationRulerColumn;
    private IDocumentProvider fImplicitDocumentProvider;
    private Object fGotoMarkerAdapter = new GotoMarkerAdapter();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public AbstractDecoratedTextEditor() {
        this.fAnnotationPreferences = new MarkerAnnotationPreferences();
        this.setRangeIndicator((Annotation)new DefaultRangeIndicator());
        this.initializeKeyBindingScopes();
        this.initializeEditor();
    }

    protected void initializeEditor() {
        this.setPreferenceStore(EditorsPlugin.getDefault().getPreferenceStore());
    }

    protected void initializeKeyBindingScopes() {
        this.setKeyBindingScopes(new String[]{"org.eclipse.ui.textEditorScope"});
    }

    public void dispose() {
        if (this.fSourceViewerDecorationSupport != null) {
            this.fSourceViewerDecorationSupport.dispose();
            this.fSourceViewerDecorationSupport = null;
        }
        this.fAnnotationAccess = null;
        this.fAnnotationPreferences = null;
        this.fAnnotationRulerColumn = null;
        super.dispose();
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        this.fAnnotationAccess = this.createAnnotationAccess();
        this.fOverviewRuler = this.createOverviewRuler(this.getSharedColors());
        SourceViewer viewer = new SourceViewer(parent, ruler, this.getOverviewRuler(), this.isOverviewRulerVisible(), styles);
        this.getSourceViewerDecorationSupport((ISourceViewer)viewer);
        return viewer;
    }

    protected ISharedTextColors getSharedColors() {
        ISharedTextColors sharedColors = EditorsPlugin.getDefault().getSharedTextColors();
        return sharedColors;
    }

    protected IOverviewRuler createOverviewRuler(ISharedTextColors sharedColors) {
        OverviewRuler ruler = new OverviewRuler(this.getAnnotationAccess(), 12, sharedColors);
        Iterator e = this.fAnnotationPreferences.getAnnotationPreferences().iterator();
        while (e.hasNext()) {
            AnnotationPreference preference = (AnnotationPreference)e.next();
            if (!preference.contributesToHeader()) continue;
            ruler.addHeaderAnnotationType(preference.getAnnotationType());
        }
        return ruler;
    }

    protected IAnnotationAccess createAnnotationAccess() {
        return new DefaultMarkerAnnotationAccess();
    }

    protected void configureSourceViewerDecorationSupport(SourceViewerDecorationSupport support) {
        Iterator e = this.fAnnotationPreferences.getAnnotationPreferences().iterator();
        while (e.hasNext()) {
            support.setAnnotationPreference((AnnotationPreference)e.next());
        }
        support.setCursorLinePainterPreferenceKeys(CURRENT_LINE, CURRENT_LINE_COLOR);
        support.setMarginPainterPreferenceKeys(PRINT_MARGIN, PRINT_MARGIN_COLOR, PRINT_MARGIN_COLUMN);
        support.setSymbolicFontName(this.getFontPropertyPreferenceKey());
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        if (this.fSourceViewerDecorationSupport != null) {
            this.fSourceViewerDecorationSupport.install(this.getPreferenceStore());
        }
        if (this.isPrefQuickDiffAlwaysOn()) {
            this.showChangeInformation(true);
        }
    }

    protected boolean isOverviewRulerVisible() {
        IPreferenceStore store = this.getPreferenceStore();
        return store != null ? store.getBoolean(OVERVIEW_RULER) : false;
    }

    public void showChangeInformation(boolean show) {
        if (show == this.fIsChangeInformationShown) {
            return;
        }
        if (this.fIsChangeInformationShown) {
            this.uninstallChangeRulerModel();
            this.showChangeRuler(false);
        } else {
            this.ensureChangeInfoCanBeDisplayed();
            this.installChangeRulerModel();
        }
        this.fIsChangeInformationShown = this.getChangeColumn() != null && this.getChangeColumn().getModel() != null;
    }

    private void installChangeRulerModel() {
        IOverviewRuler ruler;
        IChangeRulerColumn column = this.getChangeColumn();
        if (column != null) {
            column.setModel(this.getOrCreateDiffer());
        }
        if ((ruler = this.getOverviewRuler()) != null) {
            ruler.addAnnotationType((Object)"org.eclipse.ui.workbench.texteditor.quickdiffChange");
            ruler.addAnnotationType((Object)"org.eclipse.ui.workbench.texteditor.quickdiffAddition");
            ruler.addAnnotationType((Object)"org.eclipse.ui.workbench.texteditor.quickdiffDeletion");
            ruler.update();
        }
    }

    private void uninstallChangeRulerModel() {
        IAnnotationModel model;
        IOverviewRuler ruler;
        IChangeRulerColumn column = this.getChangeColumn();
        if (column != null) {
            column.setModel(null);
        }
        if ((ruler = this.getOverviewRuler()) != null) {
            ruler.removeAnnotationType((Object)"org.eclipse.ui.workbench.texteditor.quickdiffChange");
            ruler.removeAnnotationType((Object)"org.eclipse.ui.workbench.texteditor.quickdiffAddition");
            ruler.removeAnnotationType((Object)"org.eclipse.ui.workbench.texteditor.quickdiffDeletion");
            ruler.update();
        }
        if ((model = this.getDiffer()) instanceof DocumentLineDiffer) {
            ((DocumentLineDiffer)model).suspend();
        }
    }

    private void ensureChangeInfoCanBeDisplayed() {
        if (this.isLineNumberRulerVisible()) {
            if (!(this.fLineNumberRulerColumn instanceof IChangeRulerColumn)) {
                this.hideLineNumberRuler();
                this.fIsChangeInformationShown = true;
                this.showLineNumberRuler();
            }
        } else {
            this.showChangeRuler(true);
        }
    }

    public boolean isChangeInformationShowing() {
        return this.fIsChangeInformationShown;
    }

    /*
     * WARNING - void declaration
     */
    private IAnnotationModel getOrCreateDiffer() {
        IAnnotationModel differ = this.getDiffer();
        if (differ == null) {
            String defaultId;
            IPreferenceStore store = this.getPreferenceStore();
            if (store != null && (differ = new QuickDiff().createQuickDiffAnnotationModel((ITextEditor)this, defaultId = store.getString("quickdiff.defaultProvider"))) != null) {
                void var6_6;
                ISourceViewer viewer = this.getSourceViewer();
                if (viewer == null) {
                    return null;
                }
                IAnnotationModel m = viewer.getAnnotationModel();
                if (!(m instanceof IAnnotationModelExtension)) {
                    return null;
                }
                IAnnotationModelExtension model = (IAnnotationModelExtension)m;
                var6_6.addAnnotationModel((Object)"diff", differ);
            }
        } else if (differ instanceof DocumentLineDiffer && !this.fIsChangeInformationShown) {
            ((DocumentLineDiffer)differ).resume();
        }
        return differ;
    }

    /*
     * WARNING - void declaration
     */
    private IAnnotationModel getDiffer() {
        void var3_3;
        ISourceViewer viewer = this.getSourceViewer();
        if (viewer == null) {
            return null;
        }
        IAnnotationModel m = viewer.getAnnotationModel();
        if (!(m instanceof IAnnotationModelExtension)) {
            return null;
        }
        IAnnotationModelExtension model = (IAnnotationModelExtension)m;
        return var3_3.getAnnotationModel((Object)"diff");
    }

    private IChangeRulerColumn getChangeColumn() {
        if (this.fChangeRulerColumn != null) {
            return this.fChangeRulerColumn;
        }
        if (this.fLineNumberRulerColumn instanceof IChangeRulerColumn) {
            return (IChangeRulerColumn)this.fLineNumberRulerColumn;
        }
        return null;
    }

    private void showChangeRuler(boolean show) {
        IVerticalRuler v = this.getVerticalRuler();
        if (v instanceof CompositeRuler) {
            CompositeRuler c = (CompositeRuler)v;
            if (show && this.fChangeRulerColumn == null) {
                c.addDecorator(1, (IVerticalRulerColumn)this.createChangeRulerColumn());
            } else if (!show && this.fChangeRulerColumn != null) {
                c.removeDecorator((IVerticalRulerColumn)this.fChangeRulerColumn);
                this.fChangeRulerColumn = null;
            }
        }
    }

    private void showLineNumberRuler() {
        IVerticalRuler v;
        this.showChangeRuler(false);
        if (this.fLineNumberRulerColumn == null && (v = this.getVerticalRuler()) instanceof CompositeRuler) {
            CompositeRuler c = (CompositeRuler)v;
            c.addDecorator(1, this.createLineNumberRulerColumn());
        }
    }

    private void hideLineNumberRuler() {
        if (this.fLineNumberRulerColumn != null) {
            IVerticalRuler v = this.getVerticalRuler();
            if (v instanceof CompositeRuler) {
                CompositeRuler c = (CompositeRuler)v;
                c.removeDecorator((IVerticalRulerColumn)this.fLineNumberRulerColumn);
            }
            this.fLineNumberRulerColumn = null;
        }
        if (this.fIsChangeInformationShown) {
            this.showChangeRuler(true);
        }
    }

    protected boolean isLineNumberRulerVisible() {
        IPreferenceStore store = this.getPreferenceStore();
        return store != null ? store.getBoolean(LINE_NUMBER_RULER) : false;
    }

    protected boolean isPrefQuickDiffAlwaysOn() {
        IPreferenceStore store = this.getPreferenceStore();
        return store != null ? store.getBoolean("quickdiff.quickDiff") : false;
    }

    protected void initializeLineNumberRulerColumn(LineNumberRulerColumn rulerColumn) {
        ISharedTextColors sharedColors = this.getSharedColors();
        IPreferenceStore store = this.getPreferenceStore();
        if (store != null) {
            RGB rgb = null;
            if (store.contains(LINE_NUMBER_COLOR)) {
                rgb = store.isDefault(LINE_NUMBER_COLOR) ? PreferenceConverter.getDefaultColor((IPreferenceStore)store, (String)LINE_NUMBER_COLOR) : PreferenceConverter.getColor((IPreferenceStore)store, (String)LINE_NUMBER_COLOR);
            }
            if (rgb == null) {
                rgb = new RGB(0, 0, 0);
            }
            rulerColumn.setForeground(sharedColors.getColor(rgb));
            rgb = null;
            if (!store.getBoolean("AbstractTextEditor.Color.Background.SystemDefault") && store.contains("AbstractTextEditor.Color.Background")) {
                rgb = store.isDefault("AbstractTextEditor.Color.Background") ? PreferenceConverter.getDefaultColor((IPreferenceStore)store, (String)"AbstractTextEditor.Color.Background") : PreferenceConverter.getColor((IPreferenceStore)store, (String)"AbstractTextEditor.Color.Background");
            }
            rulerColumn.setBackground(sharedColors.getColor(rgb));
            rulerColumn.redraw();
        }
    }

    private void initializeChangeRulerColumn(IChangeRulerColumn changeColumn) {
        ISharedTextColors sharedColors = this.getSharedColors();
        IPreferenceStore store = this.getPreferenceStore();
        if (store != null) {
            ISourceViewer v = this.getSourceViewer();
            if (v != null && v.getAnnotationModel() != null) {
                changeColumn.setModel(v.getAnnotationModel());
            }
            Iterator iter = this.fAnnotationPreferences.getAnnotationPreferences().iterator();
            while (iter.hasNext()) {
                RGB rgb;
                AnnotationPreference pref = (AnnotationPreference)iter.next();
                if ("org.eclipse.ui.workbench.texteditor.quickdiffChange".equals(pref.getAnnotationType())) {
                    rgb = this.getColorPreference(store, pref);
                    changeColumn.setChangedColor(sharedColors.getColor(rgb));
                    continue;
                }
                if ("org.eclipse.ui.workbench.texteditor.quickdiffAddition".equals(pref.getAnnotationType())) {
                    rgb = this.getColorPreference(store, pref);
                    changeColumn.setAddedColor(sharedColors.getColor(rgb));
                    continue;
                }
                if (!"org.eclipse.ui.workbench.texteditor.quickdiffDeletion".equals(pref.getAnnotationType())) continue;
                rgb = this.getColorPreference(store, pref);
                changeColumn.setDeletedColor(sharedColors.getColor(rgb));
            }
            RGB rgb = null;
            if (!store.getBoolean("AbstractTextEditor.Color.Background.SystemDefault") && store.contains("AbstractTextEditor.Color.Background")) {
                rgb = store.isDefault("AbstractTextEditor.Color.Background") ? PreferenceConverter.getDefaultColor((IPreferenceStore)store, (String)"AbstractTextEditor.Color.Background") : PreferenceConverter.getColor((IPreferenceStore)store, (String)"AbstractTextEditor.Color.Background");
            }
            changeColumn.setBackground(sharedColors.getColor(rgb));
            if (changeColumn instanceof LineNumberChangeRulerColumn) {
                LineNumberChangeRulerColumn lncrc = (LineNumberChangeRulerColumn)changeColumn;
                lncrc.setDisplayMode(store.getBoolean("quickdiff.characterMode"));
            }
        }
        changeColumn.redraw();
    }

    private RGB getColorPreference(IPreferenceStore store, AnnotationPreference pref) {
        RGB rgb = null;
        if (store.contains(pref.getColorPreferenceKey())) {
            rgb = store.isDefault(pref.getColorPreferenceKey()) ? pref.getColorPreferenceValue() : PreferenceConverter.getColor((IPreferenceStore)store, (String)pref.getColorPreferenceKey());
        }
        if (rgb == null) {
            rgb = pref.getColorPreferenceValue();
        }
        return rgb;
    }

    protected IVerticalRulerColumn createLineNumberRulerColumn() {
        if (this.isPrefQuickDiffAlwaysOn() || this.isChangeInformationShowing()) {
            LineNumberChangeRulerColumn column = new LineNumberChangeRulerColumn(this.getSharedColors());
            column.setHover((IAnnotationHover)this.createChangeHover());
            this.initializeChangeRulerColumn((IChangeRulerColumn)column);
            this.fLineNumberRulerColumn = column;
        } else {
            this.fLineNumberRulerColumn = new LineNumberRulerColumn();
        }
        this.initializeLineNumberRulerColumn(this.fLineNumberRulerColumn);
        return this.fLineNumberRulerColumn;
    }

    protected LineChangeHover createChangeHover() {
        return new TextChangeHover();
    }

    protected IChangeRulerColumn createChangeRulerColumn() {
        ChangeRulerColumn column = new ChangeRulerColumn();
        column.setHover((IAnnotationHover)this.createChangeHover());
        this.fChangeRulerColumn = column;
        this.initializeChangeRulerColumn(this.fChangeRulerColumn);
        return this.fChangeRulerColumn;
    }

    protected IVerticalRuler createVerticalRuler() {
        CompositeRuler ruler = this.createCompositeRuler();
        IPreferenceStore store = this.getPreferenceStore();
        if (ruler != null && store != null) {
            Iterator iter = ruler.getDecoratorIterator();
            while (iter.hasNext()) {
                IVerticalRulerColumn column = (IVerticalRulerColumn)iter.next();
                if (!(column instanceof AnnotationRulerColumn)) continue;
                this.fAnnotationRulerColumn = (AnnotationRulerColumn)column;
                Iterator iter2 = this.fAnnotationPreferences.getAnnotationPreferences().iterator();
                while (iter2.hasNext()) {
                    AnnotationPreference preference = (AnnotationPreference)iter2.next();
                    String key = preference.getVerticalRulerPreferenceKey();
                    boolean showAnnotation = true;
                    if (key != null && store.contains(key)) {
                        showAnnotation = store.getBoolean(key);
                    }
                    if (!showAnnotation) continue;
                    this.fAnnotationRulerColumn.addAnnotationType(preference.getAnnotationType());
                }
                this.fAnnotationRulerColumn.addAnnotationType((Object)"org.eclipse.text.annotation.unknown");
                break;
            }
        }
        return ruler;
    }

    protected CompositeRuler createCompositeRuler() {
        CompositeRuler ruler = new CompositeRuler();
        ruler.addDecorator(0, (IVerticalRulerColumn)new AnnotationRulerColumn(12, this.getAnnotationAccess()));
        if (this.isLineNumberRulerVisible()) {
            ruler.addDecorator(1, this.createLineNumberRulerColumn());
        } else if (this.isPrefQuickDiffAlwaysOn()) {
            ruler.addDecorator(1, (IVerticalRulerColumn)this.createChangeRulerColumn());
        }
        return ruler;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        block22: {
            block21: {
                block20: {
                    block19: {
                        block18: {
                            try {
                                AnnotationPreference annotationPreference;
                                String annotationType;
                                Object type;
                                IChangeRulerColumn column;
                                AnnotationPreference pref;
                                ISourceViewer sourceViewer = this.getSourceViewer();
                                if (sourceViewer == null) {
                                    Object var8_3 = null;
                                    break block18;
                                }
                                String property = event.getProperty();
                                if (this.fSourceViewerDecorationSupport != null && this.fOverviewRuler != null && OVERVIEW_RULER.equals(property)) {
                                    if (this.isOverviewRulerVisible()) {
                                        this.showOverviewRuler();
                                        break block19;
                                    } else {
                                        this.hideOverviewRuler();
                                    }
                                    break block19;
                                }
                                if (LINE_NUMBER_RULER.equals(property)) {
                                    if (this.isLineNumberRulerVisible()) {
                                        this.showLineNumberRuler();
                                        break block20;
                                    } else {
                                        this.hideLineNumberRuler();
                                    }
                                    break block20;
                                }
                                if ("tabWidth".equals(property)) {
                                    sourceViewer.getTextWidget().setTabs(this.getPreferenceStore().getInt("tabWidth"));
                                    break block21;
                                }
                                if (this.fLineNumberRulerColumn != null && (LINE_NUMBER_COLOR.equals(property) || "AbstractTextEditor.Color.Background.SystemDefault".equals(property) || "AbstractTextEditor.Color.Background".equals(property))) {
                                    this.initializeLineNumberRulerColumn(this.fLineNumberRulerColumn);
                                }
                                if (this.fChangeRulerColumn != null && (LINE_NUMBER_COLOR.equals(property) || "AbstractTextEditor.Color.Background.SystemDefault".equals(property) || "AbstractTextEditor.Color.Background".equals(property))) {
                                    this.initializeChangeRulerColumn(this.fChangeRulerColumn);
                                }
                                if (this.fLineNumberRulerColumn instanceof LineNumberChangeRulerColumn && "quickdiff.characterMode".equals(property)) {
                                    this.initializeChangeRulerColumn(this.getChangeColumn());
                                }
                                if ((pref = this.getAnnotationPreference(property)) != null && (column = this.getChangeColumn()) != null && (type = pref.getAnnotationType()) instanceof String && (annotationType = (String)type).startsWith("org.eclipse.ui.workbench.texteditor.quickdiff")) {
                                    this.initializeChangeRulerColumn(column);
                                }
                                if ((annotationPreference = this.getVerticalRulerAnnotationPreference(property)) != null && event.getNewValue() instanceof Boolean) {
                                    type = annotationPreference.getAnnotationType();
                                    if (((Boolean)event.getNewValue()).booleanValue()) {
                                        this.fAnnotationRulerColumn.addAnnotationType(type);
                                    } else {
                                        this.fAnnotationRulerColumn.removeAnnotationType(type);
                                    }
                                    this.getVerticalRuler().update();
                                }
                                break block22;
                            }
                            catch (Throwable throwable) {
                                Object var8_7 = null;
                                super.handlePreferenceStoreChanged(event);
                                throw throwable;
                            }
                        }
                        super.handlePreferenceStoreChanged(event);
                        return;
                    }
                    Object var8_4 = null;
                    super.handlePreferenceStoreChanged(event);
                    return;
                }
                Object var8_5 = null;
                super.handlePreferenceStoreChanged(event);
                return;
            }
            Object var8_6 = null;
            super.handlePreferenceStoreChanged(event);
            return;
        }
        Object var8_8 = null;
        super.handlePreferenceStoreChanged(event);
    }

    private AnnotationPreference getAnnotationPreference(String colorKey) {
        Iterator iter = this.fAnnotationPreferences.getAnnotationPreferences().iterator();
        while (iter.hasNext()) {
            AnnotationPreference pref = (AnnotationPreference)iter.next();
            if (!colorKey.equals(pref.getColorPreferenceKey())) continue;
            return pref;
        }
        return null;
    }

    private AnnotationPreference getVerticalRulerAnnotationPreference(String preferenceKey) {
        if (preferenceKey == null) {
            return null;
        }
        Iterator e = this.fAnnotationPreferences.getAnnotationPreferences().iterator();
        while (e.hasNext()) {
            AnnotationPreference info = (AnnotationPreference)e.next();
            if (info == null || !preferenceKey.equals(info.getVerticalRulerPreferenceKey())) continue;
            return info;
        }
        return null;
    }

    protected void showOverviewRuler() {
        if (this.fOverviewRuler != null && this.getSourceViewer() instanceof ISourceViewerExtension) {
            ((ISourceViewerExtension)this.getSourceViewer()).showAnnotationsOverview(true);
            this.fSourceViewerDecorationSupport.updateOverviewDecorations();
        }
    }

    protected void hideOverviewRuler() {
        if (this.getSourceViewer() instanceof ISourceViewerExtension) {
            this.fSourceViewerDecorationSupport.hideAnnotationOverview();
            ((ISourceViewerExtension)this.getSourceViewer()).showAnnotationsOverview(false);
        }
    }

    protected IAnnotationAccess getAnnotationAccess() {
        if (this.fAnnotationAccess == null) {
            this.fAnnotationAccess = this.createAnnotationAccess();
        }
        return this.fAnnotationAccess;
    }

    protected AnnotationPreferenceLookup getAnnotationPreferenceLookup() {
        return EditorsPlugin.getDefault().getAnnotationPreferenceLookup();
    }

    protected IOverviewRuler getOverviewRuler() {
        if (this.fOverviewRuler == null) {
            this.fOverviewRuler = this.createOverviewRuler(this.getSharedColors());
        }
        return this.fOverviewRuler;
    }

    protected SourceViewerDecorationSupport getSourceViewerDecorationSupport(ISourceViewer viewer) {
        if (this.fSourceViewerDecorationSupport == null) {
            this.fSourceViewerDecorationSupport = new SourceViewerDecorationSupport(viewer, this.getOverviewRuler(), this.getAnnotationAccess(), this.getSharedColors());
            this.configureSourceViewerDecorationSupport(this.fSourceViewerDecorationSupport);
        }
        return this.fSourceViewerDecorationSupport;
    }

    protected MarkerAnnotationPreferences getAnnotationPreferences() {
        return this.fAnnotationPreferences;
    }

    public void gotoMarker(IMarker marker) {
        if (this.getSourceViewer() == null) {
            return;
        }
        int start = MarkerUtilities.getCharStart(marker);
        int end = MarkerUtilities.getCharEnd(marker);
        if (start < 0 || end < 0) {
            int line = MarkerUtilities.getLineNumber(marker);
            if (line > -1) {
                --line;
                try {
                    IDocument document = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
                    this.selectAndReveal(document.getLineOffset(line), document.getLineLength(line));
                }
                catch (BadLocationException badLocationException) {}
            }
        } else {
            IDocument document;
            int length;
            IAnnotationModel model = this.getDocumentProvider().getAnnotationModel((Object)this.getEditorInput());
            if (model instanceof AbstractMarkerAnnotationModel) {
                AbstractMarkerAnnotationModel markerModel = (AbstractMarkerAnnotationModel)model;
                Position pos = markerModel.getMarkerPosition(marker);
                if (pos != null && !pos.isDeleted()) {
                    start = pos.getOffset();
                    end = pos.getOffset() + pos.getLength();
                }
                if (pos != null && pos.isDeleted()) {
                    return;
                }
            }
            if (end - 1 < (length = (document = this.getDocumentProvider().getDocument((Object)this.getEditorInput())).getLength()) && start < length) {
                this.selectAndReveal(start, end - start);
            }
        }
    }

    protected boolean isErrorStatus(IStatus status) {
        return super.isErrorStatus(status) && status.getCode() != 279 && status.getSeverity() != 8;
    }

    protected void createActions() {
        super.createActions();
        AddMarkerAction action = new AddMarkerAction(TextEditorMessages.getResourceBundle(), "Editor.AddBookmark.", (ITextEditor)this, "org.eclipse.core.resources.bookmark", true);
        action.setHelpContextId(ITextEditorHelpContextIds.BOOKMARK_ACTION);
        action.setActionDefinitionId("org.eclipse.ui.edit.addBookmark");
        this.setAction(IDEActionFactory.BOOKMARK.getId(), (IAction)action);
        action = new AddTaskAction(TextEditorMessages.getResourceBundle(), "Editor.AddTask.", (ITextEditor)this);
        action.setHelpContextId(ITextEditorHelpContextIds.ADD_TASK_ACTION);
        action.setActionDefinitionId("org.eclipse.ui.edit.addTask");
        this.setAction(IDEActionFactory.ADD_TASK.getId(), (IAction)action);
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.ide.IGotoMarker");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(adapter)) {
            return this.fGotoMarkerAdapter;
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.jface.text.source.IAnnotationAccess");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz2.equals(adapter)) {
            return this.getAnnotationAccess();
        }
        return super.getAdapter(adapter);
    }

    protected void setDocumentProvider(IEditorInput input) {
        this.fImplicitDocumentProvider = DocumentProviderRegistry.getDefault().getDocumentProvider(input);
        IDocumentProvider provider = super.getDocumentProvider();
        if (provider instanceof ForwardingDocumentProvider) {
            ForwardingDocumentProvider forwarder = (ForwardingDocumentProvider)provider;
            forwarder.setParentProvider(this.fImplicitDocumentProvider);
        }
    }

    public IDocumentProvider getDocumentProvider() {
        IDocumentProvider provider = super.getDocumentProvider();
        if (provider == null) {
            return this.fImplicitDocumentProvider;
        }
        return provider;
    }

    protected void disposeDocumentProvider() {
        super.disposeDocumentProvider();
        this.fImplicitDocumentProvider = null;
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        if (this.fIsChangeInformationShown) {
            if (this.isPrefQuickDiffAlwaysOn()) {
                this.uninstallChangeRulerModel();
                this.fIsChangeInformationShown = false;
            } else {
                this.showChangeInformation(false);
            }
        }
        super.doSetInput(input);
        if (this.isPrefQuickDiffAlwaysOn()) {
            this.showChangeInformation(true);
        }
    }

    private class GotoMarkerAdapter
    implements IGotoMarker {
        GotoMarkerAdapter() {
        }

        public void gotoMarker(IMarker marker) {
            AbstractDecoratedTextEditor.this.gotoMarker(marker);
        }
    }
}

