/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.texteditor;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.internal.texteditor.AnnotationType;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.AnnotationPreferenceLookup;
import org.eclipse.ui.texteditor.IAnnotationImageProvider;

public class DelegatingAnnotationPreference
extends AnnotationPreference {
    private AnnotationType fType;
    private AnnotationPreferenceLookup fLookup;
    private Set fCache = new HashSet();

    public DelegatingAnnotationPreference(AnnotationType type, AnnotationPreferenceLookup lookup) {
        this.fType = type;
        this.fLookup = lookup;
    }

    private boolean isCached(Object attribute) {
        return this.fCache.contains(attribute);
    }

    private void markCached(Object attribute) {
        this.fCache.add(attribute);
    }

    private AnnotationPreference getDefiningPreference(Object attribute) {
        AnnotationPreference p = this.fLookup.getAnnotationPreferenceFragment(this.fType.getType());
        if (p != null && p.hasValue(attribute)) {
            return p;
        }
        String[] superTypes = this.fType.getSuperTypes();
        int i = 0;
        while (i < superTypes.length) {
            p = this.fLookup.getAnnotationPreferenceFragment(superTypes[i]);
            if (p != null && p.hasValue(attribute)) {
                return p;
            }
            ++i;
        }
        return null;
    }

    private Object getAttributeValue(Object attribute) {
        if (!this.isCached(attribute)) {
            AnnotationPreference preference = this.getDefiningPreference(attribute);
            if (preference != null) {
                this.setValue(attribute, preference.getValue(attribute));
            }
            this.markCached(attribute);
        }
        return this.getValue(attribute);
    }

    private boolean getBooleanAttributeValue(Object attribute) {
        Object value = this.getAttributeValue(attribute);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return false;
    }

    public Object getAnnotationType() {
        return this.fType.getType();
    }

    public boolean contributesToHeader() {
        return this.getBooleanAttributeValue(AnnotationPreference.HEADER_VALUE);
    }

    public IAnnotationImageProvider getAnnotationImageProvider() {
        if (!this.isCached(AnnotationPreference.IMAGE_PROVIDER)) {
            AnnotationPreference preference = this.getDefiningPreference(AnnotationPreference.IMAGE_PROVIDER);
            if (preference != null) {
                this.fAnnotationImageProvider = preference.fAnnotationImageProvider;
                this.fAnnotationImageProviderAttribute = preference.fAnnotationImageProviderAttribute;
                this.fConfigurationElement = preference.fConfigurationElement;
            }
            this.markCached(AnnotationPreference.IMAGE_PROVIDER);
        }
        return super.getAnnotationImageProvider();
    }

    public String getColorPreferenceKey() {
        return (String)this.getAttributeValue(AnnotationPreference.COLOR_PREFERENCE_KEY);
    }

    public RGB getColorPreferenceValue() {
        return (RGB)this.getAttributeValue(AnnotationPreference.COLOR_PREFERENCE_VALUE);
    }

    public String getHighlightPreferenceKey() {
        return (String)this.getAttributeValue(AnnotationPreference.HIGHLIGHT_PREFERENCE_KEY);
    }

    public boolean getHighlightPreferenceValue() {
        return this.getBooleanAttributeValue(AnnotationPreference.HIGHLIGHT_PREFERENCE_VALUE);
    }

    public ImageDescriptor getImageDescriptor() {
        return (ImageDescriptor)this.getAttributeValue(AnnotationPreference.IMAGE_DESCRIPTOR);
    }

    public String getIsGoToNextNavigationTargetKey() {
        return (String)this.getAttributeValue(AnnotationPreference.IS_GO_TO_NEXT_TARGET_KEY);
    }

    public String getIsGoToPreviousNavigationTargetKey() {
        return (String)this.getAttributeValue(AnnotationPreference.IS_GO_TO_PREVIOUS_TARGET_KEY);
    }

    public String getOverviewRulerPreferenceKey() {
        return (String)this.getAttributeValue(AnnotationPreference.OVERVIEW_RULER_PREFERENCE_KEY);
    }

    public boolean getOverviewRulerPreferenceValue() {
        return this.getBooleanAttributeValue(AnnotationPreference.OVERVIEW_RULER_PREFERENCE_VALUE);
    }

    public String getPreferenceLabel() {
        return (String)this.getAttributeValue(AnnotationPreference.PREFERENCE_LABEL);
    }

    public int getPresentationLayer() {
        Object value = this.getAttributeValue(AnnotationPreference.PRESENTATION_LAYER);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        return 0;
    }

    public String getShowInNextPrevDropdownToolbarActionKey() {
        return (String)this.getAttributeValue(AnnotationPreference.SHOW_IN_NAVIGATION_DROPDOWN_KEY);
    }

    public String getSymbolicImageName() {
        return (String)this.getAttributeValue(AnnotationPreference.SYMBOLIC_IMAGE_NAME);
    }

    public String getTextPreferenceKey() {
        return (String)this.getAttributeValue(AnnotationPreference.TEXT_PREFERENCE_KEY);
    }

    public boolean getTextPreferenceValue() {
        return this.getBooleanAttributeValue(AnnotationPreference.TEXT_PREFERENCE_VALUE);
    }

    public String getVerticalRulerPreferenceKey() {
        return (String)this.getAttributeValue(AnnotationPreference.VERTICAL_RULER_PREFERENCE_KEY);
    }

    public boolean getVerticalRulerPreferenceValue() {
        return this.getBooleanAttributeValue(AnnotationPreference.VERTICAL_RULER_PREFERENCE_VALUE);
    }

    public boolean isGoToNextNavigationTarget() {
        return this.getBooleanAttributeValue(AnnotationPreference.IS_GO_TO_NEXT_TARGET_VALUE);
    }

    public boolean isGoToPreviousNavigationTarget() {
        return this.getBooleanAttributeValue(AnnotationPreference.IS_GO_TO_PREVIOUS_TARGET_VALUE);
    }

    public boolean isShowInNextPrevDropdownToolbarAction() {
        return this.getBooleanAttributeValue(AnnotationPreference.SHOW_IN_NAVIGATION_DROPDOWN_VALUE);
    }
}

