/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Properties;
import org.eclipse.osgi.framework.adaptor.BundleClassLoader;
import org.eclipse.osgi.framework.adaptor.BundleData;
import org.eclipse.osgi.framework.adaptor.ClassLoaderDelegate;
import org.eclipse.osgi.framework.adaptor.ImportClassNotFoundException;
import org.eclipse.osgi.framework.adaptor.ImportResourceNotFoundException;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.BundleFragment;
import org.eclipse.osgi.framework.internal.core.BundleHost;
import org.eclipse.osgi.framework.internal.core.BundleLoaderProxy;
import org.eclipse.osgi.framework.internal.core.BundleResourcePermission;
import org.eclipse.osgi.framework.internal.core.FilterImpl;
import org.eclipse.osgi.framework.internal.core.KeyedHashSet;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.eclipse.osgi.framework.internal.core.MultiSourcePackage;
import org.eclipse.osgi.framework.internal.core.NullPackageSource;
import org.eclipse.osgi.framework.internal.core.PackageSource;
import org.eclipse.osgi.framework.internal.core.SingleSourcePackage;
import org.eclipse.osgi.framework.internal.core.SystemBundleLoader;
import org.eclipse.osgi.framework.util.SecureAction;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.PackageSpecification;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;

public class BundleLoader
implements ClassLoaderDelegate {
    protected static String DEFAULT_PACKAGE = ".";
    protected BundleHost bundle;
    protected BundleClassLoader classloader;
    protected BundleResourcePermission resourcePermission;
    protected KeyedHashSet importedPackages;
    protected boolean hasDynamicImports = false;
    protected boolean dynamicImportPackageAll;
    protected String[] dynamicImportPackageStems;
    protected String[] dynamicImportPackages;
    protected KeyedHashSet providedPackages;
    protected KeyedHashSet requiredPackagesCache;
    protected BundleLoaderProxy[] requiredBundles;
    protected int[] reexportTable;

    protected static String getPackageName(String name) {
        int index;
        if (name != null && (index = name.lastIndexOf(46)) > 0) {
            return name.substring(0, index);
        }
        return null;
    }

    protected static String getResourcePackageName(String name) {
        if (name != null) {
            int begin = name.length() > 1 && name.charAt(0) == '/' ? 1 : 0;
            int end = name.lastIndexOf(47);
            if (end > begin) {
                return name.substring(begin, end).replace('/', '.');
            }
        }
        return null;
    }

    protected BundleLoader(BundleHost bundle, BundleDescription description) throws BundleException {
        this.bundle = bundle;
        try {
            bundle.getBundleData().open();
        }
        catch (IOException e) {
            throw new BundleException(Msg.formatter.getString("BUNDLE_READ_EXCEPTION"), (Throwable)e);
        }
        this.initialize(description);
    }

    protected void initialize(BundleDescription description) {
        this.hasDynamicImports = SystemBundleLoader.getSystemPackages() != null;
        Bundle[] fragmentObjects = this.bundle.getFragments();
        BundleDescription[] fragments = new BundleDescription[fragmentObjects == null ? 0 : fragmentObjects.length];
        int i = 0;
        while (i < fragments.length) {
            fragments[i] = ((AbstractBundle)fragmentObjects[i]).getBundleDescription();
            ++i;
        }
        this.addImportedPackages(description.getPackages());
        i = 0;
        while (i < fragments.length) {
            if (fragments[i].isResolved()) {
                this.addImportedPackages(fragments[i].getPackages());
            }
            ++i;
        }
        BundleSpecification[] required = description.getRequiredBundles();
        ArrayList<BundleSpecification> bundles = new ArrayList<BundleSpecification>(Arrays.asList(required == null ? new BundleSpecification[]{} : required));
        int i2 = 0;
        while (i2 < fragments.length) {
            BundleSpecification[] fragmentRequires;
            if (fragments[i2].isResolved() && (fragmentRequires = fragments[i2].getRequiredBundles()) != null) {
                bundles.addAll(Arrays.asList(fragmentRequires));
            }
            ++i2;
        }
        if (bundles.size() > 0) {
            ArrayList<BundleLoaderProxy> bound = new ArrayList<BundleLoaderProxy>(bundles.size());
            int[] reexported = new int[bundles.size()];
            int reexportIndex = 0;
            int i3 = 0;
            while (i3 < bundles.size()) {
                BundleSpecification spec = bundles.get(i3);
                if (spec.isResolved()) {
                    String bundleKey = spec.getName() + "_" + spec.getActualVersion().toString();
                    BundleLoaderProxy loaderProxy = (BundleLoaderProxy)this.bundle.framework.packageAdmin.exportedBundles.getByKey(bundleKey);
                    if (loaderProxy != null) {
                        bound.add(loaderProxy);
                        if (spec.isExported()) {
                            reexported[reexportIndex++] = bound.size() - 1;
                        }
                    } else if (!spec.isOptional()) {
                        BundleException be = new BundleException(Msg.formatter.getString("BUNDLE_MISSING_LOADER", bundleKey));
                        this.bundle.framework.publishFrameworkEvent(2, this.bundle, be);
                    }
                }
                ++i3;
            }
            this.requiredBundles = bound.toArray(new BundleLoaderProxy[bound.size()]);
            if (reexportIndex > 0) {
                this.reexportTable = new int[reexportIndex];
                System.arraycopy(reexported, 0, this.reexportTable, 0, reexportIndex);
            }
        }
        String[] provides = description.getProvidedPackages();
        ArrayList<String> packages = new ArrayList<String>(Arrays.asList(required == null ? new String[]{} : provides));
        int i4 = 0;
        while (i4 < fragments.length) {
            String[] fragmentProvides;
            if (fragments[i4].isResolved() && (fragmentProvides = fragments[i4].getProvidedPackages()) != null) {
                packages.addAll(Arrays.asList(fragmentProvides));
            }
            ++i4;
        }
        if (packages.size() > 0) {
            this.providedPackages = new KeyedHashSet(packages.size());
            i4 = 0;
            while (i4 < packages.size()) {
                this.providedPackages.add(new SingleSourcePackage(packages.get(i4), this.bundle.getLoaderProxy()));
                ++i4;
            }
        }
        try {
            String spec = this.bundle.getBundleData().getDynamicImports();
            ManifestElement[] imports = ManifestElement.parseHeader("DynamicImport-Package", spec);
            this.addDynamicImportPackage(imports);
            int i5 = 0;
            while (i5 < fragments.length) {
                if (fragments[i5].isResolved()) {
                    spec = ((AbstractBundle)fragmentObjects[i5]).getBundleData().getDynamicImports();
                    imports = ManifestElement.parseHeader("DynamicImport-Package", spec);
                    this.addDynamicImportPackage(imports);
                }
                ++i5;
            }
        }
        catch (BundleException e) {
            this.bundle.framework.publishFrameworkEvent(2, this.bundle, e);
        }
    }

    protected void initializeFragment(AbstractBundle fragment) throws BundleException {
        String[] provides;
        BundleSpecification[] fragReqBundles;
        BundleDescription description = fragment.getBundleDescription();
        PackageSpecification[] packages = description.getPackages();
        if (packages != null && packages.length > 0) {
            int i = 0;
            while (i < packages.length) {
                if (this.importedPackages == null || this.importedPackages.getByKey(packages[i].getName()) == null) {
                    throw new BundleException(Msg.formatter.getString("BUNDLE_FRAGMENT_IMPORT_CONFLICT", new Object[]{fragment.getLocation(), packages[i].getName(), this.bundle.getLocation()}));
                }
                ++i;
            }
        }
        if ((fragReqBundles = description.getRequiredBundles()) != null && fragReqBundles.length > 0) {
            if (this.requiredBundles == null) {
                throw new BundleException(Msg.formatter.getString("BUNDLE_FRAGMENT_REQUIRE_CONFLICT", new Object[]{fragment.getLocation(), fragReqBundles[0].getName(), this.bundle.getLocation()}));
            }
            int i = 0;
            while (i < fragReqBundles.length) {
                boolean found = false;
                int j = 0;
                while (j < this.requiredBundles.length) {
                    String fragReqKey = fragReqBundles[i].getName() + "_" + fragReqBundles[i].getActualVersion().toString();
                    if (fragReqKey.equals(this.requiredBundles[j].getKey())) {
                        found = true;
                    }
                    ++j;
                }
                if (!found) {
                    throw new BundleException(Msg.formatter.getString("BUNDLE_FRAGMENT_REQUIRE_CONFLICT", new Object[]{fragment.getLocation(), fragReqBundles[i].getName(), this.bundle.getLocation()}));
                }
                ++i;
            }
        }
        try {
            String spec = fragment.getBundleData().getDynamicImports();
            ManifestElement[] imports = ManifestElement.parseHeader("DynamicImport-Package", spec);
            if (imports != null && imports.length > 0) {
                int i = 0;
                while (i < imports.length) {
                    String name = imports[i].getValue();
                    if (!this.isDynamicallyImported(name)) {
                        throw new BundleException(Msg.formatter.getString("BUNDLE_FRAGMENT_IMPORT_CONFLICT", new Object[]{fragment.getLocation(), imports[i], this.bundle.getLocation()}));
                    }
                    ++i;
                }
            }
        }
        catch (BundleException e) {
            this.bundle.framework.publishFrameworkEvent(2, this.bundle, e);
        }
        if ((provides = description.getProvidedPackages()) != null) {
            if (this.providedPackages == null) {
                this.providedPackages = new KeyedHashSet(provides.length);
            }
            int i = 0;
            while (i < provides.length) {
                if (this.providedPackages.getByKey(provides[i]) == null) {
                    this.providedPackages.add(new SingleSourcePackage(provides[i], this.bundle.getLoaderProxy()));
                }
                ++i;
            }
        }
    }

    private void addImportedPackages(PackageSpecification[] packages) {
        if (packages != null && packages.length > 0) {
            if (this.importedPackages == null) {
                this.importedPackages = new KeyedHashSet();
            }
            int i = 0;
            while (i < packages.length) {
                SingleSourcePackage packagesource = (SingleSourcePackage)this.bundle.framework.packageAdmin.exportedPackages.getByKey(packages[i].getName());
                if (packagesource != null) {
                    this.importedPackages.add(packagesource);
                }
                ++i;
            }
        }
    }

    protected void close() {
        if (this.bundle == null) {
            return;
        }
        this.importedPackages = null;
        if (this.classloader != null) {
            this.classloader.close();
        }
        this.classloader = null;
        this.bundle = null;
    }

    protected Class loadClass(String name) throws ClassNotFoundException {
        return this.createClassLoader().loadClass(name);
    }

    protected URL getResource(String name) {
        return this.createClassLoader().getResource(name);
    }

    protected Class requireClass(String name, String packageName) {
        Class result = null;
        try {
            result = this.findImportedClass(name, packageName);
        }
        catch (ImportClassNotFoundException importClassNotFoundException) {
            return null;
        }
        if (result == null) {
            result = this.findLocalClass(name);
        }
        return result;
    }

    protected BundleClassLoader createClassLoader() {
        if (this.classloader != null) {
            return this.classloader;
        }
        BundleLoader bundleLoader = this;
        synchronized (bundleLoader) {
            if (this.classloader != null) {
                return this.classloader;
            }
            try {
                String[] classpath = this.getClassPath(this.bundle, SecureAction.getProperties());
                if (classpath != null) {
                    this.classloader = this.createBCLPrevileged(this.bundle.getProtectionDomain(), classpath);
                } else {
                    this.bundle.framework.publishFrameworkEvent(2, this.bundle, new BundleException(Msg.formatter.getString("BUNDLE_NO_CLASSPATH_MATCH")));
                }
            }
            catch (BundleException e) {
                this.bundle.framework.publishFrameworkEvent(2, this.bundle, e);
            }
        }
        return this.classloader;
    }

    protected Class findLocalClass(String name) {
        if (Debug.DEBUG_LOADER) {
            Debug.println("BundleLoader[" + this + "].findLocalClass(" + name + ")");
        }
        try {
            Class clazz = this.createClassLoader().findLocalClass(name);
            if (Debug.DEBUG_LOADER && clazz != null) {
                Debug.println("BundleLoader[" + this + "] found local class " + name);
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public Class findClass(String name) throws ClassNotFoundException {
        if (this.isClosed()) {
            throw new ClassNotFoundException(name);
        }
        if (Debug.DEBUG_LOADER) {
            Debug.println("BundleLoader[" + this + "].loadBundleClass(" + name + ")");
        }
        String packageName = BundleLoader.getPackageName(name);
        Class result = null;
        if (packageName != null) {
            result = this.findImportedClass(name, packageName);
        }
        if (result == null) {
            result = this.findRequiredClass(name, packageName);
        }
        if (result == null && (result = this.findLocalClass(name)) == null) {
            throw new ClassNotFoundException(name);
        }
        return result;
    }

    boolean isClosed() {
        return this.bundle == null;
    }

    public URL findResource(String name) {
        if (this.isClosed()) {
            return null;
        }
        if (name.length() > 1 && name.charAt(0) == '/') {
            name = name.substring(1);
        }
        try {
            this.checkResourcePermission();
        }
        catch (SecurityException securityException) {
            try {
                this.bundle.framework.checkAdminPermission();
            }
            catch (SecurityException securityException2) {
                return null;
            }
        }
        String packageName = BundleLoader.getResourcePackageName(name);
        URL resource = null;
        if (packageName != null) {
            resource = this.findImportedResource(name, packageName);
        }
        if (resource == null) {
            resource = this.findRequiredResource(name, packageName);
        }
        if (resource == null) {
            resource = this.findLocalResource(name);
        }
        return resource;
    }

    public Enumeration findResources(String name) throws IOException {
        if (this.isClosed()) {
            return null;
        }
        if (name.length() > 1 && name.charAt(0) == '/') {
            name = name.substring(1);
        }
        try {
            this.checkResourcePermission();
        }
        catch (SecurityException securityException) {
            try {
                this.bundle.framework.checkAdminPermission();
            }
            catch (SecurityException securityException2) {
                return null;
            }
        }
        String packageName = BundleLoader.getResourcePackageName(name);
        Enumeration result = null;
        if (packageName != null) {
            result = this.findImportedResources(name, packageName);
        }
        if (result == null) {
            result = this.findRequiredResources(name, packageName);
        }
        if (result == null) {
            result = this.findLocalResources(name);
        }
        return result;
    }

    protected URL requireResource(String name, String packageName) {
        URL result = null;
        try {
            result = this.findImportedResource(name, packageName);
        }
        catch (ImportResourceNotFoundException importResourceNotFoundException) {
            return null;
        }
        if (result == null) {
            result = this.findLocalResource(name);
        }
        return result;
    }

    protected URL findLocalResource(final String name) {
        if (System.getSecurityManager() == null) {
            return this.createClassLoader().findLocalResource(name);
        }
        return (URL)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return BundleLoader.this.createClassLoader().findLocalResource(name);
            }
        });
    }

    protected Enumeration requireResources(String name, String packageName) {
        Enumeration result = null;
        try {
            result = this.findImportedResources(name, packageName);
        }
        catch (ImportResourceNotFoundException importResourceNotFoundException) {
            return null;
        }
        if (result == null) {
            result = this.findLocalResources(name);
        }
        return result;
    }

    protected Enumeration findLocalResources(String name) {
        if (name.length() > 1 && name.charAt(0) == '/') {
            name = name.substring(1);
        }
        try {
            this.checkResourcePermission();
        }
        catch (SecurityException securityException) {
            return null;
        }
        return this.createClassLoader().findLocalResources(name);
    }

    public Object findObject(String object) {
        if (this.isClosed()) {
            return null;
        }
        if (object.length() > 1 && object.charAt(0) == '/') {
            object = object.substring(1);
        }
        try {
            this.checkResourcePermission();
        }
        catch (SecurityException securityException) {
            try {
                this.bundle.framework.checkAdminPermission();
            }
            catch (SecurityException securityException2) {
                return null;
            }
        }
        String packageName = BundleLoader.getResourcePackageName(object);
        Object result = null;
        if (packageName != null) {
            result = this.findImportedObject(object, packageName);
        }
        if (result == null) {
            result = this.findRequiredObject(object, packageName);
        }
        if (result == null) {
            result = this.findLocalObject(object);
        }
        return result;
    }

    protected Object requireObject(String object, String packageName) {
        Object result = null;
        try {
            result = this.findImportedObject(object, packageName);
        }
        catch (ImportResourceNotFoundException importResourceNotFoundException) {
            return null;
        }
        if (result == null) {
            result = this.findLocalObject(object);
        }
        return result;
    }

    protected Object findLocalObject(String object) {
        return this.createClassLoader().findLocalObject(object);
    }

    public String findLibrary(final String name) {
        if (this.isClosed()) {
            return null;
        }
        if (System.getSecurityManager() == null) {
            return this.findLocalLibrary(name);
        }
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return BundleLoader.this.findLocalLibrary(name);
            }
        });
    }

    protected String findLocalLibrary(String name) {
        String result = this.bundle.getBundleData().findLibrary(name);
        if (result != null) {
            return result;
        }
        Bundle[] fragments = this.bundle.getFragments();
        if (fragments == null || fragments.length == 0) {
            return null;
        }
        int i = 0;
        while (i < fragments.length) {
            result = ((AbstractBundle)fragments[i]).getBundleData().findLibrary(name);
            if (result != null) {
                return result;
            }
            ++i;
        }
        return result;
    }

    protected AbstractBundle getBundle() {
        return this.bundle;
    }

    private BundleClassLoader createBCLPrevileged(final ProtectionDomain pd, final String[] cp) {
        if (System.getSecurityManager() == null) {
            return this.createBCL(pd, cp);
        }
        return (BundleClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return BundleLoader.this.createBCL(pd, cp);
            }
        });
    }

    private BundleClassLoader createBCL(ProtectionDomain pd, String[] cp) {
        BundleClassLoader bcl = this.bundle.getBundleData().createClassLoader(this, pd, cp);
        Bundle[] fragments = this.bundle.getFragments();
        if (fragments != null) {
            int i = 0;
            while (i < fragments.length) {
                AbstractBundle fragment = (AbstractBundle)fragments[i];
                try {
                    bcl.attachFragment(fragment.getBundleData(), fragment.domain, this.getClassPath(fragment, SecureAction.getProperties()));
                }
                catch (BundleException be) {
                    this.bundle.framework.publishFrameworkEvent(2, this.bundle, be);
                }
                ++i;
            }
        }
        bcl.initialize();
        return bcl;
    }

    public String toString() {
        BundleData result = this.bundle.getBundleData();
        return result == null ? "BundleLoader.bundledata == null!" : result.toString();
    }

    protected void checkResourcePermission() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            if (this.resourcePermission == null) {
                this.resourcePermission = new BundleResourcePermission(this.bundle.getBundleId());
            }
            sm.checkPermission(this.resourcePermission);
        }
    }

    protected BundleLoader getPackageExporter(String pkgname) {
        PackageSource exporter;
        if (pkgname == null) {
            return null;
        }
        if (this.importedPackages != null && (exporter = (PackageSource)this.importedPackages.getByKey(pkgname)) != null) {
            return exporter.getSupplier().getBundleLoader();
        }
        if (this.isDynamicallyImported(pkgname) && (exporter = (PackageSource)this.bundle.framework.packageAdmin.exportedPackages.getByKey(pkgname)) != null) {
            exporter.getSupplier().markUsed(this.bundle.getLoaderProxy());
            this.importedPackages.add(exporter);
            return exporter.getSupplier().getBundleLoader();
        }
        return null;
    }

    protected boolean isDynamicallyImported(String pkgname) {
        int i;
        if (pkgname.startsWith("java.")) {
            return true;
        }
        if (!this.hasDynamicImports) {
            return false;
        }
        if (this.dynamicImportPackageAll) {
            return true;
        }
        String[] systemPackages = SystemBundleLoader.getSystemPackages();
        if (systemPackages != null) {
            i = 0;
            while (i < systemPackages.length) {
                if (pkgname.equals(systemPackages[i])) {
                    return true;
                }
                ++i;
            }
        }
        if (this.dynamicImportPackages != null) {
            i = 0;
            while (i < this.dynamicImportPackages.length) {
                if (pkgname.equals(this.dynamicImportPackages[i])) {
                    return true;
                }
                ++i;
            }
        }
        if (this.dynamicImportPackageStems != null) {
            i = 0;
            while (i < this.dynamicImportPackageStems.length) {
                if (pkgname.startsWith(this.dynamicImportPackageStems[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Class findImportedClass(String name, String packageName) throws ImportClassNotFoundException {
        Class result;
        block6: {
            if (Debug.DEBUG_LOADER) {
                Debug.println("ImportClassLoader[" + this + "].findImportedClass(" + name + ")");
            }
            result = null;
            try {
                BundleLoader exporter = this.getPackageExporter(packageName);
                if (exporter != null && (result = exporter.findLocalClass(name)) == null) {
                    throw new ImportClassNotFoundException(name);
                }
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                if (result == null) {
                    if (!Debug.DEBUG_LOADER) throw throwable;
                    Debug.println("ImportClassLoader[" + this + "] class " + name + " not found in imported package " + packageName);
                    throw throwable;
                }
                if (!Debug.DEBUG_LOADER) throw throwable;
                Debug.println("BundleLoader[" + this + "] found imported class " + name);
                throw throwable;
            }
            {
                Object var5_7 = null;
                if (result != null) break block6;
                if (!Debug.DEBUG_LOADER) return result;
            }
            Debug.println("ImportClassLoader[" + this + "] class " + name + " not found in imported package " + packageName);
            return result;
        }
        if (!Debug.DEBUG_LOADER) return result;
        Debug.println("BundleLoader[" + this + "] found imported class " + name);
        return result;
    }

    protected void addExportedProvidersFor(String packageName, ArrayList result, KeyedHashSet visited) {
        if (!visited.add(this.bundle)) {
            return;
        }
        PackageSource local = this.getProvidedPackage(packageName);
        if (this.requiredBundles != null) {
            int size = this.reexportTable == null ? 0 : this.reexportTable.length;
            int reexportIndex = 0;
            int i = 0;
            while (i < this.requiredBundles.length) {
                if (local != null) {
                    this.requiredBundles[i].getBundleLoader().addExportedProvidersFor(packageName, result, visited);
                } else if (reexportIndex < size && this.reexportTable[reexportIndex] == i) {
                    ++reexportIndex;
                    this.requiredBundles[i].getBundleLoader().addExportedProvidersFor(packageName, result, visited);
                }
                ++i;
            }
        }
        if (local != null) {
            result.add(local.getSupplier());
        }
    }

    protected PackageSource getProvidersFor(String packageName) {
        PackageSource source;
        PackageSource result;
        if (packageName == null) {
            packageName = DEFAULT_PACKAGE;
        }
        if (this.requiredPackagesCache != null && (result = (PackageSource)this.requiredPackagesCache.getByKey(packageName)) != null) {
            if (result.isNullSource()) {
                return null;
            }
            return result;
        }
        if (this.requiredBundles == null) {
            return null;
        }
        KeyedHashSet visited = new KeyedHashSet(false);
        ArrayList result2 = new ArrayList(3);
        int i = 0;
        while (i < this.requiredBundles.length) {
            BundleLoader requiredLoader = this.requiredBundles[i].getBundleLoader();
            requiredLoader.addExportedProvidersFor(packageName, result2, visited);
            ++i;
        }
        if (this.requiredPackagesCache == null) {
            this.requiredPackagesCache = new KeyedHashSet();
        }
        if (result2.size() == 0) {
            this.requiredPackagesCache.add(new NullPackageSource(packageName));
            return null;
        }
        if (result2.size() == 1) {
            BundleLoaderProxy proxy = (BundleLoaderProxy)result2.get(0);
            source = proxy.getPackageSource(packageName);
            this.requiredPackagesCache.add(source);
            return source;
        }
        BundleLoaderProxy[] bundles = result2.toArray(new BundleLoaderProxy[result2.size()]);
        source = new MultiSourcePackage(packageName, bundles);
        this.requiredPackagesCache.add(source);
        return source;
    }

    protected Class findRequiredClass(String name, String packageName) {
        PackageSource source;
        if (Debug.DEBUG_LOADER) {
            Debug.println("ImportClassLoader[" + this + "].findRequiredClass(" + name + ")");
        }
        if ((source = this.getProvidersFor(packageName)) == null) {
            return null;
        }
        if (source.isMultivalued()) {
            BundleLoaderProxy[] bundles = source.getSuppliers();
            int i = 0;
            while (i < bundles.length) {
                Class result = bundles[i].getBundleLoader().requireClass(name, packageName);
                if (result != null) {
                    return result;
                }
                ++i;
            }
        } else {
            return source.getSupplier().getBundleLoader().requireClass(name, packageName);
        }
        return null;
    }

    protected PackageSource getProvidedPackage(String name) {
        return this.providedPackages == null ? null : (PackageSource)this.providedPackages.getByKey(name);
    }

    protected URL findImportedResource(String name, String packageName) {
        BundleLoader exporter;
        if (Debug.DEBUG_LOADER) {
            Debug.println("ImportClassLoader[" + this + "].findImportedResource(" + name + ")");
        }
        if ((exporter = this.getPackageExporter(packageName)) != null) {
            URL url = exporter.findLocalResource(name);
            if (url != null) {
                return url;
            }
            if (Debug.DEBUG_LOADER) {
                Debug.println("ImportClassLoader[" + this + "] resource " + name + " not found in imported package " + packageName);
            }
            throw new ImportResourceNotFoundException(name);
        }
        return null;
    }

    protected URL findRequiredResource(String name, String packageName) {
        PackageSource source;
        if (Debug.DEBUG_LOADER) {
            Debug.println("ImportClassLoader[" + this + "].findRequiredResource(" + name + ")");
        }
        if ((source = this.getProvidersFor(packageName)) == null) {
            return null;
        }
        if (source.isMultivalued()) {
            BundleLoaderProxy[] bundles = source.getSuppliers();
            int i = 0;
            while (i < bundles.length) {
                URL result = bundles[i].getBundleLoader().requireResource(name, packageName);
                if (result != null) {
                    return result;
                }
                ++i;
            }
        } else {
            return source.getSupplier().getBundleLoader().requireResource(name, packageName);
        }
        return null;
    }

    protected Enumeration findImportedResources(String name, String packageName) {
        BundleLoader exporter;
        if (Debug.DEBUG_LOADER) {
            Debug.println("ImportClassLoader[" + this + "].findImportedResources(" + name + ")");
        }
        if ((exporter = this.getPackageExporter(packageName)) != null) {
            return exporter.findLocalResources(name);
        }
        return null;
    }

    protected Enumeration findRequiredResources(String name, String packageName) {
        PackageSource source;
        if (Debug.DEBUG_LOADER) {
            Debug.println("ImportClassLoader[" + this + "].findRequiredResources(" + name + ")");
        }
        if ((source = this.getProvidersFor(packageName)) == null) {
            return null;
        }
        if (source.isMultivalued()) {
            BundleLoaderProxy[] bundles = source.getSuppliers();
            int i = 0;
            while (i < bundles.length) {
                Enumeration result = bundles[i].getBundleLoader().requireResources(name, packageName);
                if (result != null) {
                    return result;
                }
                ++i;
            }
        } else {
            return source.getSupplier().getBundleLoader().requireResources(name, packageName);
        }
        return null;
    }

    protected Object findImportedObject(String object, String packageName) {
        BundleLoader exporter;
        if (Debug.DEBUG_LOADER) {
            Debug.println("ImportClassLoader[" + this + "].findImportedObject(" + object + ")");
        }
        if ((exporter = this.getPackageExporter(packageName)) != null) {
            Object result = exporter.findLocalObject(object);
            if (result != null) {
                return result;
            }
            if (Debug.DEBUG_LOADER) {
                Debug.println("ImportClassLoader[" + this + "] object " + object + " not found in imported package " + packageName);
            }
            throw new ImportResourceNotFoundException(object);
        }
        return null;
    }

    protected Object findRequiredObject(String name, String packageName) {
        PackageSource source;
        if (Debug.DEBUG_LOADER) {
            Debug.println("ImportClassLoader[" + this + "].findRequiredResource(" + name + ")");
        }
        if ((source = this.getProvidersFor(packageName)) == null) {
            return null;
        }
        if (source.isMultivalued()) {
            BundleLoaderProxy[] bundles = source.getSuppliers();
            int i = 0;
            while (i < bundles.length) {
                Object result = bundles[i].getBundleLoader().requireObject(name, packageName);
                if (result != null) {
                    return result;
                }
                ++i;
            }
        } else {
            return source.getSupplier().getBundleLoader().requireObject(name, packageName);
        }
        return null;
    }

    public void addDynamicImportPackage(ManifestElement[] packages) {
        int i;
        ArrayList<String> names;
        ArrayList<String> stems;
        if (packages == null && SystemBundleLoader.getSystemPackages() == null) {
            return;
        }
        this.hasDynamicImports = true;
        if (this.importedPackages == null) {
            this.importedPackages = new KeyedHashSet();
        }
        if (packages == null) {
            return;
        }
        int size = packages.length;
        if (this.dynamicImportPackageStems == null) {
            stems = new ArrayList<String>(size);
        } else {
            stems = new ArrayList(size + this.dynamicImportPackageStems.length);
            int i2 = 0;
            while (i2 < this.dynamicImportPackageStems.length) {
                stems.add(this.dynamicImportPackageStems[i2]);
                ++i2;
            }
        }
        if (this.dynamicImportPackages == null) {
            names = new ArrayList<String>(size);
        } else {
            names = new ArrayList(size + this.dynamicImportPackages.length);
            i = 0;
            while (i < this.dynamicImportPackages.length) {
                names.add(this.dynamicImportPackages[i]);
                ++i;
            }
        }
        i = 0;
        while (i < size) {
            String name = packages[i].getValue();
            if (!this.isDynamicallyImported(name)) {
                if (name.equals("*")) {
                    this.dynamicImportPackageAll = true;
                    return;
                }
                if (name.endsWith(".*")) {
                    stems.add(name.substring(0, name.length() - 1));
                } else {
                    names.add(name);
                }
            }
            ++i;
        }
        size = stems.size();
        if (size > 0) {
            this.dynamicImportPackageStems = stems.toArray(new String[size]);
        }
        if ((size = names.size()) > 0) {
            this.dynamicImportPackages = names.toArray(new String[size]);
        }
    }

    protected void clear() {
        this.providedPackages = null;
        this.requiredBundles = null;
        this.importedPackages = null;
        this.dynamicImportPackages = null;
        this.dynamicImportPackageStems = null;
    }

    protected void attachFragment(BundleFragment fragment, Properties props) throws BundleException {
        this.initializeFragment(fragment);
        if (this.classloader == null) {
            return;
        }
        try {
            String[] classpath = this.getClassPath(fragment, props);
            if (classpath != null) {
                this.classloader.attachFragment(fragment.getBundleData(), fragment.domain, classpath);
            } else {
                this.bundle.framework.publishFrameworkEvent(2, this.bundle, new BundleException(Msg.formatter.getString("BUNDLE_NO_CLASSPATH_MATCH")));
            }
        }
        catch (BundleException e) {
            this.bundle.framework.publishFrameworkEvent(2, this.bundle, e);
        }
    }

    protected String[] getClassPath(AbstractBundle bundle, Properties props) throws BundleException {
        String spec = bundle.getBundleData().getClassPath();
        ManifestElement[] classpathElements = ManifestElement.parseHeader("Bundle-ClassPath", spec);
        return this.matchClassPath(classpathElements, props);
    }

    protected String[] matchClassPath(ManifestElement[] classpath, Properties props) {
        if (classpath == null) {
            if (Debug.DEBUG_LOADER) {
                Debug.println("  no classpath");
            }
            return new String[]{"."};
        }
        ArrayList<String> result = new ArrayList<String>(classpath.length);
        int i = 0;
        while (i < classpath.length) {
            try {
                FilterImpl filter = this.createFilter(classpath[i].getAttribute("selection-filter"));
                if (filter == null || filter.match(props)) {
                    if (Debug.DEBUG_LOADER) {
                        Debug.println("  found match for classpath entry " + classpath[i].getValueComponents());
                    }
                    String[] matchPaths = classpath[i].getValueComponents();
                    int j = 0;
                    while (j < matchPaths.length) {
                        result.add(matchPaths[j]);
                        ++j;
                    }
                }
            }
            catch (InvalidSyntaxException e) {
                this.bundle.framework.publishFrameworkEvent(2, this.bundle, e);
            }
            ++i;
        }
        return result.toArray(new String[result.size()]);
    }

    protected FilterImpl createFilter(String filterString) throws InvalidSyntaxException {
        if (filterString == null) {
            return null;
        }
        int length = filterString.length();
        if (length <= 2) {
            throw new InvalidSyntaxException(Msg.formatter.getString("FILTER_INVALID"), filterString);
        }
        return new FilterImpl(filterString);
    }
}

