/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.context;

import java.util.List;
import org.eclipse.help.IHelpResource;
import org.eclipse.help.internal.context.ContextsBuilder;
import org.eclipse.help.internal.context.ContextsNode;
import org.eclipse.help.internal.context.IStyledContext;
import org.xml.sax.Attributes;

public class Context
extends ContextsNode
implements IStyledContext {
    private String text;
    protected String pluginID;
    protected String shortID;

    public Context(Attributes attrs) {
        super(attrs);
        if (attrs == null) {
            return;
        }
        this.shortID = attrs.getValue("id");
    }

    public String getText() {
        return this.text.replaceAll("(\\s+</?@#\\$b>\\s*)|(\\s*</?@#\\$b>\\s+)", " ").replaceAll("</?@#\\$b>", "");
    }

    public String getStyledText() {
        return this.text;
    }

    public IHelpResource[] getRelatedTopics() {
        if (this.children.size() > 0) {
            IHelpResource[] related = new IHelpResource[this.children.size()];
            this.children.toArray(related);
            return related;
        }
        return null;
    }

    public void setStyledText(String s) {
        this.text = s;
    }

    public String getShortId() {
        return this.shortID;
    }

    public String getID() {
        return String.valueOf(this.pluginID) + "." + this.shortID;
    }

    public void setPluginID(String pluginID) {
        this.pluginID = pluginID;
    }

    public void build(ContextsBuilder builder) {
        builder.build(this);
    }

    public void setChildren(List children) {
        this.children = children;
    }
}

