/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.extension;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.wizards.extension.BaseExtensionPointMainPage;
import org.eclipse.swt.widgets.Composite;

public class NewExtensionPointMainPage
extends BaseExtensionPointMainPage {
    public static final String KEY_TITLE = "NewExtensionPointWizard.title";
    public static final String KEY_DESC = "NewExtensionPointWizard.desc";
    private IPluginModelBase model;
    private IPluginExtensionPoint point;

    public NewExtensionPointMainPage(IProject project, IPluginModelBase model) {
        this(project, model, null);
    }

    public NewExtensionPointMainPage(IProject project, IPluginModelBase model, IPluginExtensionPoint point) {
        super((IContainer)project);
        this.initialize();
        this.model = model;
        this.point = point;
    }

    public void initialize() {
        this.setTitle(PDEPlugin.getResourceString(KEY_TITLE));
        this.setDescription(PDEPlugin.getResourceString(KEY_DESC));
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.initializeValues();
        this.setPageComplete(this.checkFieldsFilled());
        this.setMessage(null);
    }

    protected boolean isPluginIdFinal() {
        return true;
    }

    public boolean finish() {
        String id = this.idText.getText();
        String name = this.nameText.getText();
        String schema = this.schemaText.getText();
        IPluginBase plugin = this.model.getPluginBase();
        IPluginExtensionPoint point = this.model.getFactory().createExtensionPoint();
        try {
            point.setId(id);
            if (name.length() > 0) {
                point.setName(name);
            }
            if (schema.length() > 0) {
                point.setSchema(schema);
            }
            plugin.add(point);
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
        if (schema.length() > 0) {
            IRunnableWithProgress operation = this.getOperation();
            try {
                this.getContainer().run(false, true, operation);
            }
            catch (InvocationTargetException e) {
                PDEPlugin.logException(e);
                return false;
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
        }
        return true;
    }

    public String getPluginId() {
        return this.model.getPluginBase().getId();
    }

    public void initializeValues() {
        if (this.point == null) {
            return;
        }
        if (this.idText != null && this.point.getId() != null) {
            this.idText.setText(this.point.getId());
        }
        if (this.nameText != null && this.point.getName() != null) {
            this.nameText.setText(this.point.getName());
        }
        if (this.schemaText != null && this.point.getSchema() != null) {
            this.schemaText.setText(this.point.getSchema());
        }
    }
}

