/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.exports;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.ant.core.AntRunner;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.build.BuildScriptGenerator;
import org.eclipse.pde.internal.core.ModelEntry;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PluginModelManager;
import org.eclipse.pde.internal.core.TargetPlatform;
import org.eclipse.pde.internal.core.build.WorkspaceBuildModel;
import org.eclipse.pde.internal.core.feature.FeatureChild;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.ifeature.IFeaturePlugin;
import org.eclipse.pde.internal.ui.IPreferenceConstants;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.build.BaseBuildAction;
import org.eclipse.pde.internal.ui.build.ClasspathHelper;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class FeatureExportJob
extends Job
implements IPreferenceConstants {
    public static final int EXPORT_AS_ZIP = 0;
    public static final int EXPORT_AS_DIRECTORY = 1;
    public static final int EXPORT_AS_UPDATE_JARS = 2;
    protected static PrintWriter writer;
    protected static File logFile;
    protected int fExportType;
    protected boolean fExportSource;
    protected String fDestinationDirectory;
    protected String fZipFilename;
    protected Object[] fItems;
    protected String fBuildTempLocation;
    private String fDevProperties;
    protected HashMap fBuildProperties;

    public FeatureExportJob(int exportType, boolean exportSource, String destination, String zipFileName, Object[] items) {
        super(PDEPlugin.getResourceString("FeatureExportJob.name"));
        this.fExportType = exportType;
        this.fExportSource = exportSource;
        this.fDestinationDirectory = destination;
        this.fZipFilename = zipFileName;
        this.fItems = items;
        this.fBuildTempLocation = PDEPlugin.getDefault().getStateLocation().append("temp").toString();
        this.setRule(new SchedulingRule());
    }

    /*
     * Exception decompiling
     */
    protected IStatus run(IProgressMonitor monitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [4 : 104->107)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doExports(IProgressMonitor monitor) throws InvocationTargetException, CoreException {
        this.createDestination();
        monitor.beginTask("", this.fItems.length + 1);
        try {
            int i = 0;
            while (i < this.fItems.length) {
                Object var9_9;
                IFeatureModel model = (IFeatureModel)this.fItems[i];
                try {
                    IFeature feature = model.getFeature();
                    String id = feature.getId();
                    String os = this.getOS(feature);
                    String ws = this.getWS(feature);
                    String arch = this.getOSArch(feature);
                    this.doExport(id, model.getFeature().getVersion(), model.getInstallLocation(), os, ws, arch, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
                catch (Throwable throwable) {
                    var9_9 = null;
                    this.deleteBuildFiles((IModel)model);
                    throw throwable;
                }
                {
                    var9_9 = null;
                }
                this.deleteBuildFiles((IModel)model);
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            this.cleanup((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            monitor.done();
            throw throwable;
        }
        {
            Object var11_13 = null;
            this.cleanup((IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        monitor.done();
    }

    private String getOS(IFeature feature) {
        String os = feature.getOS();
        if (os == null || os.trim().length() == 0 || os.indexOf(44) != -1 || os.equals("*")) {
            return TargetPlatform.getOS();
        }
        return os;
    }

    private String getWS(IFeature feature) {
        String ws = feature.getWS();
        if (ws == null || ws.trim().length() == 0 || ws.indexOf(44) != -1 || ws.equals("*")) {
            return TargetPlatform.getWS();
        }
        return ws;
    }

    private String getOSArch(IFeature feature) {
        String arch = feature.getArch();
        if (arch == null || arch.trim().length() == 0 || arch.indexOf(44) != -1 || arch.equals("*")) {
            return TargetPlatform.getOSArch();
        }
        return arch;
    }

    private void createDestination() throws InvocationTargetException {
        File file = new File(this.fDestinationDirectory);
        if (!(file.exists() && file.isDirectory() || file.mkdirs())) {
            throw new InvocationTargetException(new Exception(PDEPlugin.getResourceString("ExportWizard.badDirectory")));
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doExport(String featureID, String version, String featureLocation, String os, String ws, String arch, IProgressMonitor monitor) throws CoreException, InvocationTargetException {
        monitor.beginTask("", 5);
        monitor.setTaskName(PDEPlugin.getResourceString("FeatureExportJob.taskName"));
        try {
            HashMap properties = this.createBuildProperties(os, ws, arch);
            this.makeScript(featureID, version, os, ws, arch, featureLocation);
            monitor.worked(1);
            this.runScript(this.getBuildScriptName(featureLocation), this.getBuildExecutionTargets(), properties, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
            this.runScript(this.getAssemblyScriptName(featureID, os, ws, arch, featureLocation), new String[]{"main"}, properties, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var9_11 = null;
        }
        monitor.done();
    }

    protected HashMap createBuildProperties(String os, String ws, String arch) {
        if (this.fBuildProperties == null) {
            this.fBuildProperties = new HashMap(15);
            this.fBuildProperties.put("buildTempFolder", String.valueOf(this.fBuildTempLocation) + "/destination");
            this.fBuildProperties.put("temp.folder", String.valueOf(this.fBuildTempLocation) + "/temp.folder");
            this.fBuildProperties.put("feature.temp.folder", String.valueOf(this.fBuildTempLocation) + "/destination");
            this.fBuildProperties.put("include.children", "true");
            this.fBuildProperties.put("eclipse.running", "true");
            this.fBuildProperties.put("baseos", os);
            this.fBuildProperties.put("basews", ws);
            this.fBuildProperties.put("basearch", arch);
            this.fBuildProperties.put("basenl", TargetPlatform.getNL());
            this.fBuildProperties.put("bootclasspath", BaseBuildAction.getBootClasspath());
            IPreferenceStore store = PDEPlugin.getDefault().getPreferenceStore();
            this.fBuildProperties.put("javacFailOnError", "false");
            this.fBuildProperties.put("javacDebugInfo", store.getBoolean("javacDebugInfo") ? "on" : "off");
            this.fBuildProperties.put("javacVerbose", store.getString("javacVerbose"));
            Preferences pref = JavaCore.getPlugin().getPluginPreferences();
            this.fBuildProperties.put("javacSource", pref.getString("org.eclipse.jdt.core.compiler.source"));
            this.fBuildProperties.put("javacTarget", pref.getString("org.eclipse.jdt.core.compiler.codegen.targetPlatform"));
            this.fBuildProperties.put("buildDirectory", String.valueOf(this.fBuildTempLocation) + "/assemblyLocation");
            this.fBuildProperties.put("buildLabel", ".");
            this.fBuildProperties.put("collectingFolder", ".");
            String prefix = Platform.getOS().equals("macosx") ? "." : "";
            this.fBuildProperties.put("archivePrefix", prefix);
            if (this.fExportType == 0) {
                this.fBuildProperties.put("archiveFullPath", String.valueOf(this.fDestinationDirectory) + File.separator + this.fZipFilename);
            } else {
                this.fBuildProperties.put("assemblyTempDir", this.fDestinationDirectory);
            }
        }
        return this.fBuildProperties;
    }

    private void makeScript(String featureID, String versionId, String os, String ws, String arch, String featureLocation) throws CoreException {
        BuildScriptGenerator generator = new BuildScriptGenerator();
        generator.setBuildingOSGi(PDECore.getDefault().getModelManager().isOSGiRuntime());
        generator.setChildren(true);
        generator.setWorkingDirectory(featureLocation);
        generator.setDevEntries(this.getDevProperties());
        generator.setElements(new String[]{"feature@" + featureID + (versionId == null ? "" : ":" + versionId)});
        generator.setPluginPath(this.getPaths());
        String format = this.fExportType == 0 ? (Platform.getOS().equals("macosx") ? "tarGz" : "antZip") : "folder";
        BuildScriptGenerator.setOutputFormat((String)format);
        BuildScriptGenerator.setForceUpdateJar((this.fExportType == 2 ? 1 : 0) != 0);
        BuildScriptGenerator.setEmbeddedSource((this.fExportSource && this.fExportType != 2 ? 1 : 0) != 0);
        BuildScriptGenerator.setConfigInfo((String)(String.valueOf(os) + "," + ws + "," + arch));
        generator.generate();
    }

    private String getDevProperties() {
        if (this.fDevProperties == null) {
            this.fDevProperties = ClasspathHelper.getDevEntriesProperties(String.valueOf(this.fBuildTempLocation) + "/dev.properties", false);
        }
        return this.fDevProperties;
    }

    protected void runScript(String location, String[] targets, Map properties, IProgressMonitor monitor) throws InvocationTargetException, CoreException {
        AntRunner runner = new AntRunner();
        runner.addUserProperties(properties);
        runner.setAntHome(location);
        runner.setBuildFileLocation(location);
        runner.addBuildListener("org.eclipse.pde.internal.ui.ant.ExportBuildListener");
        runner.setExecutionTargets(targets);
        runner.run(monitor);
    }

    private String getBuildScriptName(String featureLocation) {
        return String.valueOf(featureLocation) + '/' + "build.xml";
    }

    protected String getAssemblyScriptName(String featureID, String os, String ws, String arch, String featureLocation) {
        return String.valueOf(featureLocation) + '/' + "assemble." + featureID + "." + os + "." + ws + "." + arch + ".xml";
    }

    private String[] getBuildExecutionTargets() {
        if (this.fExportSource && this.fExportType != 2) {
            return new String[]{"build.jars", "build.sources", "gather.logs"};
        }
        return new String[]{"build.jars", "gather.logs"};
    }

    public void deleteBuildFiles(IModel model) throws CoreException {
        int i;
        File dir;
        Object[] children;
        String directory;
        if (model == null) {
            return;
        }
        String string = directory = model instanceof IFeatureModel ? ((IFeatureModel)model).getInstallLocation() : ((IPluginModelBase)model).getInstallLocation();
        if (model.getUnderlyingResource() != null && !this.isCustomBuild(model) && (children = (dir = new File(directory)).listFiles()) != null) {
            i = 0;
            while (i < children.length) {
                String filename;
                if (!children[i].isDirectory() && ((filename = children[i].getName()).equals("build.xml") || filename.startsWith("assemble.") && filename.endsWith(".xml"))) {
                    children[i].delete();
                }
                ++i;
            }
        }
        if (model instanceof IFeatureModel) {
            IFeature feature = ((IFeatureModel)model).getFeature();
            children = feature.getIncludedFeatures();
            i = 0;
            while (i < children.length) {
                IFeature ref = ((FeatureChild)children[i]).getReferencedFeature();
                if (ref != null) {
                    this.deleteBuildFiles((IModel)ref.getModel());
                }
                ++i;
            }
            IFeaturePlugin[] plugins = feature.getPlugins();
            PluginModelManager manager = PDECore.getDefault().getModelManager();
            int i2 = 0;
            while (i2 < plugins.length) {
                ModelEntry entry = manager.findEntry(plugins[i2].getId());
                if (entry != null) {
                    this.deleteBuildFiles((IModel)entry.getActiveModel());
                }
                ++i2;
            }
        }
    }

    protected boolean isCustomBuild(IModel model) throws CoreException {
        IBuild build;
        IBuildEntry entry;
        WorkspaceBuildModel buildModel = null;
        IFile buildFile = model.getUnderlyingResource().getProject().getFile("build.properties");
        if (buildFile.exists()) {
            buildModel = new WorkspaceBuildModel(buildFile);
            buildModel.load();
        }
        if (buildModel != null && (entry = (build = buildModel.getBuild()).getEntry("custom")) != null) {
            String[] tokens = entry.getTokens();
            int i = 0;
            while (i < tokens.length) {
                if (tokens[i].equals("true")) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    protected String[] getPaths() throws CoreException {
        ArrayList<String> paths = new ArrayList<String>();
        IFeatureModel[] models = PDECore.getDefault().getWorkspaceModelManager().getFeatureModels();
        int i = 0;
        while (i < models.length) {
            paths.add(String.valueOf(models[i].getInstallLocation()) + '/' + "feature.xml");
            ++i;
        }
        String[] plugins = TargetPlatform.createPluginPath();
        String[] features = paths.toArray(new String[paths.size()]);
        String[] all = new String[plugins.length + paths.size()];
        System.arraycopy(plugins, 0, all, 0, plugins.length);
        System.arraycopy(features, 0, all, plugins.length, features.length);
        return all;
    }

    private static void createLogWriter() {
        try {
            String path = PDEPlugin.getDefault().getStateLocation().toOSString();
            logFile = new File(path, "exportLog.txt");
            if (logFile.exists()) {
                logFile.delete();
                logFile.createNewFile();
            }
            writer = new PrintWriter((Writer)new FileWriter(logFile), true);
        }
        catch (IOException iOException) {}
    }

    public static PrintWriter getWriter() {
        if (writer == null) {
            FeatureExportJob.createLogWriter();
        }
        return writer;
    }

    /*
     * Exception decompiling
     */
    protected void cleanup(IProgressMonitor monitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [3 : 192->196)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private File createScriptFile() throws IOException {
        String path = PDEPlugin.getDefault().getStateLocation().toOSString();
        File zip = new File(path, "zip.xml");
        if (zip.exists()) {
            zip.delete();
            zip.createNewFile();
        }
        return zip;
    }

    private void generateHeader(PrintWriter writer) {
        writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        writer.println("<project name=\"temp\" default=\"clean\" basedir=\".\">");
    }

    private void generateCleanTarget(PrintWriter writer) {
        writer.println("<target name=\"clean\">");
        writer.println("<delete dir=\"" + this.fBuildTempLocation + "\"/>");
        writer.println("</target>");
    }

    private void generateDeleteZipTarget(PrintWriter writer) {
        writer.println("<target name=\"deleteZip\">");
        writer.println("<delete file=\"" + this.fDestinationDirectory + "/logs.zip\"/>");
        writer.println("</target>");
    }

    private boolean generateZipLogsTarget(PrintWriter writer) {
        if (logFile != null && logFile.exists() && logFile.length() > 0L) {
            writer.println("<target name=\"zip.logs\">");
            writer.println("<zip zipfile=\"" + this.fDestinationDirectory + "/logs.zip\" basedir=\"" + this.fBuildTempLocation + "/temp.folder\"/>");
            writer.println("</target>");
            return true;
        }
        return false;
    }

    private void generateClosingTag(PrintWriter writer) {
        writer.println("</project>");
    }

    public static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    private void asyncNotifyExportException(String errorMessage) {
        FeatureExportJob.getStandardDisplay().beep();
        MessageDialog.openError((Shell)PDEPlugin.getActiveWorkbenchShell(), (String)PDEPlugin.getResourceString("FeatureExportJob.error"), (String)errorMessage);
        this.done((IStatus)new Status(0, PDEPlugin.getPluginId(), 0, "", null));
    }

    protected String getLogFoundMessage() {
        return PDEPlugin.getFormattedMessage("ExportJob.error.message", String.valueOf(this.fDestinationDirectory) + File.separator + "logs.zip");
    }

    class SchedulingRule
    implements ISchedulingRule {
        SchedulingRule() {
        }

        public boolean contains(ISchedulingRule rule) {
            return rule instanceof SchedulingRule;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return rule instanceof SchedulingRule;
        }
    }
}

