/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards;

import java.util.HashSet;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.pde.core.plugin.IFragment;
import org.eclipse.pde.core.plugin.IPlugin;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.ModelEntry;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PluginModelManager;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class PluginSelectionDialog
extends ElementListSelectionDialog {
    public PluginSelectionDialog(Shell parentShell, boolean includeFragments, boolean multipleSelection) {
        this(parentShell, PluginSelectionDialog.getElements(includeFragments), multipleSelection);
    }

    public PluginSelectionDialog(Shell parentShell, IPluginModelBase[] models, boolean multipleSelection) {
        super(parentShell, (ILabelProvider)PDEPlugin.getDefault().getLabelProvider());
        this.setTitle(PDEPlugin.getResourceString("PluginSelectionDialog.title"));
        this.setMessage(PDEPlugin.getResourceString("PluginSelectionDialog.message"));
        this.setElements(models);
        this.setMultipleSelection(multipleSelection);
        PDEPlugin.getDefault().getLabelProvider().connect((Object)this);
    }

    public boolean close() {
        PDEPlugin.getDefault().getLabelProvider().disconnect((Object)this);
        return super.close();
    }

    private static IPluginModelBase[] getElements(boolean includeFragments) {
        PluginModelManager manager = PDECore.getDefault().getModelManager();
        return includeFragments ? manager.getPlugins() : manager.getPluginsOnly();
    }

    public static HashSet getExistingImports(IPluginBase model) {
        IPlugin parent;
        HashSet<String> existingImports = new HashSet<String>();
        if (!PDECore.getDefault().getModelManager().isOSGiRuntime()) {
            existingImports.add("org.eclipse.core.boot");
            existingImports.add("org.eclipse.core.runtime");
        }
        PluginSelectionDialog.addSelfAndDirectImports(existingImports, model);
        if (model instanceof IFragment && (parent = PluginSelectionDialog.getParentPlugin((IFragment)model)) != null) {
            PluginSelectionDialog.addSelfAndDirectImports(existingImports, (IPluginBase)parent);
        }
        return existingImports;
    }

    private static IPlugin getParentPlugin(IFragment fragment) {
        String targetId = fragment.getPluginId();
        String targetVersion = fragment.getPluginVersion();
        int match = fragment.getRule();
        return PDECore.getDefault().findPlugin(targetId, targetVersion, match);
    }

    private static void addSelfAndDirectImports(HashSet set, IPluginBase pluginBase) {
        set.add(pluginBase.getId());
        IPluginImport[] imports = pluginBase.getImports();
        int i = 0;
        while (i < imports.length) {
            String id = imports[i].getId();
            if (set.add(id)) {
                PluginSelectionDialog.addReexportedImport(set, id);
            }
            ++i;
        }
    }

    private static void addReexportedImport(HashSet set, String id) {
        PluginModelManager manager = PDECore.getDefault().getModelManager();
        ModelEntry entry = manager.findEntry(id);
        if (entry != null) {
            IPluginModelBase model = entry.getActiveModel();
            IPluginImport[] imports = model.getPluginBase().getImports();
            int i = 0;
            while (i < imports.length) {
                if (imports[i].isReexported() && set.add(imports[i].getId())) {
                    PluginSelectionDialog.addReexportedImport(set, imports[i].getId());
                }
                ++i;
            }
        }
    }
}

