/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.view;

import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.pde.core.plugin.IPlugin;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.IPluginModelListener;
import org.eclipse.pde.internal.core.ModelEntry;
import org.eclipse.pde.internal.core.PluginModelDelta;
import org.eclipse.pde.internal.core.PluginModelManager;
import org.eclipse.pde.internal.core.plugin.ImportObject;
import org.eclipse.pde.internal.ui.elements.DefaultContentProvider;
import org.eclipse.pde.internal.ui.view.DependenciesView;

public class DependenciesContentProvider
extends DefaultContentProvider
implements ITreeContentProvider,
IStructuredContentProvider,
IPluginModelListener {
    private PluginModelManager manager;
    private TreeViewer viewer;
    private DependenciesView view;

    public DependenciesContentProvider(DependenciesView view, PluginModelManager manager) {
        this.manager = manager;
        manager.addPluginModelListener((IPluginModelListener)this);
        this.view = view;
    }

    public void dispose() {
        this.manager.removePluginModelListener((IPluginModelListener)this);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = (TreeViewer)viewer;
        if (newInput == null) {
            return;
        }
        this.view.updateTitle(newInput);
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IPluginModelBase) {
            return new Object[]{((IPluginModelBase)parentElement).getPluginBase()};
        }
        if (parentElement instanceof IPluginBase) {
            return this.createImportObjects((IPluginBase)parentElement);
        }
        if (parentElement instanceof ImportObject) {
            ImportObject iobj = (ImportObject)parentElement;
            IPlugin plugin = iobj.getPlugin();
            if (plugin == null) {
                return new Object[0];
            }
            return this.createImportObjects((IPluginBase)plugin);
        }
        return new Object[0];
    }

    private Object[] createImportObjects(IPluginBase plugin) {
        IPluginImport[] imports = plugin.getImports();
        Object[] result = new Object[imports.length];
        int i = 0;
        while (i < imports.length) {
            result[i] = new ImportObject(imports[i]);
            ++i;
        }
        return result;
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void modelsChanged(final PluginModelDelta delta) {
        if (this.viewer == null || this.viewer.getTree().isDisposed()) {
            return;
        }
        this.viewer.getTree().getDisplay().asyncExec(new Runnable(){

            public void run() {
                int kind = delta.getKind();
                if (DependenciesContentProvider.this.viewer.getTree().isDisposed()) {
                    return;
                }
                if ((kind & 4) != 0 || (kind & 1) != 0) {
                    DependenciesContentProvider.this.viewer.refresh();
                    return;
                }
                if ((kind & 2) != 0) {
                    ModelEntry[] removed = delta.getRemovedEntries();
                    DependenciesContentProvider.this.handleRemoved(removed);
                }
                if ((kind & 1) != 0) {
                    DependenciesContentProvider.this.viewer.refresh();
                }
            }
        });
    }

    private void handleRemoved(ModelEntry[] removed) {
        int i = 0;
        while (i < removed.length) {
            ModelEntry entry = removed[i];
            IPluginModelBase model = entry.getActiveModel();
            if (model != null && model.equals(this.viewer.getInput())) {
                this.viewer.setInput(null);
                return;
            }
            ++i;
        }
        this.viewer.refresh();
    }
}

