/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.preferences;

import java.util.Locale;
import java.util.StringTokenizer;
import org.eclipse.core.boot.BootLoader;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.pde.internal.core.IEnvironmentVariables;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.help.WorkbenchHelp;

public class TargetEnvironmentPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
IEnvironmentVariables {
    private static final String KEY_DESCRIPTION = "Preferences.TargetEnvironmentPage.Description";
    public static final String KEY_OS = "Preferences.TargetEnvironmentPage.os";
    public static final String KEY_WS = "Preferences.TargetEnvironmentPage.ws";
    public static final String KEY_NL = "Preferences.TargetEnvironmentPage.nl";
    public static final String KEY_ARCH = "Preferences.TargetEnvironmentPage.arch";
    private Combo os;
    private Combo ws;
    private Combo nl;
    private Combo arch;
    private Preferences preferences;

    public TargetEnvironmentPreferencePage() {
        this.setDescription(PDEPlugin.getResourceString(KEY_DESCRIPTION));
        this.preferences = PDECore.getDefault().getPluginPreferences();
    }

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        container.setLayout((Layout)layout);
        Label label = new Label(container, 0);
        label.setText(PDEPlugin.getResourceString(KEY_OS));
        this.os = new Combo(container, 2060);
        this.os.setLayoutData((Object)new GridData(768));
        this.os.setItems(BootLoader.knownOSValues());
        label = new Label(container, 0);
        label.setText(PDEPlugin.getResourceString(KEY_WS));
        this.ws = new Combo(container, 2060);
        this.ws.setLayoutData((Object)new GridData(768));
        this.ws.setItems(BootLoader.knownWSValues());
        label = new Label(container, 0);
        label.setText(PDEPlugin.getResourceString(KEY_NL));
        this.nl = new Combo(container, 2060);
        this.nl.setLayoutData((Object)new GridData(768));
        this.nl.setItems(TargetEnvironmentPreferencePage.getLocales());
        label = new Label(container, 0);
        label.setText(PDEPlugin.getResourceString(KEY_ARCH));
        this.arch = new Combo(container, 2060);
        this.arch.setLayoutData((Object)new GridData(768));
        this.arch.setItems(BootLoader.knownOSArchValues());
        Dialog.applyDialogFont((Control)container);
        this.os.setText(this.preferences.getString("org.eclipse.pde.ui.os"));
        this.ws.setText(this.preferences.getString("org.eclipse.pde.ui.ws"));
        this.nl.setText(this.expandLocaleName(this.preferences.getString("org.eclipse.pde.ui.nl")));
        this.arch.setText(this.preferences.getString("org.eclipse.pde.ui.arch"));
        WorkbenchHelp.setHelp((Control)container, (String)"org.eclipse.pde.doc.user.target_environment_preference_page");
        return container;
    }

    protected void performDefaults() {
        this.os.setText(this.preferences.getDefaultString("org.eclipse.pde.ui.os"));
        this.ws.setText(this.preferences.getDefaultString("org.eclipse.pde.ui.ws"));
        this.nl.setText(this.expandLocaleName(this.preferences.getDefaultString("org.eclipse.pde.ui.nl")));
        this.arch.setText(this.preferences.getDefaultString("org.eclipse.pde.ui.arch"));
    }

    public boolean performOk() {
        this.preferences.setValue("org.eclipse.pde.ui.os", this.os.getText().trim());
        this.preferences.setValue("org.eclipse.pde.ui.ws", this.ws.getText().trim());
        String locale = this.nl.getText().trim();
        int dash = locale.indexOf("-");
        if (dash != -1) {
            locale = locale.substring(0, dash);
        }
        locale = locale.trim();
        this.preferences.setValue("org.eclipse.pde.ui.nl", locale);
        this.preferences.setValue("org.eclipse.pde.ui.arch", this.arch.getText().trim());
        PDEPlugin.getDefault().savePluginPreferences();
        return super.performOk();
    }

    public void init(IWorkbench workbench) {
    }

    private String expandLocaleName(String name) {
        String language = "";
        String country = "";
        String variant = "";
        StringTokenizer tokenizer = new StringTokenizer(name, "_");
        if (tokenizer.hasMoreTokens()) {
            language = tokenizer.nextToken();
        }
        if (tokenizer.hasMoreTokens()) {
            country = tokenizer.nextToken();
        }
        if (tokenizer.hasMoreTokens()) {
            variant = tokenizer.nextToken();
        }
        Locale locale = new Locale(language, country, variant);
        return String.valueOf(locale.toString()) + " - " + locale.getDisplayName();
    }

    private static String[] getLocales() {
        Locale[] locales = Locale.getAvailableLocales();
        String[] result = new String[locales.length];
        int i = 0;
        while (i < locales.length) {
            Locale locale = locales[i];
            result[i] = String.valueOf(locale.toString()) + " - " + locale.getDisplayName();
            ++i;
        }
        return result;
    }
}

