/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.launcher;

import java.util.ArrayList;
import java.util.TreeSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.StandardSourcePathProvider;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.SearchablePluginsManager;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.launcher.LauncherUtils;

public class WorkbenchSourcePathProvider
extends StandardSourcePathProvider {
    public IRuntimeClasspathEntry[] computeUnresolvedClasspath(ILaunchConfiguration configuration) throws CoreException {
        boolean defaultPath = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_SOURCE_PATH, true);
        if (!defaultPath) {
            return this.recoverRuntimePath(configuration, IJavaLaunchConfigurationConstants.ATTR_SOURCE_PATH);
        }
        ArrayList<IRuntimeClasspathEntry> sourcePath = new ArrayList<IRuntimeClasspathEntry>();
        String vmInstallName = configuration.getAttribute("vminstall", LauncherUtils.getDefaultVMInstallName());
        IVMInstall[] vmInstallations = LauncherUtils.getAllVMInstances();
        IVMInstall jre = null;
        int i = 0;
        while (i < vmInstallations.length) {
            if (vmInstallName.equals(vmInstallations[i].getName())) {
                jre = vmInstallations[i];
                break;
            }
            ++i;
        }
        if (jre != null) {
            Path containerPath = new Path(JavaRuntime.JRE_CONTAINER);
            containerPath = containerPath.append(jre.getVMInstallType().getId());
            containerPath = containerPath.append(jre.getName());
            IRuntimeClasspathEntry entry = JavaRuntime.newRuntimeContainerClasspathEntry((IPath)containerPath, (int)2);
            sourcePath.add(entry);
        }
        IProject[] projects = this.getJavaProjects(configuration);
        int i2 = 0;
        while (i2 < projects.length) {
            sourcePath.add(JavaRuntime.newProjectRuntimeClasspathEntry((IJavaProject)JavaCore.create((IProject)projects[i2])));
            ++i2;
        }
        return sourcePath.toArray(new IRuntimeClasspathEntry[sourcePath.size()]);
    }

    private IProject[] getJavaProjects(ILaunchConfiguration configuration) throws CoreException {
        boolean useFeatures = configuration.getAttribute("usefeatures", false);
        boolean useDefault = configuration.getAttribute("default", true);
        IPluginModelBase[] models = PDECore.getDefault().getWorkspaceModelManager().getAllModels();
        TreeSet deselected = !useFeatures && !useDefault ? LauncherUtils.parseDeselectedWSIds(configuration) : new TreeSet();
        ArrayList<IProject> result = new ArrayList<IProject>();
        int i = 0;
        while (i < models.length) {
            IProject project;
            if (!deselected.contains(models[i].getPluginBase().getId()) && (project = models[i].getUnderlyingResource().getProject()).hasNature("org.eclipse.jdt.core.javanature")) {
                result.add(project);
            }
            ++i;
        }
        SearchablePluginsManager manager = PDECore.getDefault().getModelManager().getSearchablePluginsManager();
        IJavaProject proxy = manager.getProxyProject();
        if (proxy != null) {
            result.add(proxy.getProject());
        }
        IProject[] projects = result.toArray(new IProject[result.size()]);
        return PDEPlugin.getWorkspace().computeProjectOrder((IProject[])projects).projects;
    }

    public IRuntimeClasspathEntry[] resolveClasspath(IRuntimeClasspathEntry[] entries, ILaunchConfiguration configuration) throws CoreException {
        ArrayList<IRuntimeClasspathEntry> all = new ArrayList<IRuntimeClasspathEntry>(entries.length);
        int i = 0;
        while (i < entries.length) {
            if (entries[i].getType() == 1) {
                all.add(entries[i]);
                IResource resource = entries[i].getResource();
                if (resource instanceof IProject) {
                    IJavaProject project = JavaCore.create((IProject)((IProject)resource));
                    IPackageFragmentRoot[] roots = project.getPackageFragmentRoots();
                    int j = 0;
                    while (j < roots.length) {
                        if (roots[j].isArchive() && !this.isJRELibrary(roots[j])) {
                            IRuntimeClasspathEntry rte = JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)roots[j].getPath());
                            IPath path = roots[j].getSourceAttachmentPath();
                            if (path != null) {
                                rte.setSourceAttachmentPath(path);
                                rte.setSourceAttachmentRootPath(roots[j].getSourceAttachmentRootPath());
                            }
                            if (!all.contains(rte)) {
                                all.add(rte);
                            }
                        }
                        ++j;
                    }
                }
            } else {
                IRuntimeClasspathEntry[] resolved = JavaRuntime.resolveRuntimeClasspathEntry((IRuntimeClasspathEntry)entries[i], (ILaunchConfiguration)configuration);
                int j = 0;
                while (j < resolved.length) {
                    all.add(resolved[j]);
                    ++j;
                }
            }
            ++i;
        }
        return all.toArray(new IRuntimeClasspathEntry[all.size()]);
    }

    private boolean isJRELibrary(IPackageFragmentRoot root) {
        try {
            IPath path = root.getRawClasspathEntry().getPath();
            if (path.equals((Object)new Path(JavaRuntime.JRE_CONTAINER)) || path.equals((Object)new Path("JRE_LIB"))) {
                return true;
            }
        }
        catch (JavaModelException javaModelException) {}
        return false;
    }
}

